/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.PaymentGatewaysResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class PaymentGatewaysApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PaymentGatewaysApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PaymentGatewaysApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call getPaymentGatewaysCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/paymentgateways";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentGatewaysValidateBeforeCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        return this.getPaymentGatewaysCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected PaymentGatewaysResponse getPaymentGateways(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<PaymentGatewaysResponse> localVarResp = this.getPaymentGatewaysWithHttpInfo(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<PaymentGatewaysResponse> getPaymentGatewaysWithHttpInfo(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.getPaymentGatewaysValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<PaymentGatewaysResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getPaymentGatewaysAsync(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<PaymentGatewaysResponse> _callback) throws ApiException {
        Call localVarCall = this.getPaymentGatewaysValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<PaymentGatewaysResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPaymentGatewaysApi getPaymentGatewaysApi() {
        return new GetPaymentGatewaysApi();
    }

    public class GetPaymentGatewaysApi {
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private GetPaymentGatewaysApi() {
        }

        public GetPaymentGatewaysApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetPaymentGatewaysApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetPaymentGatewaysApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetPaymentGatewaysApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetPaymentGatewaysApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetPaymentGatewaysApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetPaymentGatewaysApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public GetPaymentGatewaysApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentGatewaysApi.this.getPaymentGatewaysCall(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public PaymentGatewaysResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentGatewaysApi.this.getPaymentGatewaysWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (PaymentGatewaysResponse)localVarResp.getData();
        }

        private ApiResponse<PaymentGatewaysResponse> executeWithHttpInfo() throws ApiException {
            return PaymentGatewaysApi.this.getPaymentGatewaysWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<PaymentGatewaysResponse> _callback) throws ApiException {
            return PaymentGatewaysApi.this.getPaymentGatewaysAsync(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }
}

