/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.CreateTokenRequestGrantType;
import com.zuora.model.TokenResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class OAuthApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public OAuthApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OAuthApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createTokenCall(String clientId, String clientSecret, CreateTokenRequestGrantType grantType, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/oauth/token";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (clientId != null) {
            localVarFormParams.put("client_id", clientId);
        }
        if (clientSecret != null) {
            localVarFormParams.put("client_secret", clientSecret);
        }
        if (grantType != null) {
            localVarFormParams.put("grant_type", (Object)grantType);
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-www-form-urlencoded"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createTokenValidateBeforeCall(String clientId, String clientSecret, CreateTokenRequestGrantType grantType, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (clientId == null) {
            throw new ApiException("Missing the required parameter 'clientId' when calling createToken(Async)");
        }
        if (clientSecret == null) {
            throw new ApiException("Missing the required parameter 'clientSecret' when calling createToken(Async)");
        }
        if (grantType == null) {
            throw new ApiException("Missing the required parameter 'grantType' when calling createToken(Async)");
        }
        return this.createTokenCall(clientId, clientSecret, grantType, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected TokenResponse createToken(String clientId, String clientSecret, CreateTokenRequestGrantType grantType, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<TokenResponse> localVarResp = this.createTokenWithHttpInfo(clientId, clientSecret, grantType, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<TokenResponse> createTokenWithHttpInfo(String clientId, String clientSecret, CreateTokenRequestGrantType grantType, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.createTokenValidateBeforeCall(clientId, clientSecret, grantType, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<TokenResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createTokenAsync(String clientId, String clientSecret, CreateTokenRequestGrantType grantType, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<TokenResponse> _callback) throws ApiException {
        Call localVarCall = this.createTokenValidateBeforeCall(clientId, clientSecret, grantType, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<TokenResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateTokenApi createTokenApi(String clientId, String clientSecret, CreateTokenRequestGrantType grantType) {
        return new CreateTokenApi(clientId, clientSecret, grantType);
    }

    public class CreateTokenApi {
        private final String clientId;
        private final String clientSecret;
        private final CreateTokenRequestGrantType grantType;
        private String zuoraTrackId;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private CreateTokenApi(String clientId, String clientSecret, CreateTokenRequestGrantType grantType) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.grantType = grantType;
        }

        public CreateTokenApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreateTokenApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CreateTokenApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public CreateTokenApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OAuthApi.this.createTokenCall(this.clientId, this.clientSecret, this.grantType, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public TokenResponse execute() throws ApiException {
            ApiResponse localVarResp = OAuthApi.this.createTokenWithHttpInfo(this.clientId, this.clientSecret, this.grantType, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (TokenResponse)localVarResp.getData();
        }

        private ApiResponse<TokenResponse> executeWithHttpInfo() throws ApiException {
            return OAuthApi.this.createTokenWithHttpInfo(this.clientId, this.clientSecret, this.grantType, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<TokenResponse> _callback) throws ApiException {
            return OAuthApi.this.createTokenAsync(this.clientId, this.clientSecret, this.grantType, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }
}

