/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.SubscriptionItemListResponse;
import org.openapitools.jackson.nullable.JsonNullable;

public class SubscriptionReplacePlanPatchResponse {
    public static final String SERIALIZED_NAME_PREVIOUS_SUBSCRIPTION_PLAN_ID = "previous_subscription_plan_id";
    @SerializedName(value="previous_subscription_plan_id")
    private String previousSubscriptionPlanId;
    public static final String SERIALIZED_NAME_PREVIOUS_PLAN_ID = "previous_plan_id";
    @SerializedName(value="previous_plan_id")
    private String previousPlanId;
    public static final String SERIALIZED_NAME_REPLACE_AT = "replace_at";
    @SerializedName(value="replace_at")
    private ReplaceAtEnum replaceAt;
    public static final String SERIALIZED_NAME_REPLACEMENT_TYPE = "replacement_type";
    @SerializedName(value="replacement_type")
    private ReplacementTypeEnum replacementType;
    public static final String SERIALIZED_NAME_UNIQUE_TOKEN = "unique_token";
    @SerializedName(value="unique_token")
    private String uniqueToken;
    public static final String SERIALIZED_NAME_PLAN_ID = "plan_id";
    @SerializedName(value="plan_id")
    private String planId;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, String> customFields = null;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_ITEMS = "subscription_items";
    @SerializedName(value="subscription_items")
    private SubscriptionItemListResponse subscriptionItems;

    public SubscriptionReplacePlanPatchResponse previousSubscriptionPlanId(String previousSubscriptionPlanId) {
        this.previousSubscriptionPlanId = previousSubscriptionPlanId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the subscription plan.")
    public String getPreviousSubscriptionPlanId() {
        return this.previousSubscriptionPlanId;
    }

    public void setPreviousSubscriptionPlanId(String previousSubscriptionPlanId) {
        this.previousSubscriptionPlanId = previousSubscriptionPlanId;
    }

    public SubscriptionReplacePlanPatchResponse previousPlanId(String previousPlanId) {
        this.previousPlanId = previousPlanId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the plan to be removed. Only provide one of `previous_plan_id` or `subscription_plan_id` in your request, not both.")
    public String getPreviousPlanId() {
        return this.previousPlanId;
    }

    public void setPreviousPlanId(String previousPlanId) {
        this.previousPlanId = previousPlanId;
    }

    public SubscriptionReplacePlanPatchResponse replaceAt(ReplaceAtEnum replaceAt) {
        this.replaceAt = replaceAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date when the replacement occurs. It can be either the current date or the end of the current billing period.")
    public ReplaceAtEnum getReplaceAt() {
        return this.replaceAt;
    }

    public void setReplaceAt(ReplaceAtEnum replaceAt) {
        this.replaceAt = replaceAt;
    }

    public SubscriptionReplacePlanPatchResponse replacementType(ReplacementTypeEnum replacementType) {
        this.replacementType = replacementType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the replacement.")
    public ReplacementTypeEnum getReplacementType() {
        return this.replacementType;
    }

    public void setReplacementType(ReplacementTypeEnum replacementType) {
        this.replacementType = replacementType;
    }

    public SubscriptionReplacePlanPatchResponse uniqueToken(String uniqueToken) {
        this.uniqueToken = uniqueToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique string to represent the subscription plan in the order. The unique token is used to perform multiple actions against a newly added subscription plan. For example, if you want to add and update a product in the same order, assign a unique token to the newly added subscription plan and use that token in future order actions.")
    public String getUniqueToken() {
        return this.uniqueToken;
    }

    public void setUniqueToken(String uniqueToken) {
        this.uniqueToken = uniqueToken;
    }

    public SubscriptionReplacePlanPatchResponse planId(String planId) {
        this.planId = planId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the subscription plan to be updated. It can be the latest version or any history version id.")
    public String getPlanId() {
        return this.planId;
    }

    public void setPlanId(String planId) {
        this.planId = planId;
    }

    public SubscriptionReplacePlanPatchResponse customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public SubscriptionReplacePlanPatchResponse putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    public SubscriptionReplacePlanPatchResponse subscriptionItems(SubscriptionItemListResponse subscriptionItems) {
        this.subscriptionItems = subscriptionItems;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SubscriptionItemListResponse getSubscriptionItems() {
        return this.subscriptionItems;
    }

    public void setSubscriptionItems(SubscriptionItemListResponse subscriptionItems) {
        this.subscriptionItems = subscriptionItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionReplacePlanPatchResponse subscriptionReplacePlanPatchResponse = (SubscriptionReplacePlanPatchResponse)o;
        return Objects.equals(this.previousSubscriptionPlanId, subscriptionReplacePlanPatchResponse.previousSubscriptionPlanId) && Objects.equals(this.previousPlanId, subscriptionReplacePlanPatchResponse.previousPlanId) && Objects.equals((Object)this.replaceAt, (Object)subscriptionReplacePlanPatchResponse.replaceAt) && Objects.equals((Object)this.replacementType, (Object)subscriptionReplacePlanPatchResponse.replacementType) && Objects.equals(this.uniqueToken, subscriptionReplacePlanPatchResponse.uniqueToken) && Objects.equals(this.planId, subscriptionReplacePlanPatchResponse.planId) && Objects.equals(this.customFields, subscriptionReplacePlanPatchResponse.customFields) && Objects.equals(this.subscriptionItems, subscriptionReplacePlanPatchResponse.subscriptionItems);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.previousSubscriptionPlanId, this.previousPlanId, this.replaceAt, this.replacementType, this.uniqueToken, this.planId, this.customFields, this.subscriptionItems});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionReplacePlanPatchResponse {\n");
        sb.append("    previousSubscriptionPlanId: ").append(this.toIndentedString(this.previousSubscriptionPlanId)).append("\n");
        sb.append("    previousPlanId: ").append(this.toIndentedString(this.previousPlanId)).append("\n");
        sb.append("    replaceAt: ").append(this.toIndentedString((Object)this.replaceAt)).append("\n");
        sb.append("    replacementType: ").append(this.toIndentedString((Object)this.replacementType)).append("\n");
        sb.append("    uniqueToken: ").append(this.toIndentedString(this.uniqueToken)).append("\n");
        sb.append("    planId: ").append(this.toIndentedString(this.planId)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    subscriptionItems: ").append(this.toIndentedString(this.subscriptionItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ReplacementTypeEnum {
        UPGRADE("upgrade"),
        DOWNGRADE("downgrade"),
        CROSSGRADE("crossgrade"),
        OTHER("other"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private ReplacementTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ReplacementTypeEnum fromValue(String value) {
            for (ReplacementTypeEnum b : ReplacementTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ReplacementTypeEnum> {
            public void write(JsonWriter jsonWriter, ReplacementTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ReplacementTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ReplacementTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ReplaceAtEnum {
        NOW("now"),
        END_OF_BILLING_PERIOD("end_of_billing_period"),
        SPECIFIC_DATE("specific_date"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private ReplaceAtEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ReplaceAtEnum fromValue(String value) {
            for (ReplaceAtEnum b : ReplaceAtEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ReplaceAtEnum> {
            public void write(JsonWriter jsonWriter, ReplaceAtEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ReplaceAtEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ReplaceAtEnum.fromValue(value);
            }
        }
    }
}

