/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.GetByIdQueryParams;
import org.openapitools.client.model.Headers;
import org.openapitools.client.model.ListQueryParams;
import org.openapitools.client.model.Refund;
import org.openapitools.client.model.RefundCreateRequest;
import org.openapitools.client.model.RefundListResponse;
import org.openapitools.client.model.RefundPatchRequest;

public class RefundsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public RefundsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RefundsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call cancelRefundCall(String refundId, List<String> fields, List<String> refundFields, List<String> accountFields, List<String> paymentMethodFields, List<String> appliedToFields, List<String> refundAppliedToItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/refunds/{refund_id}/cancel".replace("{refund_id}", this.localVarApiClient.escapeString(refundId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (refundFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "refund.fields[]", refundFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (paymentMethodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_method.fields[]", paymentMethodFields));
        }
        if (appliedToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "applied_to.fields[]", appliedToFields));
        }
        if (refundAppliedToItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "refund_applied_to_item.fields[]", refundAppliedToItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelRefundValidateBeforeCall(String refundId, List<String> fields, List<String> refundFields, List<String> accountFields, List<String> paymentMethodFields, List<String> appliedToFields, List<String> refundAppliedToItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (refundId == null) {
            throw new ApiException("Missing the required parameter 'refundId' when calling cancelRefund(Async)");
        }
        return this.cancelRefundCall(refundId, fields, refundFields, accountFields, paymentMethodFields, appliedToFields, refundAppliedToItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Refund> cancelRefundWithHttpInfo(String refundId, List<String> fields, List<String> refundFields, List<String> accountFields, List<String> paymentMethodFields, List<String> appliedToFields, List<String> refundAppliedToItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.cancelRefundValidateBeforeCall(refundId, fields, refundFields, accountFields, paymentMethodFields, appliedToFields, refundAppliedToItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Refund>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call cancelRefundAsync(String refundId, List<String> fields, List<String> refundFields, List<String> accountFields, List<String> paymentMethodFields, List<String> appliedToFields, List<String> refundAppliedToItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Refund> _callback) throws ApiException {
        Call localVarCall = this.cancelRefundValidateBeforeCall(refundId, fields, refundFields, accountFields, paymentMethodFields, appliedToFields, refundAppliedToItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Refund>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CancelRefundParams cancelRefundParams(String refundId) {
        return new CancelRefundParams(refundId);
    }

    public Refund cancelRefund(String refundId) throws ApiException {
        CancelRefundParams params = new CancelRefundParams(refundId);
        return this.executeCancelRefundAPICall(params).getData();
    }

    public Refund cancelRefund(String refundId, List<String> expand) throws ApiException {
        CancelRefundParams params = new CancelRefundParams(refundId);
        params.expand(expand);
        return this.executeCancelRefundAPICall(params).getData();
    }

    public Refund cancelRefund(String refundId, List<String> expand, Headers headers) throws ApiException {
        CancelRefundParams params = new CancelRefundParams(refundId).expand(expand).headers(headers);
        return this.executeCancelRefundAPICall(params).getData();
    }

    public Refund cancel(CancelRefundParams params) throws ApiException {
        return this.executeCancelRefundAPICall(params).getData();
    }

    public ApiResponse<Refund> cancelWithHttpInfo(CancelRefundParams params) throws ApiException {
        return this.executeCancelRefundAPICall(params);
    }

    ApiResponse<Refund> executeCancelRefundAPICall(CancelRefundParams params) throws ApiException {
        return this.cancelRefundWithHttpInfo(params.refundId, params.fields, params.refundFields, params.accountFields, params.paymentMethodFields, params.appliedToFields, params.refundAppliedToItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call createRefundCall(RefundCreateRequest refundCreateRequest, List<String> fields, List<String> refundFields, List<String> accountFields, List<String> paymentMethodFields, List<String> appliedToFields, List<String> refundAppliedToItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RefundCreateRequest localVarPostBody = refundCreateRequest;
        String localVarPath = "/refunds";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (refundFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "refund.fields[]", refundFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (paymentMethodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_method.fields[]", paymentMethodFields));
        }
        if (appliedToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "applied_to.fields[]", appliedToFields));
        }
        if (refundAppliedToItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "refund_applied_to_item.fields[]", refundAppliedToItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createRefundValidateBeforeCall(RefundCreateRequest refundCreateRequest, List<String> fields, List<String> refundFields, List<String> accountFields, List<String> paymentMethodFields, List<String> appliedToFields, List<String> refundAppliedToItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (refundCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'refundCreateRequest' when calling createRefund(Async)");
        }
        return this.createRefundCall(refundCreateRequest, fields, refundFields, accountFields, paymentMethodFields, appliedToFields, refundAppliedToItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Refund> createRefundWithHttpInfo(RefundCreateRequest refundCreateRequest, List<String> fields, List<String> refundFields, List<String> accountFields, List<String> paymentMethodFields, List<String> appliedToFields, List<String> refundAppliedToItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createRefundValidateBeforeCall(refundCreateRequest, fields, refundFields, accountFields, paymentMethodFields, appliedToFields, refundAppliedToItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Refund>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createRefundAsync(RefundCreateRequest refundCreateRequest, List<String> fields, List<String> refundFields, List<String> accountFields, List<String> paymentMethodFields, List<String> appliedToFields, List<String> refundAppliedToItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Refund> _callback) throws ApiException {
        Call localVarCall = this.createRefundValidateBeforeCall(refundCreateRequest, fields, refundFields, accountFields, paymentMethodFields, appliedToFields, refundAppliedToItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Refund>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateRefundParams createRefundParams(RefundCreateRequest refundCreateRequest) {
        return new CreateRefundParams(refundCreateRequest);
    }

    public Refund createRefund(RefundCreateRequest refundCreateRequest) throws ApiException {
        CreateRefundParams params = new CreateRefundParams(refundCreateRequest);
        return this.executeCreateRefundAPICall(params).getData();
    }

    public Refund createRefund(RefundCreateRequest refundCreateRequest, List<String> expand) throws ApiException {
        CreateRefundParams params = new CreateRefundParams(refundCreateRequest);
        params.expand(expand);
        return this.executeCreateRefundAPICall(params).getData();
    }

    public Refund createRefund(RefundCreateRequest refundCreateRequest, List<String> expand, Headers headers) throws ApiException {
        CreateRefundParams params = new CreateRefundParams(refundCreateRequest).expand(expand).headers(headers);
        return this.executeCreateRefundAPICall(params).getData();
    }

    public Refund create(CreateRefundParams params) throws ApiException {
        return this.executeCreateRefundAPICall(params).getData();
    }

    public ApiResponse<Refund> createWithHttpInfo(CreateRefundParams params) throws ApiException {
        return this.executeCreateRefundAPICall(params);
    }

    ApiResponse<Refund> executeCreateRefundAPICall(CreateRefundParams params) throws ApiException {
        return this.createRefundWithHttpInfo(params.refundCreateRequest, params.fields, params.refundFields, params.accountFields, params.paymentMethodFields, params.appliedToFields, params.refundAppliedToItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call deleteRefundCall(String refundId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/refunds/{refund_id}".replace("{refund_id}", this.localVarApiClient.escapeString(refundId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteRefundValidateBeforeCall(String refundId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (refundId == null) {
            throw new ApiException("Missing the required parameter 'refundId' when calling deleteRefund(Async)");
        }
        return this.deleteRefundCall(refundId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Void> deleteRefundWithHttpInfo(String refundId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.deleteRefundValidateBeforeCall(refundId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteRefundAsync(String refundId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteRefundValidateBeforeCall(refundId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public DeleteRefundParams deleteRefundParams(String refundId) {
        return new DeleteRefundParams(refundId);
    }

    public void deleteRefund(String refundId) throws ApiException {
        DeleteRefundParams params = new DeleteRefundParams(refundId);
        this.executeDeleteRefundAPICall(params);
    }

    public void deleteRefund(String refundId, Headers headers) throws ApiException {
        DeleteRefundParams params = new DeleteRefundParams(refundId).headers(headers);
        this.executeDeleteRefundAPICall(params);
    }

    public void delete(DeleteRefundParams params) throws ApiException {
        this.executeDeleteRefundAPICall(params).getData();
    }

    public ApiResponse<Void> deleteWithHttpInfo(DeleteRefundParams params) throws ApiException {
        return this.executeDeleteRefundAPICall(params);
    }

    ApiResponse<Void> executeDeleteRefundAPICall(DeleteRefundParams params) throws ApiException {
        return this.deleteRefundWithHttpInfo(params.refundId, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getRefundCall(String refundId, List<String> fields, List<String> refundFields, List<String> accountFields, List<String> paymentMethodFields, List<String> appliedToFields, List<String> refundAppliedToItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/refunds/{refund_id}".replace("{refund_id}", this.localVarApiClient.escapeString(refundId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (refundFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "refund.fields[]", refundFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (paymentMethodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_method.fields[]", paymentMethodFields));
        }
        if (appliedToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "applied_to.fields[]", appliedToFields));
        }
        if (refundAppliedToItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "refund_applied_to_item.fields[]", refundAppliedToItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRefundValidateBeforeCall(String refundId, List<String> fields, List<String> refundFields, List<String> accountFields, List<String> paymentMethodFields, List<String> appliedToFields, List<String> refundAppliedToItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (refundId == null) {
            throw new ApiException("Missing the required parameter 'refundId' when calling getRefund(Async)");
        }
        return this.getRefundCall(refundId, fields, refundFields, accountFields, paymentMethodFields, appliedToFields, refundAppliedToItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Refund> getRefundWithHttpInfo(String refundId, List<String> fields, List<String> refundFields, List<String> accountFields, List<String> paymentMethodFields, List<String> appliedToFields, List<String> refundAppliedToItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getRefundValidateBeforeCall(refundId, fields, refundFields, accountFields, paymentMethodFields, appliedToFields, refundAppliedToItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Refund>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getRefundAsync(String refundId, List<String> fields, List<String> refundFields, List<String> accountFields, List<String> paymentMethodFields, List<String> appliedToFields, List<String> refundAppliedToItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Refund> _callback) throws ApiException {
        Call localVarCall = this.getRefundValidateBeforeCall(refundId, fields, refundFields, accountFields, paymentMethodFields, appliedToFields, refundAppliedToItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Refund>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetRefundParams getRefundParams(String refundId) {
        return new GetRefundParams(refundId);
    }

    public Refund getRefund(String refundId) throws ApiException {
        GetRefundParams params = new GetRefundParams(refundId);
        return this.executeGetRefundAPICall(params).getData();
    }

    public Refund getRefund(String refundId, List<String> expand) throws ApiException {
        GetRefundParams params = new GetRefundParams(refundId);
        params.expand(expand);
        return this.executeGetRefundAPICall(params).getData();
    }

    public Refund getRefund(String refundId, List<String> expand, Headers headers) throws ApiException {
        GetRefundParams params = new GetRefundParams(refundId).expand(expand).headers(headers);
        return this.executeGetRefundAPICall(params).getData();
    }

    public Refund get(GetRefundParams params) throws ApiException {
        return this.executeGetRefundAPICall(params).getData();
    }

    public ApiResponse<Refund> getWithHttpInfo(GetRefundParams params) throws ApiException {
        return this.executeGetRefundAPICall(params);
    }

    ApiResponse<Refund> executeGetRefundAPICall(GetRefundParams params) throws ApiException {
        return this.getRefundWithHttpInfo(params.refundId, params.fields, params.refundFields, params.accountFields, params.paymentMethodFields, params.appliedToFields, params.refundAppliedToItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getRefundsCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> refundFields, List<String> accountFields, List<String> paymentMethodFields, List<String> appliedToFields, List<String> refundAppliedToItemFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/refunds";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (sort != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sort[]", sort));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (refundFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "refund.fields[]", refundFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (paymentMethodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_method.fields[]", paymentMethodFields));
        }
        if (appliedToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "applied_to.fields[]", appliedToFields));
        }
        if (refundAppliedToItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "refund_applied_to_item.fields[]", refundAppliedToItemFields));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRefundsValidateBeforeCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> refundFields, List<String> accountFields, List<String> paymentMethodFields, List<String> appliedToFields, List<String> refundAppliedToItemFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getRefundsCall(cursor, expand, filter, sort, pageSize, fields, refundFields, accountFields, paymentMethodFields, appliedToFields, refundAppliedToItemFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<RefundListResponse> getRefundsWithHttpInfo(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> refundFields, List<String> accountFields, List<String> paymentMethodFields, List<String> appliedToFields, List<String> refundAppliedToItemFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getRefundsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, refundFields, accountFields, paymentMethodFields, appliedToFields, refundAppliedToItemFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<RefundListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getRefundsAsync(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> refundFields, List<String> accountFields, List<String> paymentMethodFields, List<String> appliedToFields, List<String> refundAppliedToItemFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<RefundListResponse> _callback) throws ApiException {
        Call localVarCall = this.getRefundsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, refundFields, accountFields, paymentMethodFields, appliedToFields, refundAppliedToItemFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<RefundListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetRefundsParams getRefundsParams() {
        return new GetRefundsParams();
    }

    public RefundListResponse getRefunds() throws ApiException {
        GetRefundsParams params = new GetRefundsParams();
        return this.executeGetRefundsAPICall(params).getData();
    }

    public RefundListResponse getRefunds(String cursor, List<String> expand, List<String> filter) throws ApiException {
        GetRefundsParams params = new GetRefundsParams();
        params.cursor(cursor);
        params.expand(expand);
        params.filter(filter);
        return this.executeGetRefundsAPICall(params).getData();
    }

    public RefundListResponse getRefunds(String cursor, List<String> expand, List<String> filter, Headers headers) throws ApiException {
        GetRefundsParams params = new GetRefundsParams().cursor(cursor).expand(expand).filter(filter).headers(headers);
        return this.executeGetRefundsAPICall(params).getData();
    }

    public RefundListResponse list(GetRefundsParams params) throws ApiException {
        return this.executeGetRefundsAPICall(params).getData();
    }

    public ApiResponse<RefundListResponse> listWithHttpInfo(GetRefundsParams params) throws ApiException {
        return this.executeGetRefundsAPICall(params);
    }

    ApiResponse<RefundListResponse> executeGetRefundsAPICall(GetRefundsParams params) throws ApiException {
        return this.getRefundsWithHttpInfo(params.cursor, params.expand, params.filter, params.sort, params.pageSize, params.fields, params.refundFields, params.accountFields, params.paymentMethodFields, params.appliedToFields, params.refundAppliedToItemFields, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call updateRefundCall(String refundId, RefundPatchRequest refundPatchRequest, List<String> fields, List<String> refundFields, List<String> accountFields, List<String> paymentMethodFields, List<String> appliedToFields, List<String> refundAppliedToItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RefundPatchRequest localVarPostBody = refundPatchRequest;
        String localVarPath = "/refunds/{refund_id}".replace("{refund_id}", this.localVarApiClient.escapeString(refundId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (refundFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "refund.fields[]", refundFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (paymentMethodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_method.fields[]", paymentMethodFields));
        }
        if (appliedToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "applied_to.fields[]", appliedToFields));
        }
        if (refundAppliedToItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "refund_applied_to_item.fields[]", refundAppliedToItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateRefundValidateBeforeCall(String refundId, RefundPatchRequest refundPatchRequest, List<String> fields, List<String> refundFields, List<String> accountFields, List<String> paymentMethodFields, List<String> appliedToFields, List<String> refundAppliedToItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (refundId == null) {
            throw new ApiException("Missing the required parameter 'refundId' when calling updateRefund(Async)");
        }
        if (refundPatchRequest == null) {
            throw new ApiException("Missing the required parameter 'refundPatchRequest' when calling updateRefund(Async)");
        }
        return this.updateRefundCall(refundId, refundPatchRequest, fields, refundFields, accountFields, paymentMethodFields, appliedToFields, refundAppliedToItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Refund> updateRefundWithHttpInfo(String refundId, RefundPatchRequest refundPatchRequest, List<String> fields, List<String> refundFields, List<String> accountFields, List<String> paymentMethodFields, List<String> appliedToFields, List<String> refundAppliedToItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updateRefundValidateBeforeCall(refundId, refundPatchRequest, fields, refundFields, accountFields, paymentMethodFields, appliedToFields, refundAppliedToItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Refund>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call updateRefundAsync(String refundId, RefundPatchRequest refundPatchRequest, List<String> fields, List<String> refundFields, List<String> accountFields, List<String> paymentMethodFields, List<String> appliedToFields, List<String> refundAppliedToItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Refund> _callback) throws ApiException {
        Call localVarCall = this.updateRefundValidateBeforeCall(refundId, refundPatchRequest, fields, refundFields, accountFields, paymentMethodFields, appliedToFields, refundAppliedToItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Refund>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdateRefundParams updateRefundParams(String refundId, RefundPatchRequest refundPatchRequest) {
        return new UpdateRefundParams(refundId, refundPatchRequest);
    }

    public Refund updateRefund(String refundId, RefundPatchRequest refundPatchRequest) throws ApiException {
        UpdateRefundParams params = new UpdateRefundParams(refundId, refundPatchRequest);
        return this.executeUpdateRefundAPICall(params).getData();
    }

    public Refund updateRefund(String refundId, RefundPatchRequest refundPatchRequest, List<String> expand) throws ApiException {
        UpdateRefundParams params = new UpdateRefundParams(refundId, refundPatchRequest);
        params.expand(expand);
        return this.executeUpdateRefundAPICall(params).getData();
    }

    public Refund updateRefund(String refundId, RefundPatchRequest refundPatchRequest, List<String> expand, Headers headers) throws ApiException {
        UpdateRefundParams params = new UpdateRefundParams(refundId, refundPatchRequest).expand(expand).headers(headers);
        return this.executeUpdateRefundAPICall(params).getData();
    }

    public Refund update(UpdateRefundParams params) throws ApiException {
        return this.executeUpdateRefundAPICall(params).getData();
    }

    public ApiResponse<Refund> updateWithHttpInfo(UpdateRefundParams params) throws ApiException {
        return this.executeUpdateRefundAPICall(params);
    }

    ApiResponse<Refund> executeUpdateRefundAPICall(UpdateRefundParams params) throws ApiException {
        return this.updateRefundWithHttpInfo(params.refundId, params.refundPatchRequest, params.fields, params.refundFields, params.accountFields, params.paymentMethodFields, params.appliedToFields, params.refundAppliedToItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    public static class UpdateRefundParams {
        private final String refundId;
        private final RefundPatchRequest refundPatchRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> refundFields;
        private List<String> accountFields;
        private List<String> paymentMethodFields;
        private List<String> appliedToFields;
        private List<String> refundAppliedToItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public UpdateRefundParams(String refundId, RefundPatchRequest refundPatchRequest) {
            this.refundId = refundId;
            this.refundPatchRequest = refundPatchRequest;
        }

        public UpdateRefundParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public UpdateRefundParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public UpdateRefundParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public UpdateRefundParams refundFields(List<String> refundFields) {
            this.refundFields = refundFields;
            return this;
        }

        public UpdateRefundParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public UpdateRefundParams paymentMethodFields(List<String> paymentMethodFields) {
            this.paymentMethodFields = paymentMethodFields;
            return this;
        }

        public UpdateRefundParams appliedToFields(List<String> appliedToFields) {
            this.appliedToFields = appliedToFields;
            return this;
        }

        public UpdateRefundParams refundAppliedToItemFields(List<String> refundAppliedToItemFields) {
            this.refundAppliedToItemFields = refundAppliedToItemFields;
            return this;
        }

        public UpdateRefundParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public UpdateRefundParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public UpdateRefundParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class GetRefundsParams {
        private Headers headers;
        private ListQueryParams listQueryParams;
        private String cursor;
        private List<String> expand;
        private List<String> filter;
        private List<String> sort;
        private Integer pageSize;
        private List<String> fields;
        private List<String> refundFields;
        private List<String> accountFields;
        private List<String> paymentMethodFields;
        private List<String> appliedToFields;
        private List<String> refundAppliedToItemFields;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetRefundsParams listQueryParams(ListQueryParams listQueryParams) {
            this.listQueryParams = listQueryParams;
            if (this.cursor != null) {
                this.cursor = listQueryParams.getCursor();
            }
            if (this.expand != null) {
                this.expand = listQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = listQueryParams.getFilter();
            }
            if (this.sort != null) {
                this.sort = listQueryParams.getSort();
            }
            if (this.pageSize != null) {
                this.pageSize = listQueryParams.getPageSize();
            }
            return this;
        }

        public GetRefundsParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetRefundsParams cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public GetRefundsParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetRefundsParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetRefundsParams sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public GetRefundsParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetRefundsParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetRefundsParams refundFields(List<String> refundFields) {
            this.refundFields = refundFields;
            return this;
        }

        public GetRefundsParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public GetRefundsParams paymentMethodFields(List<String> paymentMethodFields) {
            this.paymentMethodFields = paymentMethodFields;
            return this;
        }

        public GetRefundsParams appliedToFields(List<String> appliedToFields) {
            this.appliedToFields = appliedToFields;
            return this;
        }

        public GetRefundsParams refundAppliedToItemFields(List<String> refundAppliedToItemFields) {
            this.refundAppliedToItemFields = refundAppliedToItemFields;
            return this;
        }
    }

    public static class GetRefundParams {
        private final String refundId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> refundFields;
        private List<String> accountFields;
        private List<String> paymentMethodFields;
        private List<String> appliedToFields;
        private List<String> refundAppliedToItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetRefundParams(String refundId) {
            this.refundId = refundId;
        }

        public GetRefundParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public GetRefundParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetRefundParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetRefundParams refundFields(List<String> refundFields) {
            this.refundFields = refundFields;
            return this;
        }

        public GetRefundParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public GetRefundParams paymentMethodFields(List<String> paymentMethodFields) {
            this.paymentMethodFields = paymentMethodFields;
            return this;
        }

        public GetRefundParams appliedToFields(List<String> appliedToFields) {
            this.appliedToFields = appliedToFields;
            return this;
        }

        public GetRefundParams refundAppliedToItemFields(List<String> refundAppliedToItemFields) {
            this.refundAppliedToItemFields = refundAppliedToItemFields;
            return this;
        }

        public GetRefundParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetRefundParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetRefundParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class DeleteRefundParams {
        private final String refundId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public DeleteRefundParams(String refundId) {
            this.refundId = refundId;
        }

        public DeleteRefundParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }
    }

    public static class CreateRefundParams {
        private final RefundCreateRequest refundCreateRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> refundFields;
        private List<String> accountFields;
        private List<String> paymentMethodFields;
        private List<String> appliedToFields;
        private List<String> refundAppliedToItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public CreateRefundParams(RefundCreateRequest refundCreateRequest) {
            this.refundCreateRequest = refundCreateRequest;
        }

        public CreateRefundParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CreateRefundParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CreateRefundParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CreateRefundParams refundFields(List<String> refundFields) {
            this.refundFields = refundFields;
            return this;
        }

        public CreateRefundParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public CreateRefundParams paymentMethodFields(List<String> paymentMethodFields) {
            this.paymentMethodFields = paymentMethodFields;
            return this;
        }

        public CreateRefundParams appliedToFields(List<String> appliedToFields) {
            this.appliedToFields = appliedToFields;
            return this;
        }

        public CreateRefundParams refundAppliedToItemFields(List<String> refundAppliedToItemFields) {
            this.refundAppliedToItemFields = refundAppliedToItemFields;
            return this;
        }

        public CreateRefundParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CreateRefundParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CreateRefundParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class CancelRefundParams {
        private final String refundId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> refundFields;
        private List<String> accountFields;
        private List<String> paymentMethodFields;
        private List<String> appliedToFields;
        private List<String> refundAppliedToItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public CancelRefundParams(String refundId) {
            this.refundId = refundId;
        }

        public CancelRefundParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CancelRefundParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CancelRefundParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CancelRefundParams refundFields(List<String> refundFields) {
            this.refundFields = refundFields;
            return this;
        }

        public CancelRefundParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public CancelRefundParams paymentMethodFields(List<String> paymentMethodFields) {
            this.paymentMethodFields = paymentMethodFields;
            return this;
        }

        public CancelRefundParams appliedToFields(List<String> appliedToFields) {
            this.appliedToFields = appliedToFields;
            return this;
        }

        public CancelRefundParams refundAppliedToItemFields(List<String> refundAppliedToItemFields) {
            this.refundAppliedToItemFields = refundAppliedToItemFields;
            return this;
        }

        public CancelRefundParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CancelRefundParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CancelRefundParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }
}

