/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="taxation information for this billing document item.")
public class TaxationItem {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updated_by_id";
    @SerializedName(value="updated_by_id")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, String> customFields = null;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_JURISDICTION = "jurisdiction";
    @SerializedName(value="jurisdiction")
    private String jurisdiction;
    public static final String SERIALIZED_NAME_LOCATION_CODE = "location_code";
    @SerializedName(value="location_code")
    private String locationCode;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_TAX_CODE = "tax_code";
    @SerializedName(value="tax_code")
    private String taxCode;
    public static final String SERIALIZED_NAME_TAX_CODE_NAME = "tax_code_name";
    @SerializedName(value="tax_code_name")
    private String taxCodeName;
    public static final String SERIALIZED_NAME_TAX_DATE = "tax_date";
    @SerializedName(value="tax_date")
    private LocalDate taxDate;
    public static final String SERIALIZED_NAME_TAX_RATE = "tax_rate";
    @SerializedName(value="tax_rate")
    private BigDecimal taxRate;
    public static final String SERIALIZED_NAME_TAX_RATE_NAME = "tax_rate_name";
    @SerializedName(value="tax_rate_name")
    private String taxRateName;
    public static final String SERIALIZED_NAME_AMOUNT_EXEMPT = "amount_exempt";
    @SerializedName(value="amount_exempt")
    private BigDecimal amountExempt;
    public static final String SERIALIZED_NAME_SOURCE_TAX_ITEM_ID = "source_tax_item_id";
    @SerializedName(value="source_tax_item_id")
    private String sourceTaxItemId;
    public static final String SERIALIZED_NAME_REMAINING_BALANCE = "remaining_balance";
    @SerializedName(value="remaining_balance")
    private BigDecimal remainingBalance;
    public static final String SERIALIZED_NAME_AMOUNT_CREDITED = "amount_credited";
    @SerializedName(value="amount_credited")
    private BigDecimal amountCredited;
    public static final String SERIALIZED_NAME_AMOUNT_PAID = "amount_paid";
    @SerializedName(value="amount_paid")
    private BigDecimal amountPaid;
    public static final String SERIALIZED_NAME_AMOUNT_REFUNDED = "amount_refunded";
    @SerializedName(value="amount_refunded")
    private BigDecimal amountRefunded;
    public static final String SERIALIZED_NAME_AMOUNT_APPLIED = "amount_applied";
    @SerializedName(value="amount_applied")
    private BigDecimal amountApplied;
    public static final String SERIALIZED_NAME_SALES_TAX_PAYABLE_ACCOUNT = "sales_tax_payable_account";
    @SerializedName(value="sales_tax_payable_account")
    private String salesTaxPayableAccount;
    public static final String SERIALIZED_NAME_ON_ACCOUNT_ACCOUNT = "on_account_account";
    @SerializedName(value="on_account_account")
    private String onAccountAccount;
    public static final String SERIALIZED_NAME_TAX_INCLUSIVE = "tax_inclusive";
    @SerializedName(value="tax_inclusive")
    private Boolean taxInclusive;
    public static final String SERIALIZED_NAME_TAX_RATE_TYPE = "tax_rate_type";
    @SerializedName(value="tax_rate_type")
    private TaxRateTypeEnum taxRateType;

    public TaxationItem() {
    }

    public TaxationItem(String updatedById, OffsetDateTime updatedTime, String createdById, OffsetDateTime createdTime, Map<String, Object> customObjects, BigDecimal remainingBalance, BigDecimal amountCredited, BigDecimal amountPaid, BigDecimal amountRefunded, BigDecimal amountApplied) {
        this();
        this.updatedById = updatedById;
        this.updatedTime = updatedTime;
        this.createdById = createdById;
        this.createdTime = createdTime;
        this.customObjects = customObjects;
        this.remainingBalance = remainingBalance;
        this.amountCredited = amountCredited;
        this.amountPaid = amountPaid;
        this.amountRefunded = amountRefunded;
        this.amountApplied = amountApplied;
    }

    public TaxationItem id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the taxation item related to the invoice. Only applicable for credit memos created from invoices.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who last updated the object")
    public String getUpdatedById() {
        return this.updatedById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO 8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was created in ISO 8601 UTC format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public TaxationItem customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public TaxationItem putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public TaxationItem jurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The jurisdiction that applies the tax or VAT. This value is typically a state, province, county, or city.")
    public String getJurisdiction() {
        return this.jurisdiction;
    }

    public void setJurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
    }

    public TaxationItem locationCode(String locationCode) {
        this.locationCode = locationCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier for the location based on the value of the `tax_code` field.")
    public String getLocationCode() {
        return this.locationCode;
    }

    public void setLocationCode(String locationCode) {
        this.locationCode = locationCode;
    }

    public TaxationItem name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the taxation item.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TaxationItem amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount of the tax applied to the total price.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public TaxationItem taxCode(String taxCode) {
        this.taxCode = taxCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A tax code identifier. If a `tax_code` of a price is not provided when you create or update a price, Zuora will treat the charged amount as non-taxable. If this code is provide, Zuora considers that this price is taxable and the charged amount will be handled accordingly.")
    public String getTaxCode() {
        return this.taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public TaxationItem taxCodeName(String taxCodeName) {
        this.taxCodeName = taxCodeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount of the tax applied to the total price.")
    public String getTaxCodeName() {
        return this.taxCodeName;
    }

    public void setTaxCodeName(String taxCodeName) {
        this.taxCodeName = taxCodeName;
    }

    public TaxationItem taxDate(LocalDate taxDate) {
        this.taxDate = taxDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The date on which the tax is applied.")
    public LocalDate getTaxDate() {
        return this.taxDate;
    }

    public void setTaxDate(LocalDate taxDate) {
        this.taxDate = taxDate;
    }

    public TaxationItem taxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount of the tax applied to the total price.")
    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public TaxationItem taxRateName(String taxRateName) {
        this.taxRateName = taxRateName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the tax rate, such as sales tax or GST. This name is displayed on billing documents.")
    public String getTaxRateName() {
        return this.taxRateName;
    }

    public void setTaxRateName(String taxRateName) {
        this.taxRateName = taxRateName;
    }

    public TaxationItem amountExempt(BigDecimal amountExempt) {
        this.amountExempt = amountExempt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The calculated tax amount excluded due to the exemption.")
    public BigDecimal getAmountExempt() {
        return this.amountExempt;
    }

    public void setAmountExempt(BigDecimal amountExempt) {
        this.amountExempt = amountExempt;
    }

    public TaxationItem sourceTaxItemId(String sourceTaxItemId) {
        this.sourceTaxItemId = sourceTaxItemId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the taxation item of the invoice, from which the credit or debit memo is created. This field is only applicable when the `type` of the billing document is `credit_memo` and `debit_memo`.")
    public String getSourceTaxItemId() {
        return this.sourceTaxItemId;
    }

    public void setSourceTaxItemId(String sourceTaxItemId) {
        this.sourceTaxItemId = sourceTaxItemId;
    }

    @Nullable
    @ApiModelProperty(value="The remaining balance of the taxation item.")
    public BigDecimal getRemainingBalance() {
        return this.remainingBalance;
    }

    @Nullable
    @ApiModelProperty(value="The credit memo amount applied to the taxation item.")
    public BigDecimal getAmountCredited() {
        return this.amountCredited;
    }

    @Nullable
    @ApiModelProperty(value="The payment amount applied to the taxation item.")
    public BigDecimal getAmountPaid() {
        return this.amountPaid;
    }

    @Nullable
    @ApiModelProperty(value="The refund amount applied to the taxation item.")
    public BigDecimal getAmountRefunded() {
        return this.amountRefunded;
    }

    @Nullable
    @ApiModelProperty(value="The credit memo item amount applied to the taxation item.")
    public BigDecimal getAmountApplied() {
        return this.amountApplied;
    }

    public TaxationItem salesTaxPayableAccount(String salesTaxPayableAccount) {
        this.salesTaxPayableAccount = salesTaxPayableAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active account in your Zuora Chart of Accounts.")
    public String getSalesTaxPayableAccount() {
        return this.salesTaxPayableAccount;
    }

    public void setSalesTaxPayableAccount(String salesTaxPayableAccount) {
        this.salesTaxPayableAccount = salesTaxPayableAccount;
    }

    public TaxationItem onAccountAccount(String onAccountAccount) {
        this.onAccountAccount = onAccountAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active account in your Zuora Chart of Accounts.")
    public String getOnAccountAccount() {
        return this.onAccountAccount;
    }

    public void setOnAccountAccount(String onAccountAccount) {
        this.onAccountAccount = onAccountAccount;
    }

    public TaxationItem taxInclusive(Boolean taxInclusive) {
        this.taxInclusive = taxInclusive;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, it indicates that amounts are inclusive of tax.")
    public Boolean getTaxInclusive() {
        return this.taxInclusive;
    }

    public void setTaxInclusive(Boolean taxInclusive) {
        this.taxInclusive = taxInclusive;
    }

    public TaxationItem taxRateType(TaxRateTypeEnum taxRateType) {
        this.taxRateType = taxRateType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the tax rate is an amount or a percentage.")
    public TaxRateTypeEnum getTaxRateType() {
        return this.taxRateType;
    }

    public void setTaxRateType(TaxRateTypeEnum taxRateType) {
        this.taxRateType = taxRateType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxationItem taxationItem = (TaxationItem)o;
        return Objects.equals(this.id, taxationItem.id) && Objects.equals(this.updatedById, taxationItem.updatedById) && Objects.equals(this.updatedTime, taxationItem.updatedTime) && Objects.equals(this.createdById, taxationItem.createdById) && Objects.equals(this.createdTime, taxationItem.createdTime) && Objects.equals(this.customFields, taxationItem.customFields) && Objects.equals(this.customObjects, taxationItem.customObjects) && Objects.equals(this.jurisdiction, taxationItem.jurisdiction) && Objects.equals(this.locationCode, taxationItem.locationCode) && Objects.equals(this.name, taxationItem.name) && Objects.equals(this.amount, taxationItem.amount) && Objects.equals(this.taxCode, taxationItem.taxCode) && Objects.equals(this.taxCodeName, taxationItem.taxCodeName) && Objects.equals(this.taxDate, taxationItem.taxDate) && Objects.equals(this.taxRate, taxationItem.taxRate) && Objects.equals(this.taxRateName, taxationItem.taxRateName) && Objects.equals(this.amountExempt, taxationItem.amountExempt) && Objects.equals(this.sourceTaxItemId, taxationItem.sourceTaxItemId) && Objects.equals(this.remainingBalance, taxationItem.remainingBalance) && Objects.equals(this.amountCredited, taxationItem.amountCredited) && Objects.equals(this.amountPaid, taxationItem.amountPaid) && Objects.equals(this.amountRefunded, taxationItem.amountRefunded) && Objects.equals(this.amountApplied, taxationItem.amountApplied) && Objects.equals(this.salesTaxPayableAccount, taxationItem.salesTaxPayableAccount) && Objects.equals(this.onAccountAccount, taxationItem.onAccountAccount) && Objects.equals(this.taxInclusive, taxationItem.taxInclusive) && Objects.equals((Object)this.taxRateType, (Object)taxationItem.taxRateType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.updatedById, this.updatedTime, this.createdById, this.createdTime, this.customFields, this.customObjects, this.jurisdiction, this.locationCode, this.name, this.amount, this.taxCode, this.taxCodeName, this.taxDate, this.taxRate, this.taxRateName, this.amountExempt, this.sourceTaxItemId, this.remainingBalance, this.amountCredited, this.amountPaid, this.amountRefunded, this.amountApplied, this.salesTaxPayableAccount, this.onAccountAccount, this.taxInclusive, this.taxRateType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxationItem {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    jurisdiction: ").append(this.toIndentedString(this.jurisdiction)).append("\n");
        sb.append("    locationCode: ").append(this.toIndentedString(this.locationCode)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    taxCode: ").append(this.toIndentedString(this.taxCode)).append("\n");
        sb.append("    taxCodeName: ").append(this.toIndentedString(this.taxCodeName)).append("\n");
        sb.append("    taxDate: ").append(this.toIndentedString(this.taxDate)).append("\n");
        sb.append("    taxRate: ").append(this.toIndentedString(this.taxRate)).append("\n");
        sb.append("    taxRateName: ").append(this.toIndentedString(this.taxRateName)).append("\n");
        sb.append("    amountExempt: ").append(this.toIndentedString(this.amountExempt)).append("\n");
        sb.append("    sourceTaxItemId: ").append(this.toIndentedString(this.sourceTaxItemId)).append("\n");
        sb.append("    remainingBalance: ").append(this.toIndentedString(this.remainingBalance)).append("\n");
        sb.append("    amountCredited: ").append(this.toIndentedString(this.amountCredited)).append("\n");
        sb.append("    amountPaid: ").append(this.toIndentedString(this.amountPaid)).append("\n");
        sb.append("    amountRefunded: ").append(this.toIndentedString(this.amountRefunded)).append("\n");
        sb.append("    amountApplied: ").append(this.toIndentedString(this.amountApplied)).append("\n");
        sb.append("    salesTaxPayableAccount: ").append(this.toIndentedString(this.salesTaxPayableAccount)).append("\n");
        sb.append("    onAccountAccount: ").append(this.toIndentedString(this.onAccountAccount)).append("\n");
        sb.append("    taxInclusive: ").append(this.toIndentedString(this.taxInclusive)).append("\n");
        sb.append("    taxRateType: ").append(this.toIndentedString((Object)this.taxRateType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TaxRateTypeEnum {
        PERCENT("percent"),
        AMOUNT("amount"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TaxRateTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TaxRateTypeEnum fromValue(String value) {
            for (TaxRateTypeEnum b : TaxRateTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TaxRateTypeEnum> {
            public void write(JsonWriter jsonWriter, TaxRateTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TaxRateTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TaxRateTypeEnum.fromValue(value);
            }
        }
    }
}

