/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.threeten.bp.LocalDate;

@ApiModel(description="Specify this field to cancel a subscription")
public class SubscriptionCancelPatchResponse {
    public static final String SERIALIZED_NAME_CANCEL_DATE = "cancel_date";
    @SerializedName(value="cancel_date")
    private LocalDate cancelDate;
    public static final String SERIALIZED_NAME_CANCEL_AT = "cancel_at";
    @SerializedName(value="cancel_at")
    private CancelAtEnum cancelAt;

    public SubscriptionCancelPatchResponse cancelDate(LocalDate cancelDate) {
        this.cancelDate = cancelDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Wed Jun 01 00:00:00 GMT 2022", value="Date on which the subscription is canceled.")
    public LocalDate getCancelDate() {
        return this.cancelDate;
    }

    public void setCancelDate(LocalDate cancelDate) {
        this.cancelDate = cancelDate;
    }

    public SubscriptionCancelPatchResponse cancelAt(CancelAtEnum cancelAt) {
        this.cancelAt = cancelAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date on which the subscription is canceled. Can be either the end of the subscription term or the end of the billing period.")
    public CancelAtEnum getCancelAt() {
        return this.cancelAt;
    }

    public void setCancelAt(CancelAtEnum cancelAt) {
        this.cancelAt = cancelAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionCancelPatchResponse subscriptionCancelPatchResponse = (SubscriptionCancelPatchResponse)o;
        return Objects.equals(this.cancelDate, subscriptionCancelPatchResponse.cancelDate) && Objects.equals((Object)this.cancelAt, (Object)subscriptionCancelPatchResponse.cancelAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cancelDate, this.cancelAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionCancelPatchResponse {\n");
        sb.append("    cancelDate: ").append(this.toIndentedString(this.cancelDate)).append("\n");
        sb.append("    cancelAt: ").append(this.toIndentedString((Object)this.cancelAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CancelAtEnum {
        INVOICE_PERIOD_END("invoice_period_end"),
        SUBSCRIPTION_TERM_END("subscription_term_end"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private CancelAtEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CancelAtEnum fromValue(String value) {
            for (CancelAtEnum b : CancelAtEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CancelAtEnum> {
            public void write(JsonWriter jsonWriter, CancelAtEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CancelAtEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CancelAtEnum.fromValue(value);
            }
        }
    }
}

