/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Accounting configuration if you have Zuora Revenue enabled.")
public class Revenue {
    public static final String SERIALIZED_NAME_EXCLUDE_ITEM_BILLING_FROM_REVENUE_ACCOUNTING = "exclude_item_billing_from_revenue_accounting";
    @SerializedName(value="exclude_item_billing_from_revenue_accounting")
    private Boolean excludeItemBillingFromRevenueAccounting;
    public static final String SERIALIZED_NAME_EXCLUDE_ITEM_BOOKING_FROM_REVENUE_ACCOUNTING = "exclude_item_booking_from_revenue_accounting";
    @SerializedName(value="exclude_item_booking_from_revenue_accounting")
    private Boolean excludeItemBookingFromRevenueAccounting;

    public Revenue excludeItemBillingFromRevenueAccounting(Boolean excludeItemBillingFromRevenueAccounting) {
        this.excludeItemBillingFromRevenueAccounting = excludeItemBillingFromRevenueAccounting;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, any associated billing document items are excluded from the revenue accounting.")
    public Boolean getExcludeItemBillingFromRevenueAccounting() {
        return this.excludeItemBillingFromRevenueAccounting;
    }

    public void setExcludeItemBillingFromRevenueAccounting(Boolean excludeItemBillingFromRevenueAccounting) {
        this.excludeItemBillingFromRevenueAccounting = excludeItemBillingFromRevenueAccounting;
    }

    public Revenue excludeItemBookingFromRevenueAccounting(Boolean excludeItemBookingFromRevenueAccounting) {
        this.excludeItemBookingFromRevenueAccounting = excludeItemBookingFromRevenueAccounting;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, any associated subscription items are excluded from the revenue accounting.")
    public Boolean getExcludeItemBookingFromRevenueAccounting() {
        return this.excludeItemBookingFromRevenueAccounting;
    }

    public void setExcludeItemBookingFromRevenueAccounting(Boolean excludeItemBookingFromRevenueAccounting) {
        this.excludeItemBookingFromRevenueAccounting = excludeItemBookingFromRevenueAccounting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Revenue revenue = (Revenue)o;
        return Objects.equals(this.excludeItemBillingFromRevenueAccounting, revenue.excludeItemBillingFromRevenueAccounting) && Objects.equals(this.excludeItemBookingFromRevenueAccounting, revenue.excludeItemBookingFromRevenueAccounting);
    }

    public int hashCode() {
        return Objects.hash(this.excludeItemBillingFromRevenueAccounting, this.excludeItemBookingFromRevenueAccounting);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Revenue {\n");
        sb.append("    excludeItemBillingFromRevenueAccounting: ").append(this.toIndentedString(this.excludeItemBillingFromRevenueAccounting)).append("\n");
        sb.append("    excludeItemBookingFromRevenueAccounting: ").append(this.toIndentedString(this.excludeItemBookingFromRevenueAccounting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

