/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.PaymentScheduleItemPaymentOption;
import org.threeten.bp.LocalDate;

public class PaymentScheduleItemCreateRequest {
    public static final String SERIALIZED_NAME_PAYMENT_SCHEDULE_ID = "payment_schedule_id";
    @SerializedName(value="payment_schedule_id")
    private String paymentScheduleId;
    public static final String SERIALIZED_NAME_PAYMENT_SCHEDULE_NUMBER = "payment_schedule_number";
    @SerializedName(value="payment_schedule_number")
    private String paymentScheduleNumber;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_PAYMENT_GATEWAY_ID = "payment_gateway_id";
    @SerializedName(value="payment_gateway_id")
    private String paymentGatewayId;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD_ID = "payment_method_id";
    @SerializedName(value="payment_method_id")
    private String paymentMethodId;
    public static final String SERIALIZED_NAME_SCHEDULED_DATE = "scheduled_date";
    @SerializedName(value="scheduled_date")
    private LocalDate scheduledDate;
    public static final String SERIALIZED_NAME_RUN_HOUR = "run_hour";
    @SerializedName(value="run_hour")
    private Integer runHour;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, String> customFields = null;
    public static final String SERIALIZED_NAME_PAYMENT_OPTIONS = "payment_options";
    @SerializedName(value="payment_options")
    private List<PaymentScheduleItemPaymentOption> paymentOptions = null;

    public PaymentScheduleItemCreateRequest paymentScheduleId(String paymentScheduleId) {
        this.paymentScheduleId = paymentScheduleId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="ID of a payment schedule.")
    public String getPaymentScheduleId() {
        return this.paymentScheduleId;
    }

    public void setPaymentScheduleId(String paymentScheduleId) {
        this.paymentScheduleId = paymentScheduleId;
    }

    public PaymentScheduleItemCreateRequest paymentScheduleNumber(String paymentScheduleNumber) {
        this.paymentScheduleNumber = paymentScheduleNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of the payment schedule.")
    public String getPaymentScheduleNumber() {
        return this.paymentScheduleNumber;
    }

    public void setPaymentScheduleNumber(String paymentScheduleNumber) {
        this.paymentScheduleNumber = paymentScheduleNumber;
    }

    public PaymentScheduleItemCreateRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8ad093f27d6eee80017d6effd7a66759", value="Unique identifier of the customer account the payment schedule belongs to.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public PaymentScheduleItemCreateRequest amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to be collected by this payment schedule item.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public PaymentScheduleItemCreateRequest currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="USD", value="Currency of the payment schedule. The default value is the account's default currency. This field will be ignored when items is specified.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public PaymentScheduleItemCreateRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="description of payment schedule item", value="An arbitrary string attached to the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PaymentScheduleItemCreateRequest paymentGatewayId(String paymentGatewayId) {
        this.paymentGatewayId = paymentGatewayId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8ad093f27d6eee80017d6effd7a66759", value="ID of the payment gateway used to collect payments. The default value is the account's default payment gateway ID. If no payment gateway ID is found on the customer account level, the default value will be the tenant's default payment gateway ID. This field will be ignored when `items` is specified.")
    public String getPaymentGatewayId() {
        return this.paymentGatewayId;
    }

    public void setPaymentGatewayId(String paymentGatewayId) {
        this.paymentGatewayId = paymentGatewayId;
    }

    public PaymentScheduleItemCreateRequest paymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8a95b1946b6aeac8718c32aab8c395f", value="ID of the payment method. The default value is the account's default payment method ID. This field will be ignored when `items` is specified.")
    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public void setPaymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    public PaymentScheduleItemCreateRequest scheduledDate(LocalDate scheduledDate) {
        this.scheduledDate = scheduledDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The scheduled date of collection.")
    public LocalDate getScheduledDate() {
        return this.scheduledDate;
    }

    public void setScheduledDate(LocalDate scheduledDate) {
        this.scheduledDate = scheduledDate;
    }

    public PaymentScheduleItemCreateRequest runHour(Integer runHour) {
        this.runHour = runHour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="At which hour in the day in the tenant's timezone this payment will be collected. Available values:[0,1,2,~,22,23]. If the time difference between your tenant\u2019s timezone and the timezone where Zuora servers are located is not in full hours, for example, 2.5 hours, the payment schedule items will be triggered half an hour later than your scheduled time. The default value is 0. If the payment run_hour and scheduled_date are backdated, the system will collect the payment when the next run_hour occurs.")
    public Integer getRunHour() {
        return this.runHour;
    }

    public void setRunHour(Integer runHour) {
        this.runHour = runHour;
    }

    public PaymentScheduleItemCreateRequest customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public PaymentScheduleItemCreateRequest putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    public PaymentScheduleItemCreateRequest paymentOptions(List<PaymentScheduleItemPaymentOption> paymentOptions) {
        this.paymentOptions = paymentOptions;
        return this;
    }

    public PaymentScheduleItemCreateRequest addPaymentOptionsItem(PaymentScheduleItemPaymentOption paymentOptionsItem) {
        if (this.paymentOptions == null) {
            this.paymentOptions = new ArrayList<PaymentScheduleItemPaymentOption>();
        }
        this.paymentOptions.add(paymentOptionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container for the payment options, which describe the transactional level rules for processing payments. Currently, only the `gateway_options` type is supported. Payment schedule `payment_options` take precedence over payment schedule item `payment_options`.")
    public List<PaymentScheduleItemPaymentOption> getPaymentOptions() {
        return this.paymentOptions;
    }

    public void setPaymentOptions(List<PaymentScheduleItemPaymentOption> paymentOptions) {
        this.paymentOptions = paymentOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentScheduleItemCreateRequest paymentScheduleItemCreateRequest = (PaymentScheduleItemCreateRequest)o;
        return Objects.equals(this.paymentScheduleId, paymentScheduleItemCreateRequest.paymentScheduleId) && Objects.equals(this.paymentScheduleNumber, paymentScheduleItemCreateRequest.paymentScheduleNumber) && Objects.equals(this.accountId, paymentScheduleItemCreateRequest.accountId) && Objects.equals(this.amount, paymentScheduleItemCreateRequest.amount) && Objects.equals(this.currency, paymentScheduleItemCreateRequest.currency) && Objects.equals(this.description, paymentScheduleItemCreateRequest.description) && Objects.equals(this.paymentGatewayId, paymentScheduleItemCreateRequest.paymentGatewayId) && Objects.equals(this.paymentMethodId, paymentScheduleItemCreateRequest.paymentMethodId) && Objects.equals(this.scheduledDate, paymentScheduleItemCreateRequest.scheduledDate) && Objects.equals(this.runHour, paymentScheduleItemCreateRequest.runHour) && Objects.equals(this.customFields, paymentScheduleItemCreateRequest.customFields) && Objects.equals(this.paymentOptions, paymentScheduleItemCreateRequest.paymentOptions);
    }

    public int hashCode() {
        return Objects.hash(this.paymentScheduleId, this.paymentScheduleNumber, this.accountId, this.amount, this.currency, this.description, this.paymentGatewayId, this.paymentMethodId, this.scheduledDate, this.runHour, this.customFields, this.paymentOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentScheduleItemCreateRequest {\n");
        sb.append("    paymentScheduleId: ").append(this.toIndentedString(this.paymentScheduleId)).append("\n");
        sb.append("    paymentScheduleNumber: ").append(this.toIndentedString(this.paymentScheduleNumber)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    paymentGatewayId: ").append(this.toIndentedString(this.paymentGatewayId)).append("\n");
        sb.append("    paymentMethodId: ").append(this.toIndentedString(this.paymentMethodId)).append("\n");
        sb.append("    scheduledDate: ").append(this.toIndentedString(this.scheduledDate)).append("\n");
        sb.append("    runHour: ").append(this.toIndentedString(this.runHour)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    paymentOptions: ").append(this.toIndentedString(this.paymentOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

