/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class PaymentRunCreateRequest {
    public static final String SERIALIZED_NAME_APPLY_CREDIT_MEMOS = "apply_credit_memos";
    @SerializedName(value="apply_credit_memos")
    private Boolean applyCreditMemos;
    public static final String SERIALIZED_NAME_APPLY_UNAPPLIED_PAYMENTS = "apply_unapplied_payments";
    @SerializedName(value="apply_unapplied_payments")
    private Boolean applyUnappliedPayments;
    public static final String SERIALIZED_NAME_BATCH = "batch";
    @SerializedName(value="batch")
    private String batch;
    public static final String SERIALIZED_NAME_BILL_CYCLE_DAY = "bill_cycle_day";
    @SerializedName(value="bill_cycle_day")
    private String billCycleDay;
    public static final String SERIALIZED_NAME_BILL_RUN_ID = "bill_run_id";
    @SerializedName(value="bill_run_id")
    private String billRunId;
    public static final String SERIALIZED_NAME_COLLECT_PAYMENT = "collect_payment";
    @SerializedName(value="collect_payment")
    private Boolean collectPayment;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_CONSOLIDATED_PAYMENT = "consolidated_payment";
    @SerializedName(value="consolidated_payment")
    private Boolean consolidatedPayment;
    public static final String SERIALIZED_NAME_GATEWAY_ID = "gateway_id";
    @SerializedName(value="gateway_id")
    private String gatewayId;
    public static final String SERIALIZED_NAME_PAYMENT_RUN_DATE = "payment_run_date";
    @SerializedName(value="payment_run_date")
    private OffsetDateTime paymentRunDate;
    public static final String SERIALIZED_NAME_TARGET_DATE = "target_date";
    @SerializedName(value="target_date")
    private LocalDate targetDate;

    public PaymentRunCreateRequest applyCreditMemos(Boolean applyCreditMemos) {
        this.applyCreditMemos = applyCreditMemos;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, any posted credit memos are applied first.")
    public Boolean getApplyCreditMemos() {
        return this.applyCreditMemos;
    }

    public void setApplyCreditMemos(Boolean applyCreditMemos) {
        this.applyCreditMemos = applyCreditMemos;
    }

    public PaymentRunCreateRequest applyUnappliedPayments(Boolean applyUnappliedPayments) {
        this.applyUnappliedPayments = applyUnappliedPayments;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, any unapplied payments are applied first.")
    public Boolean getApplyUnappliedPayments() {
        return this.applyUnappliedPayments;
    }

    public void setApplyUnappliedPayments(Boolean applyUnappliedPayments) {
        this.applyUnappliedPayments = applyUnappliedPayments;
    }

    public PaymentRunCreateRequest batch(String batch) {
        this.batch = batch;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the customer account batch to be included in this payment run.")
    public String getBatch() {
        return this.batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public PaymentRunCreateRequest billCycleDay(String billCycleDay) {
        this.billCycleDay = billCycleDay;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The day of the month to bill multiple customer accounts.")
    public String getBillCycleDay() {
        return this.billCycleDay;
    }

    public void setBillCycleDay(String billCycleDay) {
        this.billCycleDay = billCycleDay;
    }

    public PaymentRunCreateRequest billRunId(String billRunId) {
        this.billRunId = billRunId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier of a bill run.")
    public String getBillRunId() {
        return this.billRunId;
    }

    public void setBillRunId(String billRunId) {
        this.billRunId = billRunId;
    }

    public PaymentRunCreateRequest collectPayment(Boolean collectPayment) {
        this.collectPayment = collectPayment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether to process electronic payments during the execution of payment runs.       If the Payment user permission \"Process Electronic Payment\" is disabled, this field will be ignored.")
    public Boolean getCollectPayment() {
        return this.collectPayment;
    }

    public void setCollectPayment(Boolean collectPayment) {
        this.collectPayment = collectPayment;
    }

    public PaymentRunCreateRequest currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="USD", value="Three-letter ISO currency code.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public PaymentRunCreateRequest consolidatedPayment(Boolean consolidatedPayment) {
        this.consolidatedPayment = consolidatedPayment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, a single payment will be collected for all receivables due on an account.")
    public Boolean getConsolidatedPayment() {
        return this.consolidatedPayment;
    }

    public void setConsolidatedPayment(Boolean consolidatedPayment) {
        this.consolidatedPayment = consolidatedPayment;
    }

    public PaymentRunCreateRequest gatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the payment gateway.")
    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    public PaymentRunCreateRequest paymentRunDate(OffsetDateTime paymentRunDate) {
        this.paymentRunDate = paymentRunDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the scheduled payment run is to be executed, in `yyyy-mm-dd hh:mm:ss` format. The backend will ignore minutes and seconds in the field value. For example, if you specify `2017-03-01 11:30:37` for this value, this payment run will be run at 2017-03-01 11:00:00.      <br />       You must specify either the `payment_run_date` field or the `target_date` field in the request body.      If you specify the `payment_run_date` field, the scheduced payment run is to be executed on the specified payment run date. If you specify the `target_date` field, the payment run is executed immediately after it is created.")
    public OffsetDateTime getPaymentRunDate() {
        return this.paymentRunDate;
    }

    public void setPaymentRunDate(OffsetDateTime paymentRunDate) {
        this.paymentRunDate = paymentRunDate;
    }

    public PaymentRunCreateRequest targetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="The target date used to determine which receivables to be paid in the payment run.       The payments are collected for all receivables with the due date no later than the target date.")
    public LocalDate getTargetDate() {
        return this.targetDate;
    }

    public void setTargetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentRunCreateRequest paymentRunCreateRequest = (PaymentRunCreateRequest)o;
        return Objects.equals(this.applyCreditMemos, paymentRunCreateRequest.applyCreditMemos) && Objects.equals(this.applyUnappliedPayments, paymentRunCreateRequest.applyUnappliedPayments) && Objects.equals(this.batch, paymentRunCreateRequest.batch) && Objects.equals(this.billCycleDay, paymentRunCreateRequest.billCycleDay) && Objects.equals(this.billRunId, paymentRunCreateRequest.billRunId) && Objects.equals(this.collectPayment, paymentRunCreateRequest.collectPayment) && Objects.equals(this.currency, paymentRunCreateRequest.currency) && Objects.equals(this.consolidatedPayment, paymentRunCreateRequest.consolidatedPayment) && Objects.equals(this.gatewayId, paymentRunCreateRequest.gatewayId) && Objects.equals(this.paymentRunDate, paymentRunCreateRequest.paymentRunDate) && Objects.equals(this.targetDate, paymentRunCreateRequest.targetDate);
    }

    public int hashCode() {
        return Objects.hash(this.applyCreditMemos, this.applyUnappliedPayments, this.batch, this.billCycleDay, this.billRunId, this.collectPayment, this.currency, this.consolidatedPayment, this.gatewayId, this.paymentRunDate, this.targetDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentRunCreateRequest {\n");
        sb.append("    applyCreditMemos: ").append(this.toIndentedString(this.applyCreditMemos)).append("\n");
        sb.append("    applyUnappliedPayments: ").append(this.toIndentedString(this.applyUnappliedPayments)).append("\n");
        sb.append("    batch: ").append(this.toIndentedString(this.batch)).append("\n");
        sb.append("    billCycleDay: ").append(this.toIndentedString(this.billCycleDay)).append("\n");
        sb.append("    billRunId: ").append(this.toIndentedString(this.billRunId)).append("\n");
        sb.append("    collectPayment: ").append(this.toIndentedString(this.collectPayment)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    consolidatedPayment: ").append(this.toIndentedString(this.consolidatedPayment)).append("\n");
        sb.append("    gatewayId: ").append(this.toIndentedString(this.gatewayId)).append("\n");
        sb.append("    paymentRunDate: ").append(this.toIndentedString(this.paymentRunDate)).append("\n");
        sb.append("    targetDate: ").append(this.toIndentedString(this.targetDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

