/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class ListQueryParams
extends HashMap<String, Object> {
    public static final String SERIALIZED_NAME_CURSOR = "cursor";
    @SerializedName(value="cursor")
    private String cursor;
    public static final String SERIALIZED_NAME_EXPAND = "expand[]";
    @SerializedName(value="expand[]")
    private List<String> expand = null;
    public static final String SERIALIZED_NAME_FILTER = "filter[]";
    @SerializedName(value="filter[]")
    private List<String> filter = null;
    public static final String SERIALIZED_NAME_SORT = "sort[]";
    @SerializedName(value="sort[]")
    private List<String> sort = null;
    public static final String SERIALIZED_NAME_PAGE_SIZE = "page_size";
    @SerializedName(value="page_size")
    private Integer pageSize;

    public ListQueryParams cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A cursor for use in pagination. A cursor defines the starting place in a list. For instance, if you make a list request and receive 100 objects, ending with `next_page=W3sib3JkZXJ=`, your subsequent call can include `cursor=W3sib3JkZXJ=` in order to fetch the next page of the list.")
    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public ListQueryParams expand(List<String> expand) {
        this.expand = expand;
        return this;
    }

    public ListQueryParams addExpandItem(String expandItem) {
        if (this.expand == null) {
            this.expand = new ArrayList<String>();
        }
        this.expand.add(expandItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allows you to expand responses by including related object information in a single call. See the [Expand responses](https://developer.zuora.com/quickstart-api/tutorial/expand-responses/) section of the Quickstart API Tutorials for detailed instructions.")
    public List<String> getExpand() {
        return this.expand;
    }

    public void setExpand(List<String> expand) {
        this.expand = expand;
    }

    public ListQueryParams filter(List<String> filter) {
        this.filter = filter;
        return this;
    }

    public ListQueryParams addFilterItem(String filterItem) {
        if (this.filter == null) {
            this.filter = new ArrayList<String>();
        }
        this.filter.add(filterItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A case-sensitive filter on the list. See the [Filter lists](https://developer.zuora.com/quickstart-api/tutorial/filter-lists/) section of the Quickstart API Tutorials for detailed instructions.")
    public List<String> getFilter() {
        return this.filter;
    }

    public void setFilter(List<String> filter) {
        this.filter = filter;
    }

    public ListQueryParams sort(List<String> sort) {
        this.sort = sort;
        return this;
    }

    public ListQueryParams addSortItem(String sortItem) {
        if (this.sort == null) {
            this.sort = new ArrayList<String>();
        }
        this.sort.add(sortItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A case-sensitive query parameter that specifies the sort order of the list, which can be either ascending (e.g. `account_number.asc`) or descending (e.g. `account_number.desc`). You cannot sort on properties that are arrays. If the array-type properties are specified for the `sort[]` parameter, they are ignored.")
    public List<String> getSort() {
        return this.sort;
    }

    public void setSort(List<String> sort) {
        this.sort = sort;
    }

    public ListQueryParams pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum number of results to return in a single page. If the specified `page_size` is less than 1 or greater than 99, Zuora will return a 400 error.")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListQueryParams listQueryParams = (ListQueryParams)o;
        return Objects.equals(this.cursor, listQueryParams.cursor) && Objects.equals(this.expand, listQueryParams.expand) && Objects.equals(this.filter, listQueryParams.filter) && Objects.equals(this.sort, listQueryParams.sort) && Objects.equals(this.pageSize, listQueryParams.pageSize) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cursor, this.expand, this.filter, this.sort, this.pageSize, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListQueryParams {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    cursor: ").append(this.toIndentedString(this.cursor)).append("\n");
        sb.append("    expand: ").append(this.toIndentedString(this.expand)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

