/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CreditMemoItemApplicationRequest {
    public static final String SERIALIZED_NAME_CREDIT_MEMO_ITEM_ID = "credit_memo_item_id";
    @SerializedName(value="credit_memo_item_id")
    private String creditMemoItemId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_CREDIT_MEMO_TAXATION_ITEM_ID = "credit_memo_taxation_item_id";
    @SerializedName(value="credit_memo_taxation_item_id")
    private String creditMemoTaxationItemId;
    public static final String SERIALIZED_NAME_TAXATION_ITEM_ID = "taxation_item_id";
    @SerializedName(value="taxation_item_id")
    private String taxationItemId;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;

    public CreditMemoItemApplicationRequest creditMemoItemId(String creditMemoItemId) {
        this.creditMemoItemId = creditMemoItemId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier of the credit memo item to apply.")
    public String getCreditMemoItemId() {
        return this.creditMemoItemId;
    }

    public void setCreditMemoItemId(String creditMemoItemId) {
        this.creditMemoItemId = creditMemoItemId;
    }

    public CreditMemoItemApplicationRequest amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The credit memo amount applied to this billing document item or taxation item.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public CreditMemoItemApplicationRequest creditMemoTaxationItemId(String creditMemoTaxationItemId) {
        this.creditMemoTaxationItemId = creditMemoTaxationItemId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier of the credit memo taxation item to apply.")
    public String getCreditMemoTaxationItemId() {
        return this.creditMemoTaxationItemId;
    }

    public void setCreditMemoTaxationItemId(String creditMemoTaxationItemId) {
        this.creditMemoTaxationItemId = creditMemoTaxationItemId;
    }

    public CreditMemoItemApplicationRequest taxationItemId(String taxationItemId) {
        this.taxationItemId = taxationItemId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier of a taxation item.")
    public String getTaxationItemId() {
        return this.taxationItemId;
    }

    public void setTaxationItemId(String taxationItemId) {
        this.taxationItemId = taxationItemId;
    }

    public CreditMemoItemApplicationRequest id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier of an invoice item or debit memo item.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditMemoItemApplicationRequest creditMemoItemApplicationRequest = (CreditMemoItemApplicationRequest)o;
        return Objects.equals(this.creditMemoItemId, creditMemoItemApplicationRequest.creditMemoItemId) && Objects.equals(this.amount, creditMemoItemApplicationRequest.amount) && Objects.equals(this.creditMemoTaxationItemId, creditMemoItemApplicationRequest.creditMemoTaxationItemId) && Objects.equals(this.taxationItemId, creditMemoItemApplicationRequest.taxationItemId) && Objects.equals(this.id, creditMemoItemApplicationRequest.id);
    }

    public int hashCode() {
        return Objects.hash(this.creditMemoItemId, this.amount, this.creditMemoTaxationItemId, this.taxationItemId, this.id);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditMemoItemApplicationRequest {\n");
        sb.append("    creditMemoItemId: ").append(this.toIndentedString(this.creditMemoItemId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    creditMemoTaxationItemId: ").append(this.toIndentedString(this.creditMemoTaxationItemId)).append("\n");
        sb.append("    taxationItemId: ").append(this.toIndentedString(this.taxationItemId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

