/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.CustomerAcceptanceMandate;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="A mandate is a record of the permission a customer has given you to debit their payment method. This hash contains details about the mandate.")
public class CardMandate {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private String reason;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_NETWORK_TRANSACTION_ID = "network_transaction_id";
    @SerializedName(value="network_transaction_id")
    private String networkTransactionId;
    public static final String SERIALIZED_NAME_CUSTOMER_ACCEPTANCE = "customer_acceptance";
    @SerializedName(value="customer_acceptance")
    private CustomerAcceptanceMandate customerAcceptance;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_VERIFIED = "verified";
    @SerializedName(value="verified")
    private Boolean verified;
    public static final String SERIALIZED_NAME_VERIFY = "verify";
    @SerializedName(value="verify")
    private Boolean verify;

    public CardMandate() {
    }

    public CardMandate(StateEnum state, String networkTransactionId, CustomerAcceptanceMandate customerAcceptance, TypeEnum type, Boolean verified) {
        this();
        this.state = state;
        this.networkTransactionId = networkTransactionId;
        this.customerAcceptance = customerAcceptance;
        this.type = type;
        this.verified = verified;
    }

    public CardMandate id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the single- or multi-use mandate generated by the payment gateway.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CardMandate reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Reason for the mandate.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    @Nullable
    @ApiModelProperty(value="The status of the mandate, which indicates whether it can be used to initiate a payment.")
    public StateEnum getState() {
        return this.state;
    }

    @Nullable
    @ApiModelProperty(example="1234567890", value="Identifier of a network transaction.")
    public String getNetworkTransactionId() {
        return this.networkTransactionId;
    }

    @Nullable
    @ApiModelProperty(value="A reference to the consent agreement you have with your customer.")
    public CustomerAcceptanceMandate getCustomerAcceptance() {
        return this.customerAcceptance;
    }

    @Nullable
    @ApiModelProperty(value="Indicates the type of the stored credential profile, if any.")
    public TypeEnum getType() {
        return this.type;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Indicates the mandate was verified with the payment gateway by Zuora.")
    public Boolean getVerified() {
        return this.verified;
    }

    public CardMandate verify(Boolean verify) {
        this.verify = verify;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Specifies if Zuora should verify this mandate.")
    public Boolean getVerify() {
        return this.verify;
    }

    public void setVerify(Boolean verify) {
        this.verify = verify;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardMandate cardMandate = (CardMandate)o;
        return Objects.equals(this.id, cardMandate.id) && Objects.equals(this.reason, cardMandate.reason) && Objects.equals((Object)this.state, (Object)cardMandate.state) && Objects.equals(this.networkTransactionId, cardMandate.networkTransactionId) && Objects.equals(this.customerAcceptance, cardMandate.customerAcceptance) && Objects.equals((Object)this.type, (Object)cardMandate.type) && Objects.equals(this.verified, cardMandate.verified) && Objects.equals(this.verify, cardMandate.verify);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.reason, this.state, this.networkTransactionId, this.customerAcceptance, this.type, this.verified, this.verify});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CardMandate {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    networkTransactionId: ").append(this.toIndentedString(this.networkTransactionId)).append("\n");
        sb.append("    customerAcceptance: ").append(this.toIndentedString(this.customerAcceptance)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    verified: ").append(this.toIndentedString(this.verified)).append("\n");
        sb.append("    verify: ").append(this.toIndentedString(this.verify)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        MULTI_USE("multi_use"),
        SINGLE_USE("single_use"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        ACTIVE("active"),
        CANCELED("canceled"),
        EXPIRED("expired"),
        AGREED("agreed"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }
}

