/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Container for the address informtion.")
public class Address {
    public static final String SERIALIZED_NAME_LINE1 = "line1";
    @SerializedName(value="line1")
    private String line1;
    public static final String SERIALIZED_NAME_LINE2 = "line2";
    @SerializedName(value="line2")
    private String line2;
    public static final String SERIALIZED_NAME_CITY = "city";
    @SerializedName(value="city")
    private String city;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private String state;
    public static final String SERIALIZED_NAME_COUNTRY = "country";
    @SerializedName(value="country")
    private String country;
    public static final String SERIALIZED_NAME_COUNTY = "county";
    @SerializedName(value="county")
    private String county;
    public static final String SERIALIZED_NAME_POSTAL_CODE = "postal_code";
    @SerializedName(value="postal_code")
    private String postalCode;

    public Address line1(String line1) {
        this.line1 = line1;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="3333 Piedmont Rd NE", value="Address line 1 (e.g., street, PO Box, or company name).")
    public String getLine1() {
        return this.line1;
    }

    public void setLine1(String line1) {
        this.line1 = line1;
    }

    public Address line2(String line2) {
        this.line2 = line2;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Suite 1150", value="Address line 2 (e.g., apartment, suite, unit, or building).")
    public String getLine2() {
        return this.line2;
    }

    public void setLine2(String line2) {
        this.line2 = line2;
    }

    public Address city(String city) {
        this.city = city;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Atlanta", value="City, district, suburb, town, or village.")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Address state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="GA", value="State or providence")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Address country(String country) {
        this.country = country;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="United States", value="The country of the contact's address.")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public Address county(String county) {
        this.county = county;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Zuora Tax uses this information to calculate county taxation.")
    public String getCounty() {
        return this.county;
    }

    public void setCounty(String county) {
        this.county = county;
    }

    public Address postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="30305", value="ZIP or postal code.")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return Objects.equals(this.line1, address.line1) && Objects.equals(this.line2, address.line2) && Objects.equals(this.city, address.city) && Objects.equals(this.state, address.state) && Objects.equals(this.country, address.country) && Objects.equals(this.county, address.county) && Objects.equals(this.postalCode, address.postalCode);
    }

    public int hashCode() {
        return Objects.hash(this.line1, this.line2, this.city, this.state, this.country, this.county, this.postalCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Address {\n");
        sb.append("    line1: ").append(this.toIndentedString(this.line1)).append("\n");
        sb.append("    line2: ").append(this.toIndentedString(this.line2)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    county: ").append(this.toIndentedString(this.county)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

