/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.CancelSubscriptionRequest;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.GetByIdQueryParams;
import org.openapitools.client.model.Headers;
import org.openapitools.client.model.ListQueryParams;
import org.openapitools.client.model.PauseSubscriptionRequest;
import org.openapitools.client.model.ResumeSubscriptionRequest;
import org.openapitools.client.model.Subscription;
import org.openapitools.client.model.SubscriptionActivateRequest;
import org.openapitools.client.model.SubscriptionCancelResponse;
import org.openapitools.client.model.SubscriptionCreateRequest;
import org.openapitools.client.model.SubscriptionListResponse;
import org.openapitools.client.model.SubscriptionPatchRequest;
import org.openapitools.client.model.SubscriptionPreviewExistingRequest;
import org.openapitools.client.model.SubscriptionPreviewRequest;
import org.openapitools.client.model.SubscriptionPreviewResponse;
import org.openapitools.client.model.SubscriptionVersionListResponse;

public class SubscriptionsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SubscriptionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SubscriptionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call activateSubscriptionCall(String subscriptionId, SubscriptionActivateRequest subscriptionActivateRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SubscriptionActivateRequest localVarPostBody = subscriptionActivateRequest;
        String localVarPath = "/subscriptions/{subscription_id}/activate".replace("{subscription_id}", this.localVarApiClient.escapeString(subscriptionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (subscriptionFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription.fields[]", subscriptionFields));
        }
        if (subscriptionPlansFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_plans.fields[]", subscriptionPlansFields));
        }
        if (subscriptionItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_items.fields[]", subscriptionItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (invoiceOwnerAccountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_owner_account.fields[]", invoiceOwnerAccountFields));
        }
        if (planFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "plan.fields[]", planFields));
        }
        if (productFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "product.fields[]", productFields));
        }
        if (priceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "price.fields[]", priceFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (prepaidBalanceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prepaid_balance.fields[]", prepaidBalanceFields));
        }
        if (prepaidBalancesFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prepaid_balances.fields[]", prepaidBalancesFields));
        }
        if (validityPeriodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "validity_period.fields[]", validityPeriodFields));
        }
        if (transactionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "transactions.fields[]", transactionsFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call activateSubscriptionValidateBeforeCall(String subscriptionId, SubscriptionActivateRequest subscriptionActivateRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionId == null) {
            throw new ApiException("Missing the required parameter 'subscriptionId' when calling activateSubscription(Async)");
        }
        if (subscriptionActivateRequest == null) {
            throw new ApiException("Missing the required parameter 'subscriptionActivateRequest' when calling activateSubscription(Async)");
        }
        return this.activateSubscriptionCall(subscriptionId, subscriptionActivateRequest, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Subscription> activateSubscriptionWithHttpInfo(String subscriptionId, SubscriptionActivateRequest subscriptionActivateRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.activateSubscriptionValidateBeforeCall(subscriptionId, subscriptionActivateRequest, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Subscription>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call activateSubscriptionAsync(String subscriptionId, SubscriptionActivateRequest subscriptionActivateRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Subscription> _callback) throws ApiException {
        Call localVarCall = this.activateSubscriptionValidateBeforeCall(subscriptionId, subscriptionActivateRequest, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Subscription>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ActivateSubscriptionParams activateSubscriptionParams(String subscriptionId, SubscriptionActivateRequest subscriptionActivateRequest) {
        return new ActivateSubscriptionParams(subscriptionId, subscriptionActivateRequest);
    }

    public Subscription activateSubscription(String subscriptionId, SubscriptionActivateRequest subscriptionActivateRequest) throws ApiException {
        ActivateSubscriptionParams params = new ActivateSubscriptionParams(subscriptionId, subscriptionActivateRequest);
        return this.executeActivateSubscriptionAPICall(params).getData();
    }

    public Subscription activateSubscription(String subscriptionId, SubscriptionActivateRequest subscriptionActivateRequest, List<String> expand) throws ApiException {
        ActivateSubscriptionParams params = new ActivateSubscriptionParams(subscriptionId, subscriptionActivateRequest);
        params.expand(expand);
        return this.executeActivateSubscriptionAPICall(params).getData();
    }

    public Subscription activateSubscription(String subscriptionId, SubscriptionActivateRequest subscriptionActivateRequest, List<String> expand, Headers headers) throws ApiException {
        ActivateSubscriptionParams params = new ActivateSubscriptionParams(subscriptionId, subscriptionActivateRequest).expand(expand).headers(headers);
        return this.executeActivateSubscriptionAPICall(params).getData();
    }

    public Subscription activate(ActivateSubscriptionParams params) throws ApiException {
        return this.executeActivateSubscriptionAPICall(params).getData();
    }

    public ApiResponse<Subscription> activateWithHttpInfo(ActivateSubscriptionParams params) throws ApiException {
        return this.executeActivateSubscriptionAPICall(params);
    }

    ApiResponse<Subscription> executeActivateSubscriptionAPICall(ActivateSubscriptionParams params) throws ApiException {
        return this.activateSubscriptionWithHttpInfo(params.subscriptionId, params.subscriptionActivateRequest, params.fields, params.subscriptionFields, params.subscriptionPlansFields, params.subscriptionItemsFields, params.accountFields, params.invoiceOwnerAccountFields, params.planFields, params.productFields, params.priceFields, params.billToFields, params.prepaidBalanceFields, params.prepaidBalancesFields, params.validityPeriodFields, params.transactionsFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call cancelSubscriptionCall(String subscriptionId, CancelSubscriptionRequest cancelSubscriptionRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CancelSubscriptionRequest localVarPostBody = cancelSubscriptionRequest;
        String localVarPath = "/subscriptions/{subscription_id}/cancel".replace("{subscription_id}", this.localVarApiClient.escapeString(subscriptionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (subscriptionFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription.fields[]", subscriptionFields));
        }
        if (subscriptionPlansFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_plans.fields[]", subscriptionPlansFields));
        }
        if (subscriptionItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_items.fields[]", subscriptionItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (invoiceOwnerAccountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_owner_account.fields[]", invoiceOwnerAccountFields));
        }
        if (planFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "plan.fields[]", planFields));
        }
        if (productFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "product.fields[]", productFields));
        }
        if (priceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "price.fields[]", priceFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (prepaidBalanceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prepaid_balance.fields[]", prepaidBalanceFields));
        }
        if (prepaidBalancesFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prepaid_balances.fields[]", prepaidBalancesFields));
        }
        if (validityPeriodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "validity_period.fields[]", validityPeriodFields));
        }
        if (transactionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "transactions.fields[]", transactionsFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelSubscriptionValidateBeforeCall(String subscriptionId, CancelSubscriptionRequest cancelSubscriptionRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionId == null) {
            throw new ApiException("Missing the required parameter 'subscriptionId' when calling cancelSubscription(Async)");
        }
        if (cancelSubscriptionRequest == null) {
            throw new ApiException("Missing the required parameter 'cancelSubscriptionRequest' when calling cancelSubscription(Async)");
        }
        return this.cancelSubscriptionCall(subscriptionId, cancelSubscriptionRequest, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<SubscriptionCancelResponse> cancelSubscriptionWithHttpInfo(String subscriptionId, CancelSubscriptionRequest cancelSubscriptionRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.cancelSubscriptionValidateBeforeCall(subscriptionId, cancelSubscriptionRequest, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<SubscriptionCancelResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call cancelSubscriptionAsync(String subscriptionId, CancelSubscriptionRequest cancelSubscriptionRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<SubscriptionCancelResponse> _callback) throws ApiException {
        Call localVarCall = this.cancelSubscriptionValidateBeforeCall(subscriptionId, cancelSubscriptionRequest, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<SubscriptionCancelResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CancelSubscriptionParams cancelSubscriptionParams(String subscriptionId, CancelSubscriptionRequest cancelSubscriptionRequest) {
        return new CancelSubscriptionParams(subscriptionId, cancelSubscriptionRequest);
    }

    public SubscriptionCancelResponse cancelSubscription(String subscriptionId, CancelSubscriptionRequest cancelSubscriptionRequest) throws ApiException {
        CancelSubscriptionParams params = new CancelSubscriptionParams(subscriptionId, cancelSubscriptionRequest);
        return this.executeCancelSubscriptionAPICall(params).getData();
    }

    public SubscriptionCancelResponse cancelSubscription(String subscriptionId, CancelSubscriptionRequest cancelSubscriptionRequest, List<String> expand) throws ApiException {
        CancelSubscriptionParams params = new CancelSubscriptionParams(subscriptionId, cancelSubscriptionRequest);
        params.expand(expand);
        return this.executeCancelSubscriptionAPICall(params).getData();
    }

    public SubscriptionCancelResponse cancelSubscription(String subscriptionId, CancelSubscriptionRequest cancelSubscriptionRequest, List<String> expand, Headers headers) throws ApiException {
        CancelSubscriptionParams params = new CancelSubscriptionParams(subscriptionId, cancelSubscriptionRequest).expand(expand).headers(headers);
        return this.executeCancelSubscriptionAPICall(params).getData();
    }

    public SubscriptionCancelResponse cancel(CancelSubscriptionParams params) throws ApiException {
        return this.executeCancelSubscriptionAPICall(params).getData();
    }

    public ApiResponse<SubscriptionCancelResponse> cancelWithHttpInfo(CancelSubscriptionParams params) throws ApiException {
        return this.executeCancelSubscriptionAPICall(params);
    }

    ApiResponse<SubscriptionCancelResponse> executeCancelSubscriptionAPICall(CancelSubscriptionParams params) throws ApiException {
        return this.cancelSubscriptionWithHttpInfo(params.subscriptionId, params.cancelSubscriptionRequest, params.fields, params.subscriptionFields, params.subscriptionPlansFields, params.subscriptionItemsFields, params.accountFields, params.invoiceOwnerAccountFields, params.planFields, params.productFields, params.priceFields, params.billToFields, params.prepaidBalanceFields, params.prepaidBalancesFields, params.validityPeriodFields, params.transactionsFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call createSubscriptionCall(SubscriptionCreateRequest subscriptionCreateRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SubscriptionCreateRequest localVarPostBody = subscriptionCreateRequest;
        String localVarPath = "/subscriptions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (subscriptionFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription.fields[]", subscriptionFields));
        }
        if (subscriptionPlansFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_plans.fields[]", subscriptionPlansFields));
        }
        if (subscriptionItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_items.fields[]", subscriptionItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (invoiceOwnerAccountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_owner_account.fields[]", invoiceOwnerAccountFields));
        }
        if (planFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "plan.fields[]", planFields));
        }
        if (productFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "product.fields[]", productFields));
        }
        if (priceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "price.fields[]", priceFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (prepaidBalanceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prepaid_balance.fields[]", prepaidBalanceFields));
        }
        if (prepaidBalancesFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prepaid_balances.fields[]", prepaidBalancesFields));
        }
        if (validityPeriodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "validity_period.fields[]", validityPeriodFields));
        }
        if (transactionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "transactions.fields[]", transactionsFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSubscriptionValidateBeforeCall(SubscriptionCreateRequest subscriptionCreateRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'subscriptionCreateRequest' when calling createSubscription(Async)");
        }
        return this.createSubscriptionCall(subscriptionCreateRequest, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Subscription> createSubscriptionWithHttpInfo(SubscriptionCreateRequest subscriptionCreateRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createSubscriptionValidateBeforeCall(subscriptionCreateRequest, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Subscription>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createSubscriptionAsync(SubscriptionCreateRequest subscriptionCreateRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Subscription> _callback) throws ApiException {
        Call localVarCall = this.createSubscriptionValidateBeforeCall(subscriptionCreateRequest, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Subscription>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateSubscriptionParams createSubscriptionParams(SubscriptionCreateRequest subscriptionCreateRequest) {
        return new CreateSubscriptionParams(subscriptionCreateRequest);
    }

    public Subscription createSubscription(SubscriptionCreateRequest subscriptionCreateRequest) throws ApiException {
        CreateSubscriptionParams params = new CreateSubscriptionParams(subscriptionCreateRequest);
        return this.executeCreateSubscriptionAPICall(params).getData();
    }

    public Subscription createSubscription(SubscriptionCreateRequest subscriptionCreateRequest, List<String> expand) throws ApiException {
        CreateSubscriptionParams params = new CreateSubscriptionParams(subscriptionCreateRequest);
        params.expand(expand);
        return this.executeCreateSubscriptionAPICall(params).getData();
    }

    public Subscription createSubscription(SubscriptionCreateRequest subscriptionCreateRequest, List<String> expand, Headers headers) throws ApiException {
        CreateSubscriptionParams params = new CreateSubscriptionParams(subscriptionCreateRequest).expand(expand).headers(headers);
        return this.executeCreateSubscriptionAPICall(params).getData();
    }

    public Subscription create(CreateSubscriptionParams params) throws ApiException {
        return this.executeCreateSubscriptionAPICall(params).getData();
    }

    public ApiResponse<Subscription> createWithHttpInfo(CreateSubscriptionParams params) throws ApiException {
        return this.executeCreateSubscriptionAPICall(params);
    }

    ApiResponse<Subscription> executeCreateSubscriptionAPICall(CreateSubscriptionParams params) throws ApiException {
        return this.createSubscriptionWithHttpInfo(params.subscriptionCreateRequest, params.fields, params.subscriptionFields, params.subscriptionPlansFields, params.subscriptionItemsFields, params.accountFields, params.invoiceOwnerAccountFields, params.planFields, params.productFields, params.priceFields, params.billToFields, params.prepaidBalanceFields, params.prepaidBalancesFields, params.validityPeriodFields, params.transactionsFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getSubscriptionByKeyCall(String subscriptionId, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/subscriptions/{subscription_id}".replace("{subscription_id}", this.localVarApiClient.escapeString(subscriptionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (subscriptionFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription.fields[]", subscriptionFields));
        }
        if (subscriptionPlansFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_plans.fields[]", subscriptionPlansFields));
        }
        if (subscriptionItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_items.fields[]", subscriptionItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (invoiceOwnerAccountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_owner_account.fields[]", invoiceOwnerAccountFields));
        }
        if (planFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "plan.fields[]", planFields));
        }
        if (productFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "product.fields[]", productFields));
        }
        if (priceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "price.fields[]", priceFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (prepaidBalanceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prepaid_balance.fields[]", prepaidBalanceFields));
        }
        if (prepaidBalancesFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prepaid_balances.fields[]", prepaidBalancesFields));
        }
        if (validityPeriodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "validity_period.fields[]", validityPeriodFields));
        }
        if (transactionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "transactions.fields[]", transactionsFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSubscriptionByKeyValidateBeforeCall(String subscriptionId, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionId == null) {
            throw new ApiException("Missing the required parameter 'subscriptionId' when calling getSubscriptionByKey(Async)");
        }
        return this.getSubscriptionByKeyCall(subscriptionId, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Subscription> getSubscriptionByKeyWithHttpInfo(String subscriptionId, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getSubscriptionByKeyValidateBeforeCall(subscriptionId, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Subscription>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getSubscriptionByKeyAsync(String subscriptionId, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Subscription> _callback) throws ApiException {
        Call localVarCall = this.getSubscriptionByKeyValidateBeforeCall(subscriptionId, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Subscription>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetSubscriptionByKeyParams getSubscriptionByKeyParams(String subscriptionId) {
        return new GetSubscriptionByKeyParams(subscriptionId);
    }

    public Subscription getSubscriptionByKey(String subscriptionId) throws ApiException {
        GetSubscriptionByKeyParams params = new GetSubscriptionByKeyParams(subscriptionId);
        return this.executeGetSubscriptionByKeyAPICall(params).getData();
    }

    public Subscription getSubscriptionByKey(String subscriptionId, List<String> expand) throws ApiException {
        GetSubscriptionByKeyParams params = new GetSubscriptionByKeyParams(subscriptionId);
        params.expand(expand);
        return this.executeGetSubscriptionByKeyAPICall(params).getData();
    }

    public Subscription getSubscriptionByKey(String subscriptionId, List<String> expand, Headers headers) throws ApiException {
        GetSubscriptionByKeyParams params = new GetSubscriptionByKeyParams(subscriptionId).expand(expand).headers(headers);
        return this.executeGetSubscriptionByKeyAPICall(params).getData();
    }

    public Subscription get(GetSubscriptionByKeyParams params) throws ApiException {
        return this.executeGetSubscriptionByKeyAPICall(params).getData();
    }

    public ApiResponse<Subscription> getWithHttpInfo(GetSubscriptionByKeyParams params) throws ApiException {
        return this.executeGetSubscriptionByKeyAPICall(params);
    }

    ApiResponse<Subscription> executeGetSubscriptionByKeyAPICall(GetSubscriptionByKeyParams params) throws ApiException {
        return this.getSubscriptionByKeyWithHttpInfo(params.subscriptionId, params.fields, params.subscriptionFields, params.subscriptionPlansFields, params.subscriptionItemsFields, params.accountFields, params.invoiceOwnerAccountFields, params.planFields, params.productFields, params.priceFields, params.billToFields, params.prepaidBalanceFields, params.prepaidBalancesFields, params.validityPeriodFields, params.transactionsFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getSubscriptionByVersionCall(String subscriptionId, List<String> fields, List<String> subscriptionVersionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> actionsFields, String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/subscriptions/{subscription_id}/versions".replace("{subscription_id}", this.localVarApiClient.escapeString(subscriptionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (subscriptionVersionFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_version.fields[]", subscriptionVersionFields));
        }
        if (subscriptionPlansFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_plans.fields[]", subscriptionPlansFields));
        }
        if (subscriptionItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_items.fields[]", subscriptionItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (invoiceOwnerAccountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_owner_account.fields[]", invoiceOwnerAccountFields));
        }
        if (planFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "plan.fields[]", planFields));
        }
        if (productFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "product.fields[]", productFields));
        }
        if (priceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "price.fields[]", priceFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (prepaidBalanceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prepaid_balance.fields[]", prepaidBalanceFields));
        }
        if (prepaidBalancesFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prepaid_balances.fields[]", prepaidBalancesFields));
        }
        if (validityPeriodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "validity_period.fields[]", validityPeriodFields));
        }
        if (transactionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "transactions.fields[]", transactionsFields));
        }
        if (actionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "actions.fields[]", actionsFields));
        }
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (sort != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sort[]", sort));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSubscriptionByVersionValidateBeforeCall(String subscriptionId, List<String> fields, List<String> subscriptionVersionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> actionsFields, String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionId == null) {
            throw new ApiException("Missing the required parameter 'subscriptionId' when calling getSubscriptionByVersion(Async)");
        }
        return this.getSubscriptionByVersionCall(subscriptionId, fields, subscriptionVersionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, actionsFields, cursor, expand, filter, sort, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<SubscriptionVersionListResponse> getSubscriptionByVersionWithHttpInfo(String subscriptionId, List<String> fields, List<String> subscriptionVersionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> actionsFields, String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getSubscriptionByVersionValidateBeforeCall(subscriptionId, fields, subscriptionVersionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, actionsFields, cursor, expand, filter, sort, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<SubscriptionVersionListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getSubscriptionByVersionAsync(String subscriptionId, List<String> fields, List<String> subscriptionVersionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> actionsFields, String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<SubscriptionVersionListResponse> _callback) throws ApiException {
        Call localVarCall = this.getSubscriptionByVersionValidateBeforeCall(subscriptionId, fields, subscriptionVersionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, actionsFields, cursor, expand, filter, sort, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<SubscriptionVersionListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetSubscriptionByVersionParams getSubscriptionByVersionParams(String subscriptionId) {
        return new GetSubscriptionByVersionParams(subscriptionId);
    }

    public SubscriptionVersionListResponse getSubscriptionByVersion(String subscriptionId) throws ApiException {
        GetSubscriptionByVersionParams params = new GetSubscriptionByVersionParams(subscriptionId);
        return this.executeGetSubscriptionByVersionAPICall(params).getData();
    }

    public SubscriptionVersionListResponse getSubscriptionByVersion(String subscriptionId, String cursor, List<String> expand, List<String> filter) throws ApiException {
        GetSubscriptionByVersionParams params = new GetSubscriptionByVersionParams(subscriptionId);
        params.cursor(cursor);
        params.expand(expand);
        params.filter(filter);
        return this.executeGetSubscriptionByVersionAPICall(params).getData();
    }

    public SubscriptionVersionListResponse getSubscriptionByVersion(String subscriptionId, String cursor, List<String> expand, List<String> filter, Headers headers) throws ApiException {
        GetSubscriptionByVersionParams params = new GetSubscriptionByVersionParams(subscriptionId).cursor(cursor).expand(expand).filter(filter).headers(headers);
        return this.executeGetSubscriptionByVersionAPICall(params).getData();
    }

    public SubscriptionVersionListResponse listVersions(GetSubscriptionByVersionParams params) throws ApiException {
        return this.executeGetSubscriptionByVersionAPICall(params).getData();
    }

    public ApiResponse<SubscriptionVersionListResponse> listVersionsWithHttpInfo(GetSubscriptionByVersionParams params) throws ApiException {
        return this.executeGetSubscriptionByVersionAPICall(params);
    }

    ApiResponse<SubscriptionVersionListResponse> executeGetSubscriptionByVersionAPICall(GetSubscriptionByVersionParams params) throws ApiException {
        return this.getSubscriptionByVersionWithHttpInfo(params.subscriptionId, params.fields, params.subscriptionVersionFields, params.subscriptionPlansFields, params.subscriptionItemsFields, params.accountFields, params.invoiceOwnerAccountFields, params.planFields, params.productFields, params.priceFields, params.billToFields, params.prepaidBalanceFields, params.prepaidBalancesFields, params.validityPeriodFields, params.transactionsFields, params.actionsFields, params.cursor, params.expand, params.filter, params.sort, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getSubscriptionsCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/subscriptions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (sort != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sort[]", sort));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (subscriptionFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription.fields[]", subscriptionFields));
        }
        if (subscriptionPlansFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_plans.fields[]", subscriptionPlansFields));
        }
        if (subscriptionItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_items.fields[]", subscriptionItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (invoiceOwnerAccountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_owner_account.fields[]", invoiceOwnerAccountFields));
        }
        if (planFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "plan.fields[]", planFields));
        }
        if (productFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "product.fields[]", productFields));
        }
        if (priceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "price.fields[]", priceFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (prepaidBalanceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prepaid_balance.fields[]", prepaidBalanceFields));
        }
        if (prepaidBalancesFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prepaid_balances.fields[]", prepaidBalancesFields));
        }
        if (validityPeriodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "validity_period.fields[]", validityPeriodFields));
        }
        if (transactionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "transactions.fields[]", transactionsFields));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSubscriptionsValidateBeforeCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getSubscriptionsCall(cursor, expand, filter, sort, pageSize, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<SubscriptionListResponse> getSubscriptionsWithHttpInfo(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getSubscriptionsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<SubscriptionListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getSubscriptionsAsync(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<SubscriptionListResponse> _callback) throws ApiException {
        Call localVarCall = this.getSubscriptionsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<SubscriptionListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetSubscriptionsParams getSubscriptionsParams() {
        return new GetSubscriptionsParams();
    }

    public SubscriptionListResponse getSubscriptions() throws ApiException {
        GetSubscriptionsParams params = new GetSubscriptionsParams();
        return this.executeGetSubscriptionsAPICall(params).getData();
    }

    public SubscriptionListResponse getSubscriptions(String cursor, List<String> expand, List<String> filter) throws ApiException {
        GetSubscriptionsParams params = new GetSubscriptionsParams();
        params.cursor(cursor);
        params.expand(expand);
        params.filter(filter);
        return this.executeGetSubscriptionsAPICall(params).getData();
    }

    public SubscriptionListResponse getSubscriptions(String cursor, List<String> expand, List<String> filter, Headers headers) throws ApiException {
        GetSubscriptionsParams params = new GetSubscriptionsParams().cursor(cursor).expand(expand).filter(filter).headers(headers);
        return this.executeGetSubscriptionsAPICall(params).getData();
    }

    public SubscriptionListResponse list(GetSubscriptionsParams params) throws ApiException {
        return this.executeGetSubscriptionsAPICall(params).getData();
    }

    public ApiResponse<SubscriptionListResponse> listWithHttpInfo(GetSubscriptionsParams params) throws ApiException {
        return this.executeGetSubscriptionsAPICall(params);
    }

    ApiResponse<SubscriptionListResponse> executeGetSubscriptionsAPICall(GetSubscriptionsParams params) throws ApiException {
        return this.getSubscriptionsWithHttpInfo(params.cursor, params.expand, params.filter, params.sort, params.pageSize, params.fields, params.subscriptionFields, params.subscriptionPlansFields, params.subscriptionItemsFields, params.accountFields, params.invoiceOwnerAccountFields, params.planFields, params.productFields, params.priceFields, params.billToFields, params.prepaidBalanceFields, params.prepaidBalancesFields, params.validityPeriodFields, params.transactionsFields, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call patchSubscriptionCall(String subscriptionId, SubscriptionPatchRequest subscriptionPatchRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SubscriptionPatchRequest localVarPostBody = subscriptionPatchRequest;
        String localVarPath = "/subscriptions/{subscription_id}".replace("{subscription_id}", this.localVarApiClient.escapeString(subscriptionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (subscriptionFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription.fields[]", subscriptionFields));
        }
        if (subscriptionPlansFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_plans.fields[]", subscriptionPlansFields));
        }
        if (subscriptionItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_items.fields[]", subscriptionItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (invoiceOwnerAccountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_owner_account.fields[]", invoiceOwnerAccountFields));
        }
        if (planFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "plan.fields[]", planFields));
        }
        if (productFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "product.fields[]", productFields));
        }
        if (priceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "price.fields[]", priceFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (prepaidBalanceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prepaid_balance.fields[]", prepaidBalanceFields));
        }
        if (prepaidBalancesFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prepaid_balances.fields[]", prepaidBalancesFields));
        }
        if (validityPeriodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "validity_period.fields[]", validityPeriodFields));
        }
        if (transactionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "transactions.fields[]", transactionsFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSubscriptionValidateBeforeCall(String subscriptionId, SubscriptionPatchRequest subscriptionPatchRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionId == null) {
            throw new ApiException("Missing the required parameter 'subscriptionId' when calling patchSubscription(Async)");
        }
        if (subscriptionPatchRequest == null) {
            throw new ApiException("Missing the required parameter 'subscriptionPatchRequest' when calling patchSubscription(Async)");
        }
        return this.patchSubscriptionCall(subscriptionId, subscriptionPatchRequest, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Subscription> patchSubscriptionWithHttpInfo(String subscriptionId, SubscriptionPatchRequest subscriptionPatchRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.patchSubscriptionValidateBeforeCall(subscriptionId, subscriptionPatchRequest, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Subscription>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call patchSubscriptionAsync(String subscriptionId, SubscriptionPatchRequest subscriptionPatchRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Subscription> _callback) throws ApiException {
        Call localVarCall = this.patchSubscriptionValidateBeforeCall(subscriptionId, subscriptionPatchRequest, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Subscription>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PatchSubscriptionParams patchSubscriptionParams(String subscriptionId, SubscriptionPatchRequest subscriptionPatchRequest) {
        return new PatchSubscriptionParams(subscriptionId, subscriptionPatchRequest);
    }

    public Subscription patchSubscription(String subscriptionId, SubscriptionPatchRequest subscriptionPatchRequest) throws ApiException {
        PatchSubscriptionParams params = new PatchSubscriptionParams(subscriptionId, subscriptionPatchRequest);
        return this.executePatchSubscriptionAPICall(params).getData();
    }

    public Subscription patchSubscription(String subscriptionId, SubscriptionPatchRequest subscriptionPatchRequest, List<String> expand) throws ApiException {
        PatchSubscriptionParams params = new PatchSubscriptionParams(subscriptionId, subscriptionPatchRequest);
        params.expand(expand);
        return this.executePatchSubscriptionAPICall(params).getData();
    }

    public Subscription patchSubscription(String subscriptionId, SubscriptionPatchRequest subscriptionPatchRequest, List<String> expand, Headers headers) throws ApiException {
        PatchSubscriptionParams params = new PatchSubscriptionParams(subscriptionId, subscriptionPatchRequest).expand(expand).headers(headers);
        return this.executePatchSubscriptionAPICall(params).getData();
    }

    public Subscription update(PatchSubscriptionParams params) throws ApiException {
        return this.executePatchSubscriptionAPICall(params).getData();
    }

    public ApiResponse<Subscription> updateWithHttpInfo(PatchSubscriptionParams params) throws ApiException {
        return this.executePatchSubscriptionAPICall(params);
    }

    ApiResponse<Subscription> executePatchSubscriptionAPICall(PatchSubscriptionParams params) throws ApiException {
        return this.patchSubscriptionWithHttpInfo(params.subscriptionId, params.subscriptionPatchRequest, params.fields, params.subscriptionFields, params.subscriptionPlansFields, params.subscriptionItemsFields, params.accountFields, params.invoiceOwnerAccountFields, params.planFields, params.productFields, params.priceFields, params.billToFields, params.prepaidBalanceFields, params.prepaidBalancesFields, params.validityPeriodFields, params.transactionsFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call pauseSubscriptionCall(String subscriptionId, PauseSubscriptionRequest pauseSubscriptionRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PauseSubscriptionRequest localVarPostBody = pauseSubscriptionRequest;
        String localVarPath = "/subscriptions/{subscription_id}/pause".replace("{subscription_id}", this.localVarApiClient.escapeString(subscriptionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (subscriptionFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription.fields[]", subscriptionFields));
        }
        if (subscriptionPlansFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_plans.fields[]", subscriptionPlansFields));
        }
        if (subscriptionItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_items.fields[]", subscriptionItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (invoiceOwnerAccountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_owner_account.fields[]", invoiceOwnerAccountFields));
        }
        if (planFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "plan.fields[]", planFields));
        }
        if (productFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "product.fields[]", productFields));
        }
        if (priceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "price.fields[]", priceFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (prepaidBalanceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prepaid_balance.fields[]", prepaidBalanceFields));
        }
        if (prepaidBalancesFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prepaid_balances.fields[]", prepaidBalancesFields));
        }
        if (validityPeriodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "validity_period.fields[]", validityPeriodFields));
        }
        if (transactionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "transactions.fields[]", transactionsFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call pauseSubscriptionValidateBeforeCall(String subscriptionId, PauseSubscriptionRequest pauseSubscriptionRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionId == null) {
            throw new ApiException("Missing the required parameter 'subscriptionId' when calling pauseSubscription(Async)");
        }
        if (pauseSubscriptionRequest == null) {
            throw new ApiException("Missing the required parameter 'pauseSubscriptionRequest' when calling pauseSubscription(Async)");
        }
        return this.pauseSubscriptionCall(subscriptionId, pauseSubscriptionRequest, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Subscription> pauseSubscriptionWithHttpInfo(String subscriptionId, PauseSubscriptionRequest pauseSubscriptionRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.pauseSubscriptionValidateBeforeCall(subscriptionId, pauseSubscriptionRequest, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Subscription>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call pauseSubscriptionAsync(String subscriptionId, PauseSubscriptionRequest pauseSubscriptionRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Subscription> _callback) throws ApiException {
        Call localVarCall = this.pauseSubscriptionValidateBeforeCall(subscriptionId, pauseSubscriptionRequest, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Subscription>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PauseSubscriptionParams pauseSubscriptionParams(String subscriptionId, PauseSubscriptionRequest pauseSubscriptionRequest) {
        return new PauseSubscriptionParams(subscriptionId, pauseSubscriptionRequest);
    }

    public Subscription pauseSubscription(String subscriptionId, PauseSubscriptionRequest pauseSubscriptionRequest) throws ApiException {
        PauseSubscriptionParams params = new PauseSubscriptionParams(subscriptionId, pauseSubscriptionRequest);
        return this.executePauseSubscriptionAPICall(params).getData();
    }

    public Subscription pauseSubscription(String subscriptionId, PauseSubscriptionRequest pauseSubscriptionRequest, List<String> expand) throws ApiException {
        PauseSubscriptionParams params = new PauseSubscriptionParams(subscriptionId, pauseSubscriptionRequest);
        params.expand(expand);
        return this.executePauseSubscriptionAPICall(params).getData();
    }

    public Subscription pauseSubscription(String subscriptionId, PauseSubscriptionRequest pauseSubscriptionRequest, List<String> expand, Headers headers) throws ApiException {
        PauseSubscriptionParams params = new PauseSubscriptionParams(subscriptionId, pauseSubscriptionRequest).expand(expand).headers(headers);
        return this.executePauseSubscriptionAPICall(params).getData();
    }

    public Subscription pause(PauseSubscriptionParams params) throws ApiException {
        return this.executePauseSubscriptionAPICall(params).getData();
    }

    public ApiResponse<Subscription> pauseWithHttpInfo(PauseSubscriptionParams params) throws ApiException {
        return this.executePauseSubscriptionAPICall(params);
    }

    ApiResponse<Subscription> executePauseSubscriptionAPICall(PauseSubscriptionParams params) throws ApiException {
        return this.pauseSubscriptionWithHttpInfo(params.subscriptionId, params.pauseSubscriptionRequest, params.fields, params.subscriptionFields, params.subscriptionPlansFields, params.subscriptionItemsFields, params.accountFields, params.invoiceOwnerAccountFields, params.planFields, params.productFields, params.priceFields, params.billToFields, params.prepaidBalanceFields, params.prepaidBalancesFields, params.validityPeriodFields, params.transactionsFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call previewExistingSubscriptionCall(String subscriptionId, SubscriptionPreviewExistingRequest subscriptionPreviewExistingRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SubscriptionPreviewExistingRequest localVarPostBody = subscriptionPreviewExistingRequest;
        String localVarPath = "/subscriptions/{subscription_id}/preview".replace("{subscription_id}", this.localVarApiClient.escapeString(subscriptionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call previewExistingSubscriptionValidateBeforeCall(String subscriptionId, SubscriptionPreviewExistingRequest subscriptionPreviewExistingRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionId == null) {
            throw new ApiException("Missing the required parameter 'subscriptionId' when calling previewExistingSubscription(Async)");
        }
        if (subscriptionPreviewExistingRequest == null) {
            throw new ApiException("Missing the required parameter 'subscriptionPreviewExistingRequest' when calling previewExistingSubscription(Async)");
        }
        return this.previewExistingSubscriptionCall(subscriptionId, subscriptionPreviewExistingRequest, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<SubscriptionPreviewResponse> previewExistingSubscriptionWithHttpInfo(String subscriptionId, SubscriptionPreviewExistingRequest subscriptionPreviewExistingRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.previewExistingSubscriptionValidateBeforeCall(subscriptionId, subscriptionPreviewExistingRequest, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<SubscriptionPreviewResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call previewExistingSubscriptionAsync(String subscriptionId, SubscriptionPreviewExistingRequest subscriptionPreviewExistingRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<SubscriptionPreviewResponse> _callback) throws ApiException {
        Call localVarCall = this.previewExistingSubscriptionValidateBeforeCall(subscriptionId, subscriptionPreviewExistingRequest, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<SubscriptionPreviewResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PreviewExistingSubscriptionParams previewExistingSubscriptionParams(String subscriptionId, SubscriptionPreviewExistingRequest subscriptionPreviewExistingRequest) {
        return new PreviewExistingSubscriptionParams(subscriptionId, subscriptionPreviewExistingRequest);
    }

    public SubscriptionPreviewResponse previewExistingSubscription(String subscriptionId, SubscriptionPreviewExistingRequest subscriptionPreviewExistingRequest) throws ApiException {
        PreviewExistingSubscriptionParams params = new PreviewExistingSubscriptionParams(subscriptionId, subscriptionPreviewExistingRequest);
        return this.executePreviewExistingSubscriptionAPICall(params).getData();
    }

    public SubscriptionPreviewResponse previewExistingSubscription(String subscriptionId, SubscriptionPreviewExistingRequest subscriptionPreviewExistingRequest, Headers headers) throws ApiException {
        PreviewExistingSubscriptionParams params = new PreviewExistingSubscriptionParams(subscriptionId, subscriptionPreviewExistingRequest).headers(headers);
        return this.executePreviewExistingSubscriptionAPICall(params).getData();
    }

    public SubscriptionPreviewResponse previewExistingSubscription(PreviewExistingSubscriptionParams params) throws ApiException {
        return this.executePreviewExistingSubscriptionAPICall(params).getData();
    }

    public ApiResponse<SubscriptionPreviewResponse> previewExistingSubscriptionWithHttpInfo(PreviewExistingSubscriptionParams params) throws ApiException {
        return this.executePreviewExistingSubscriptionAPICall(params);
    }

    ApiResponse<SubscriptionPreviewResponse> executePreviewExistingSubscriptionAPICall(PreviewExistingSubscriptionParams params) throws ApiException {
        return this.previewExistingSubscriptionWithHttpInfo(params.subscriptionId, params.subscriptionPreviewExistingRequest, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call previewSubscriptionCall(SubscriptionPreviewRequest subscriptionPreviewRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SubscriptionPreviewRequest localVarPostBody = subscriptionPreviewRequest;
        String localVarPath = "/subscriptions/preview";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call previewSubscriptionValidateBeforeCall(SubscriptionPreviewRequest subscriptionPreviewRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionPreviewRequest == null) {
            throw new ApiException("Missing the required parameter 'subscriptionPreviewRequest' when calling previewSubscription(Async)");
        }
        return this.previewSubscriptionCall(subscriptionPreviewRequest, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<SubscriptionPreviewResponse> previewSubscriptionWithHttpInfo(SubscriptionPreviewRequest subscriptionPreviewRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.previewSubscriptionValidateBeforeCall(subscriptionPreviewRequest, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<SubscriptionPreviewResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call previewSubscriptionAsync(SubscriptionPreviewRequest subscriptionPreviewRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<SubscriptionPreviewResponse> _callback) throws ApiException {
        Call localVarCall = this.previewSubscriptionValidateBeforeCall(subscriptionPreviewRequest, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<SubscriptionPreviewResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PreviewSubscriptionParams previewSubscriptionParams(SubscriptionPreviewRequest subscriptionPreviewRequest) {
        return new PreviewSubscriptionParams(subscriptionPreviewRequest);
    }

    public SubscriptionPreviewResponse previewSubscription(SubscriptionPreviewRequest subscriptionPreviewRequest) throws ApiException {
        PreviewSubscriptionParams params = new PreviewSubscriptionParams(subscriptionPreviewRequest);
        return this.executePreviewSubscriptionAPICall(params).getData();
    }

    public SubscriptionPreviewResponse previewSubscription(SubscriptionPreviewRequest subscriptionPreviewRequest, Headers headers) throws ApiException {
        PreviewSubscriptionParams params = new PreviewSubscriptionParams(subscriptionPreviewRequest).headers(headers);
        return this.executePreviewSubscriptionAPICall(params).getData();
    }

    public SubscriptionPreviewResponse preview(PreviewSubscriptionParams params) throws ApiException {
        return this.executePreviewSubscriptionAPICall(params).getData();
    }

    public ApiResponse<SubscriptionPreviewResponse> previewWithHttpInfo(PreviewSubscriptionParams params) throws ApiException {
        return this.executePreviewSubscriptionAPICall(params);
    }

    ApiResponse<SubscriptionPreviewResponse> executePreviewSubscriptionAPICall(PreviewSubscriptionParams params) throws ApiException {
        return this.previewSubscriptionWithHttpInfo(params.subscriptionPreviewRequest, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call resumeSubscriptionCall(String subscriptionId, ResumeSubscriptionRequest resumeSubscriptionRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ResumeSubscriptionRequest localVarPostBody = resumeSubscriptionRequest;
        String localVarPath = "/subscriptions/{subscription_id}/resume".replace("{subscription_id}", this.localVarApiClient.escapeString(subscriptionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (subscriptionFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription.fields[]", subscriptionFields));
        }
        if (subscriptionPlansFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_plans.fields[]", subscriptionPlansFields));
        }
        if (subscriptionItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_items.fields[]", subscriptionItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (invoiceOwnerAccountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_owner_account.fields[]", invoiceOwnerAccountFields));
        }
        if (planFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "plan.fields[]", planFields));
        }
        if (productFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "product.fields[]", productFields));
        }
        if (priceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "price.fields[]", priceFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (prepaidBalanceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prepaid_balance.fields[]", prepaidBalanceFields));
        }
        if (prepaidBalancesFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prepaid_balances.fields[]", prepaidBalancesFields));
        }
        if (validityPeriodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "validity_period.fields[]", validityPeriodFields));
        }
        if (transactionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "transactions.fields[]", transactionsFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call resumeSubscriptionValidateBeforeCall(String subscriptionId, ResumeSubscriptionRequest resumeSubscriptionRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionId == null) {
            throw new ApiException("Missing the required parameter 'subscriptionId' when calling resumeSubscription(Async)");
        }
        if (resumeSubscriptionRequest == null) {
            throw new ApiException("Missing the required parameter 'resumeSubscriptionRequest' when calling resumeSubscription(Async)");
        }
        return this.resumeSubscriptionCall(subscriptionId, resumeSubscriptionRequest, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Subscription> resumeSubscriptionWithHttpInfo(String subscriptionId, ResumeSubscriptionRequest resumeSubscriptionRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.resumeSubscriptionValidateBeforeCall(subscriptionId, resumeSubscriptionRequest, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Subscription>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call resumeSubscriptionAsync(String subscriptionId, ResumeSubscriptionRequest resumeSubscriptionRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Subscription> _callback) throws ApiException {
        Call localVarCall = this.resumeSubscriptionValidateBeforeCall(subscriptionId, resumeSubscriptionRequest, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Subscription>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ResumeSubscriptionParams resumeSubscriptionParams(String subscriptionId, ResumeSubscriptionRequest resumeSubscriptionRequest) {
        return new ResumeSubscriptionParams(subscriptionId, resumeSubscriptionRequest);
    }

    public Subscription resumeSubscription(String subscriptionId, ResumeSubscriptionRequest resumeSubscriptionRequest) throws ApiException {
        ResumeSubscriptionParams params = new ResumeSubscriptionParams(subscriptionId, resumeSubscriptionRequest);
        return this.executeResumeSubscriptionAPICall(params).getData();
    }

    public Subscription resumeSubscription(String subscriptionId, ResumeSubscriptionRequest resumeSubscriptionRequest, List<String> expand) throws ApiException {
        ResumeSubscriptionParams params = new ResumeSubscriptionParams(subscriptionId, resumeSubscriptionRequest);
        params.expand(expand);
        return this.executeResumeSubscriptionAPICall(params).getData();
    }

    public Subscription resumeSubscription(String subscriptionId, ResumeSubscriptionRequest resumeSubscriptionRequest, List<String> expand, Headers headers) throws ApiException {
        ResumeSubscriptionParams params = new ResumeSubscriptionParams(subscriptionId, resumeSubscriptionRequest).expand(expand).headers(headers);
        return this.executeResumeSubscriptionAPICall(params).getData();
    }

    public Subscription resume(ResumeSubscriptionParams params) throws ApiException {
        return this.executeResumeSubscriptionAPICall(params).getData();
    }

    public ApiResponse<Subscription> resumeWithHttpInfo(ResumeSubscriptionParams params) throws ApiException {
        return this.executeResumeSubscriptionAPICall(params);
    }

    ApiResponse<Subscription> executeResumeSubscriptionAPICall(ResumeSubscriptionParams params) throws ApiException {
        return this.resumeSubscriptionWithHttpInfo(params.subscriptionId, params.resumeSubscriptionRequest, params.fields, params.subscriptionFields, params.subscriptionPlansFields, params.subscriptionItemsFields, params.accountFields, params.invoiceOwnerAccountFields, params.planFields, params.productFields, params.priceFields, params.billToFields, params.prepaidBalanceFields, params.prepaidBalancesFields, params.validityPeriodFields, params.transactionsFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call uncancelSubscriptionCall(String subscriptionId, SubscriptionPatchRequest subscriptionPatchRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SubscriptionPatchRequest localVarPostBody = subscriptionPatchRequest;
        String localVarPath = "/subscriptions/{subscription_id}/keep".replace("{subscription_id}", this.localVarApiClient.escapeString(subscriptionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (subscriptionFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription.fields[]", subscriptionFields));
        }
        if (subscriptionPlansFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_plans.fields[]", subscriptionPlansFields));
        }
        if (subscriptionItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_items.fields[]", subscriptionItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (invoiceOwnerAccountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_owner_account.fields[]", invoiceOwnerAccountFields));
        }
        if (planFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "plan.fields[]", planFields));
        }
        if (productFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "product.fields[]", productFields));
        }
        if (priceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "price.fields[]", priceFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (prepaidBalanceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prepaid_balance.fields[]", prepaidBalanceFields));
        }
        if (prepaidBalancesFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prepaid_balances.fields[]", prepaidBalancesFields));
        }
        if (validityPeriodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "validity_period.fields[]", validityPeriodFields));
        }
        if (transactionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "transactions.fields[]", transactionsFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call uncancelSubscriptionValidateBeforeCall(String subscriptionId, SubscriptionPatchRequest subscriptionPatchRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionId == null) {
            throw new ApiException("Missing the required parameter 'subscriptionId' when calling uncancelSubscription(Async)");
        }
        if (subscriptionPatchRequest == null) {
            throw new ApiException("Missing the required parameter 'subscriptionPatchRequest' when calling uncancelSubscription(Async)");
        }
        return this.uncancelSubscriptionCall(subscriptionId, subscriptionPatchRequest, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Subscription> uncancelSubscriptionWithHttpInfo(String subscriptionId, SubscriptionPatchRequest subscriptionPatchRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.uncancelSubscriptionValidateBeforeCall(subscriptionId, subscriptionPatchRequest, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Subscription>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call uncancelSubscriptionAsync(String subscriptionId, SubscriptionPatchRequest subscriptionPatchRequest, List<String> fields, List<String> subscriptionFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> accountFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> productFields, List<String> priceFields, List<String> billToFields, List<String> prepaidBalanceFields, List<String> prepaidBalancesFields, List<String> validityPeriodFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Subscription> _callback) throws ApiException {
        Call localVarCall = this.uncancelSubscriptionValidateBeforeCall(subscriptionId, subscriptionPatchRequest, fields, subscriptionFields, subscriptionPlansFields, subscriptionItemsFields, accountFields, invoiceOwnerAccountFields, planFields, productFields, priceFields, billToFields, prepaidBalanceFields, prepaidBalancesFields, validityPeriodFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Subscription>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public UncancelSubscriptionParams uncancelSubscriptionParams(String subscriptionId, SubscriptionPatchRequest subscriptionPatchRequest) {
        return new UncancelSubscriptionParams(subscriptionId, subscriptionPatchRequest);
    }

    public Subscription uncancelSubscription(String subscriptionId, SubscriptionPatchRequest subscriptionPatchRequest) throws ApiException {
        UncancelSubscriptionParams params = new UncancelSubscriptionParams(subscriptionId, subscriptionPatchRequest);
        return this.executeUncancelSubscriptionAPICall(params).getData();
    }

    public Subscription uncancelSubscription(String subscriptionId, SubscriptionPatchRequest subscriptionPatchRequest, List<String> expand) throws ApiException {
        UncancelSubscriptionParams params = new UncancelSubscriptionParams(subscriptionId, subscriptionPatchRequest);
        params.expand(expand);
        return this.executeUncancelSubscriptionAPICall(params).getData();
    }

    public Subscription uncancelSubscription(String subscriptionId, SubscriptionPatchRequest subscriptionPatchRequest, List<String> expand, Headers headers) throws ApiException {
        UncancelSubscriptionParams params = new UncancelSubscriptionParams(subscriptionId, subscriptionPatchRequest).expand(expand).headers(headers);
        return this.executeUncancelSubscriptionAPICall(params).getData();
    }

    @Deprecated
    public Subscription cancel(UncancelSubscriptionParams params) throws ApiException {
        return this.executeUncancelSubscriptionAPICall(params).getData();
    }

    public ApiResponse<Subscription> cancelWithHttpInfo(UncancelSubscriptionParams params) throws ApiException {
        return this.executeUncancelSubscriptionAPICall(params);
    }

    ApiResponse<Subscription> executeUncancelSubscriptionAPICall(UncancelSubscriptionParams params) throws ApiException {
        return this.uncancelSubscriptionWithHttpInfo(params.subscriptionId, params.subscriptionPatchRequest, params.fields, params.subscriptionFields, params.subscriptionPlansFields, params.subscriptionItemsFields, params.accountFields, params.invoiceOwnerAccountFields, params.planFields, params.productFields, params.priceFields, params.billToFields, params.prepaidBalanceFields, params.prepaidBalancesFields, params.validityPeriodFields, params.transactionsFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    public static class UncancelSubscriptionParams {
        private final String subscriptionId;
        private final SubscriptionPatchRequest subscriptionPatchRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> subscriptionFields;
        private List<String> subscriptionPlansFields;
        private List<String> subscriptionItemsFields;
        private List<String> accountFields;
        private List<String> invoiceOwnerAccountFields;
        private List<String> planFields;
        private List<String> productFields;
        private List<String> priceFields;
        private List<String> billToFields;
        private List<String> prepaidBalanceFields;
        private List<String> prepaidBalancesFields;
        private List<String> validityPeriodFields;
        private List<String> transactionsFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public UncancelSubscriptionParams(String subscriptionId, SubscriptionPatchRequest subscriptionPatchRequest) {
            this.subscriptionId = subscriptionId;
            this.subscriptionPatchRequest = subscriptionPatchRequest;
        }

        public UncancelSubscriptionParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public UncancelSubscriptionParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public UncancelSubscriptionParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public UncancelSubscriptionParams subscriptionFields(List<String> subscriptionFields) {
            this.subscriptionFields = subscriptionFields;
            return this;
        }

        public UncancelSubscriptionParams subscriptionPlansFields(List<String> subscriptionPlansFields) {
            this.subscriptionPlansFields = subscriptionPlansFields;
            return this;
        }

        public UncancelSubscriptionParams subscriptionItemsFields(List<String> subscriptionItemsFields) {
            this.subscriptionItemsFields = subscriptionItemsFields;
            return this;
        }

        public UncancelSubscriptionParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public UncancelSubscriptionParams invoiceOwnerAccountFields(List<String> invoiceOwnerAccountFields) {
            this.invoiceOwnerAccountFields = invoiceOwnerAccountFields;
            return this;
        }

        public UncancelSubscriptionParams planFields(List<String> planFields) {
            this.planFields = planFields;
            return this;
        }

        public UncancelSubscriptionParams productFields(List<String> productFields) {
            this.productFields = productFields;
            return this;
        }

        public UncancelSubscriptionParams priceFields(List<String> priceFields) {
            this.priceFields = priceFields;
            return this;
        }

        public UncancelSubscriptionParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public UncancelSubscriptionParams prepaidBalanceFields(List<String> prepaidBalanceFields) {
            this.prepaidBalanceFields = prepaidBalanceFields;
            return this;
        }

        public UncancelSubscriptionParams prepaidBalancesFields(List<String> prepaidBalancesFields) {
            this.prepaidBalancesFields = prepaidBalancesFields;
            return this;
        }

        public UncancelSubscriptionParams validityPeriodFields(List<String> validityPeriodFields) {
            this.validityPeriodFields = validityPeriodFields;
            return this;
        }

        public UncancelSubscriptionParams transactionsFields(List<String> transactionsFields) {
            this.transactionsFields = transactionsFields;
            return this;
        }

        public UncancelSubscriptionParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public UncancelSubscriptionParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public UncancelSubscriptionParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class ResumeSubscriptionParams {
        private final String subscriptionId;
        private final ResumeSubscriptionRequest resumeSubscriptionRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> subscriptionFields;
        private List<String> subscriptionPlansFields;
        private List<String> subscriptionItemsFields;
        private List<String> accountFields;
        private List<String> invoiceOwnerAccountFields;
        private List<String> planFields;
        private List<String> productFields;
        private List<String> priceFields;
        private List<String> billToFields;
        private List<String> prepaidBalanceFields;
        private List<String> prepaidBalancesFields;
        private List<String> validityPeriodFields;
        private List<String> transactionsFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public ResumeSubscriptionParams(String subscriptionId, ResumeSubscriptionRequest resumeSubscriptionRequest) {
            this.subscriptionId = subscriptionId;
            this.resumeSubscriptionRequest = resumeSubscriptionRequest;
        }

        public ResumeSubscriptionParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public ResumeSubscriptionParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public ResumeSubscriptionParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public ResumeSubscriptionParams subscriptionFields(List<String> subscriptionFields) {
            this.subscriptionFields = subscriptionFields;
            return this;
        }

        public ResumeSubscriptionParams subscriptionPlansFields(List<String> subscriptionPlansFields) {
            this.subscriptionPlansFields = subscriptionPlansFields;
            return this;
        }

        public ResumeSubscriptionParams subscriptionItemsFields(List<String> subscriptionItemsFields) {
            this.subscriptionItemsFields = subscriptionItemsFields;
            return this;
        }

        public ResumeSubscriptionParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public ResumeSubscriptionParams invoiceOwnerAccountFields(List<String> invoiceOwnerAccountFields) {
            this.invoiceOwnerAccountFields = invoiceOwnerAccountFields;
            return this;
        }

        public ResumeSubscriptionParams planFields(List<String> planFields) {
            this.planFields = planFields;
            return this;
        }

        public ResumeSubscriptionParams productFields(List<String> productFields) {
            this.productFields = productFields;
            return this;
        }

        public ResumeSubscriptionParams priceFields(List<String> priceFields) {
            this.priceFields = priceFields;
            return this;
        }

        public ResumeSubscriptionParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public ResumeSubscriptionParams prepaidBalanceFields(List<String> prepaidBalanceFields) {
            this.prepaidBalanceFields = prepaidBalanceFields;
            return this;
        }

        public ResumeSubscriptionParams prepaidBalancesFields(List<String> prepaidBalancesFields) {
            this.prepaidBalancesFields = prepaidBalancesFields;
            return this;
        }

        public ResumeSubscriptionParams validityPeriodFields(List<String> validityPeriodFields) {
            this.validityPeriodFields = validityPeriodFields;
            return this;
        }

        public ResumeSubscriptionParams transactionsFields(List<String> transactionsFields) {
            this.transactionsFields = transactionsFields;
            return this;
        }

        public ResumeSubscriptionParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public ResumeSubscriptionParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public ResumeSubscriptionParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class PreviewSubscriptionParams {
        private final SubscriptionPreviewRequest subscriptionPreviewRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public PreviewSubscriptionParams(SubscriptionPreviewRequest subscriptionPreviewRequest) {
            this.subscriptionPreviewRequest = subscriptionPreviewRequest;
        }

        public PreviewSubscriptionParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }
    }

    public static class PreviewExistingSubscriptionParams {
        private final String subscriptionId;
        private final SubscriptionPreviewExistingRequest subscriptionPreviewExistingRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public PreviewExistingSubscriptionParams(String subscriptionId, SubscriptionPreviewExistingRequest subscriptionPreviewExistingRequest) {
            this.subscriptionId = subscriptionId;
            this.subscriptionPreviewExistingRequest = subscriptionPreviewExistingRequest;
        }

        public PreviewExistingSubscriptionParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }
    }

    public static class PauseSubscriptionParams {
        private final String subscriptionId;
        private final PauseSubscriptionRequest pauseSubscriptionRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> subscriptionFields;
        private List<String> subscriptionPlansFields;
        private List<String> subscriptionItemsFields;
        private List<String> accountFields;
        private List<String> invoiceOwnerAccountFields;
        private List<String> planFields;
        private List<String> productFields;
        private List<String> priceFields;
        private List<String> billToFields;
        private List<String> prepaidBalanceFields;
        private List<String> prepaidBalancesFields;
        private List<String> validityPeriodFields;
        private List<String> transactionsFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public PauseSubscriptionParams(String subscriptionId, PauseSubscriptionRequest pauseSubscriptionRequest) {
            this.subscriptionId = subscriptionId;
            this.pauseSubscriptionRequest = pauseSubscriptionRequest;
        }

        public PauseSubscriptionParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public PauseSubscriptionParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public PauseSubscriptionParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public PauseSubscriptionParams subscriptionFields(List<String> subscriptionFields) {
            this.subscriptionFields = subscriptionFields;
            return this;
        }

        public PauseSubscriptionParams subscriptionPlansFields(List<String> subscriptionPlansFields) {
            this.subscriptionPlansFields = subscriptionPlansFields;
            return this;
        }

        public PauseSubscriptionParams subscriptionItemsFields(List<String> subscriptionItemsFields) {
            this.subscriptionItemsFields = subscriptionItemsFields;
            return this;
        }

        public PauseSubscriptionParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public PauseSubscriptionParams invoiceOwnerAccountFields(List<String> invoiceOwnerAccountFields) {
            this.invoiceOwnerAccountFields = invoiceOwnerAccountFields;
            return this;
        }

        public PauseSubscriptionParams planFields(List<String> planFields) {
            this.planFields = planFields;
            return this;
        }

        public PauseSubscriptionParams productFields(List<String> productFields) {
            this.productFields = productFields;
            return this;
        }

        public PauseSubscriptionParams priceFields(List<String> priceFields) {
            this.priceFields = priceFields;
            return this;
        }

        public PauseSubscriptionParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public PauseSubscriptionParams prepaidBalanceFields(List<String> prepaidBalanceFields) {
            this.prepaidBalanceFields = prepaidBalanceFields;
            return this;
        }

        public PauseSubscriptionParams prepaidBalancesFields(List<String> prepaidBalancesFields) {
            this.prepaidBalancesFields = prepaidBalancesFields;
            return this;
        }

        public PauseSubscriptionParams validityPeriodFields(List<String> validityPeriodFields) {
            this.validityPeriodFields = validityPeriodFields;
            return this;
        }

        public PauseSubscriptionParams transactionsFields(List<String> transactionsFields) {
            this.transactionsFields = transactionsFields;
            return this;
        }

        public PauseSubscriptionParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public PauseSubscriptionParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public PauseSubscriptionParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class PatchSubscriptionParams {
        private final String subscriptionId;
        private final SubscriptionPatchRequest subscriptionPatchRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> subscriptionFields;
        private List<String> subscriptionPlansFields;
        private List<String> subscriptionItemsFields;
        private List<String> accountFields;
        private List<String> invoiceOwnerAccountFields;
        private List<String> planFields;
        private List<String> productFields;
        private List<String> priceFields;
        private List<String> billToFields;
        private List<String> prepaidBalanceFields;
        private List<String> prepaidBalancesFields;
        private List<String> validityPeriodFields;
        private List<String> transactionsFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public PatchSubscriptionParams(String subscriptionId, SubscriptionPatchRequest subscriptionPatchRequest) {
            this.subscriptionId = subscriptionId;
            this.subscriptionPatchRequest = subscriptionPatchRequest;
        }

        public PatchSubscriptionParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public PatchSubscriptionParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public PatchSubscriptionParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public PatchSubscriptionParams subscriptionFields(List<String> subscriptionFields) {
            this.subscriptionFields = subscriptionFields;
            return this;
        }

        public PatchSubscriptionParams subscriptionPlansFields(List<String> subscriptionPlansFields) {
            this.subscriptionPlansFields = subscriptionPlansFields;
            return this;
        }

        public PatchSubscriptionParams subscriptionItemsFields(List<String> subscriptionItemsFields) {
            this.subscriptionItemsFields = subscriptionItemsFields;
            return this;
        }

        public PatchSubscriptionParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public PatchSubscriptionParams invoiceOwnerAccountFields(List<String> invoiceOwnerAccountFields) {
            this.invoiceOwnerAccountFields = invoiceOwnerAccountFields;
            return this;
        }

        public PatchSubscriptionParams planFields(List<String> planFields) {
            this.planFields = planFields;
            return this;
        }

        public PatchSubscriptionParams productFields(List<String> productFields) {
            this.productFields = productFields;
            return this;
        }

        public PatchSubscriptionParams priceFields(List<String> priceFields) {
            this.priceFields = priceFields;
            return this;
        }

        public PatchSubscriptionParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public PatchSubscriptionParams prepaidBalanceFields(List<String> prepaidBalanceFields) {
            this.prepaidBalanceFields = prepaidBalanceFields;
            return this;
        }

        public PatchSubscriptionParams prepaidBalancesFields(List<String> prepaidBalancesFields) {
            this.prepaidBalancesFields = prepaidBalancesFields;
            return this;
        }

        public PatchSubscriptionParams validityPeriodFields(List<String> validityPeriodFields) {
            this.validityPeriodFields = validityPeriodFields;
            return this;
        }

        public PatchSubscriptionParams transactionsFields(List<String> transactionsFields) {
            this.transactionsFields = transactionsFields;
            return this;
        }

        public PatchSubscriptionParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public PatchSubscriptionParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public PatchSubscriptionParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class GetSubscriptionsParams {
        private Headers headers;
        private ListQueryParams listQueryParams;
        private String cursor;
        private List<String> expand;
        private List<String> filter;
        private List<String> sort;
        private Integer pageSize;
        private List<String> fields;
        private List<String> subscriptionFields;
        private List<String> subscriptionPlansFields;
        private List<String> subscriptionItemsFields;
        private List<String> accountFields;
        private List<String> invoiceOwnerAccountFields;
        private List<String> planFields;
        private List<String> productFields;
        private List<String> priceFields;
        private List<String> billToFields;
        private List<String> prepaidBalanceFields;
        private List<String> prepaidBalancesFields;
        private List<String> validityPeriodFields;
        private List<String> transactionsFields;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetSubscriptionsParams listQueryParams(ListQueryParams listQueryParams) {
            this.listQueryParams = listQueryParams;
            if (this.cursor != null) {
                this.cursor = listQueryParams.getCursor();
            }
            if (this.expand != null) {
                this.expand = listQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = listQueryParams.getFilter();
            }
            if (this.sort != null) {
                this.sort = listQueryParams.getSort();
            }
            if (this.pageSize != null) {
                this.pageSize = listQueryParams.getPageSize();
            }
            return this;
        }

        public GetSubscriptionsParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetSubscriptionsParams cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public GetSubscriptionsParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetSubscriptionsParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetSubscriptionsParams sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public GetSubscriptionsParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetSubscriptionsParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetSubscriptionsParams subscriptionFields(List<String> subscriptionFields) {
            this.subscriptionFields = subscriptionFields;
            return this;
        }

        public GetSubscriptionsParams subscriptionPlansFields(List<String> subscriptionPlansFields) {
            this.subscriptionPlansFields = subscriptionPlansFields;
            return this;
        }

        public GetSubscriptionsParams subscriptionItemsFields(List<String> subscriptionItemsFields) {
            this.subscriptionItemsFields = subscriptionItemsFields;
            return this;
        }

        public GetSubscriptionsParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public GetSubscriptionsParams invoiceOwnerAccountFields(List<String> invoiceOwnerAccountFields) {
            this.invoiceOwnerAccountFields = invoiceOwnerAccountFields;
            return this;
        }

        public GetSubscriptionsParams planFields(List<String> planFields) {
            this.planFields = planFields;
            return this;
        }

        public GetSubscriptionsParams productFields(List<String> productFields) {
            this.productFields = productFields;
            return this;
        }

        public GetSubscriptionsParams priceFields(List<String> priceFields) {
            this.priceFields = priceFields;
            return this;
        }

        public GetSubscriptionsParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public GetSubscriptionsParams prepaidBalanceFields(List<String> prepaidBalanceFields) {
            this.prepaidBalanceFields = prepaidBalanceFields;
            return this;
        }

        public GetSubscriptionsParams prepaidBalancesFields(List<String> prepaidBalancesFields) {
            this.prepaidBalancesFields = prepaidBalancesFields;
            return this;
        }

        public GetSubscriptionsParams validityPeriodFields(List<String> validityPeriodFields) {
            this.validityPeriodFields = validityPeriodFields;
            return this;
        }

        public GetSubscriptionsParams transactionsFields(List<String> transactionsFields) {
            this.transactionsFields = transactionsFields;
            return this;
        }
    }

    public static class GetSubscriptionByVersionParams {
        private final String subscriptionId;
        private Headers headers;
        private ListQueryParams listQueryParams;
        private List<String> fields;
        private List<String> subscriptionVersionFields;
        private List<String> subscriptionPlansFields;
        private List<String> subscriptionItemsFields;
        private List<String> accountFields;
        private List<String> invoiceOwnerAccountFields;
        private List<String> planFields;
        private List<String> productFields;
        private List<String> priceFields;
        private List<String> billToFields;
        private List<String> prepaidBalanceFields;
        private List<String> prepaidBalancesFields;
        private List<String> validityPeriodFields;
        private List<String> transactionsFields;
        private List<String> actionsFields;
        private String cursor;
        private List<String> expand;
        private List<String> filter;
        private List<String> sort;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetSubscriptionByVersionParams(String subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        public GetSubscriptionByVersionParams listQueryParams(ListQueryParams listQueryParams) {
            this.listQueryParams = listQueryParams;
            if (this.cursor != null) {
                this.cursor = listQueryParams.getCursor();
            }
            if (this.expand != null) {
                this.expand = listQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = listQueryParams.getFilter();
            }
            if (this.sort != null) {
                this.sort = listQueryParams.getSort();
            }
            if (this.pageSize != null) {
                this.pageSize = listQueryParams.getPageSize();
            }
            return this;
        }

        public GetSubscriptionByVersionParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetSubscriptionByVersionParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetSubscriptionByVersionParams subscriptionVersionFields(List<String> subscriptionVersionFields) {
            this.subscriptionVersionFields = subscriptionVersionFields;
            return this;
        }

        public GetSubscriptionByVersionParams subscriptionPlansFields(List<String> subscriptionPlansFields) {
            this.subscriptionPlansFields = subscriptionPlansFields;
            return this;
        }

        public GetSubscriptionByVersionParams subscriptionItemsFields(List<String> subscriptionItemsFields) {
            this.subscriptionItemsFields = subscriptionItemsFields;
            return this;
        }

        public GetSubscriptionByVersionParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public GetSubscriptionByVersionParams invoiceOwnerAccountFields(List<String> invoiceOwnerAccountFields) {
            this.invoiceOwnerAccountFields = invoiceOwnerAccountFields;
            return this;
        }

        public GetSubscriptionByVersionParams planFields(List<String> planFields) {
            this.planFields = planFields;
            return this;
        }

        public GetSubscriptionByVersionParams productFields(List<String> productFields) {
            this.productFields = productFields;
            return this;
        }

        public GetSubscriptionByVersionParams priceFields(List<String> priceFields) {
            this.priceFields = priceFields;
            return this;
        }

        public GetSubscriptionByVersionParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public GetSubscriptionByVersionParams prepaidBalanceFields(List<String> prepaidBalanceFields) {
            this.prepaidBalanceFields = prepaidBalanceFields;
            return this;
        }

        public GetSubscriptionByVersionParams prepaidBalancesFields(List<String> prepaidBalancesFields) {
            this.prepaidBalancesFields = prepaidBalancesFields;
            return this;
        }

        public GetSubscriptionByVersionParams validityPeriodFields(List<String> validityPeriodFields) {
            this.validityPeriodFields = validityPeriodFields;
            return this;
        }

        public GetSubscriptionByVersionParams transactionsFields(List<String> transactionsFields) {
            this.transactionsFields = transactionsFields;
            return this;
        }

        public GetSubscriptionByVersionParams actionsFields(List<String> actionsFields) {
            this.actionsFields = actionsFields;
            return this;
        }

        public GetSubscriptionByVersionParams cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public GetSubscriptionByVersionParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetSubscriptionByVersionParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetSubscriptionByVersionParams sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public GetSubscriptionByVersionParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class GetSubscriptionByKeyParams {
        private final String subscriptionId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> subscriptionFields;
        private List<String> subscriptionPlansFields;
        private List<String> subscriptionItemsFields;
        private List<String> accountFields;
        private List<String> invoiceOwnerAccountFields;
        private List<String> planFields;
        private List<String> productFields;
        private List<String> priceFields;
        private List<String> billToFields;
        private List<String> prepaidBalanceFields;
        private List<String> prepaidBalancesFields;
        private List<String> validityPeriodFields;
        private List<String> transactionsFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetSubscriptionByKeyParams(String subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        public GetSubscriptionByKeyParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public GetSubscriptionByKeyParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetSubscriptionByKeyParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetSubscriptionByKeyParams subscriptionFields(List<String> subscriptionFields) {
            this.subscriptionFields = subscriptionFields;
            return this;
        }

        public GetSubscriptionByKeyParams subscriptionPlansFields(List<String> subscriptionPlansFields) {
            this.subscriptionPlansFields = subscriptionPlansFields;
            return this;
        }

        public GetSubscriptionByKeyParams subscriptionItemsFields(List<String> subscriptionItemsFields) {
            this.subscriptionItemsFields = subscriptionItemsFields;
            return this;
        }

        public GetSubscriptionByKeyParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public GetSubscriptionByKeyParams invoiceOwnerAccountFields(List<String> invoiceOwnerAccountFields) {
            this.invoiceOwnerAccountFields = invoiceOwnerAccountFields;
            return this;
        }

        public GetSubscriptionByKeyParams planFields(List<String> planFields) {
            this.planFields = planFields;
            return this;
        }

        public GetSubscriptionByKeyParams productFields(List<String> productFields) {
            this.productFields = productFields;
            return this;
        }

        public GetSubscriptionByKeyParams priceFields(List<String> priceFields) {
            this.priceFields = priceFields;
            return this;
        }

        public GetSubscriptionByKeyParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public GetSubscriptionByKeyParams prepaidBalanceFields(List<String> prepaidBalanceFields) {
            this.prepaidBalanceFields = prepaidBalanceFields;
            return this;
        }

        public GetSubscriptionByKeyParams prepaidBalancesFields(List<String> prepaidBalancesFields) {
            this.prepaidBalancesFields = prepaidBalancesFields;
            return this;
        }

        public GetSubscriptionByKeyParams validityPeriodFields(List<String> validityPeriodFields) {
            this.validityPeriodFields = validityPeriodFields;
            return this;
        }

        public GetSubscriptionByKeyParams transactionsFields(List<String> transactionsFields) {
            this.transactionsFields = transactionsFields;
            return this;
        }

        public GetSubscriptionByKeyParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetSubscriptionByKeyParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetSubscriptionByKeyParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class CreateSubscriptionParams {
        private final SubscriptionCreateRequest subscriptionCreateRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> subscriptionFields;
        private List<String> subscriptionPlansFields;
        private List<String> subscriptionItemsFields;
        private List<String> accountFields;
        private List<String> invoiceOwnerAccountFields;
        private List<String> planFields;
        private List<String> productFields;
        private List<String> priceFields;
        private List<String> billToFields;
        private List<String> prepaidBalanceFields;
        private List<String> prepaidBalancesFields;
        private List<String> validityPeriodFields;
        private List<String> transactionsFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public CreateSubscriptionParams(SubscriptionCreateRequest subscriptionCreateRequest) {
            this.subscriptionCreateRequest = subscriptionCreateRequest;
        }

        public CreateSubscriptionParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CreateSubscriptionParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CreateSubscriptionParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CreateSubscriptionParams subscriptionFields(List<String> subscriptionFields) {
            this.subscriptionFields = subscriptionFields;
            return this;
        }

        public CreateSubscriptionParams subscriptionPlansFields(List<String> subscriptionPlansFields) {
            this.subscriptionPlansFields = subscriptionPlansFields;
            return this;
        }

        public CreateSubscriptionParams subscriptionItemsFields(List<String> subscriptionItemsFields) {
            this.subscriptionItemsFields = subscriptionItemsFields;
            return this;
        }

        public CreateSubscriptionParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public CreateSubscriptionParams invoiceOwnerAccountFields(List<String> invoiceOwnerAccountFields) {
            this.invoiceOwnerAccountFields = invoiceOwnerAccountFields;
            return this;
        }

        public CreateSubscriptionParams planFields(List<String> planFields) {
            this.planFields = planFields;
            return this;
        }

        public CreateSubscriptionParams productFields(List<String> productFields) {
            this.productFields = productFields;
            return this;
        }

        public CreateSubscriptionParams priceFields(List<String> priceFields) {
            this.priceFields = priceFields;
            return this;
        }

        public CreateSubscriptionParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public CreateSubscriptionParams prepaidBalanceFields(List<String> prepaidBalanceFields) {
            this.prepaidBalanceFields = prepaidBalanceFields;
            return this;
        }

        public CreateSubscriptionParams prepaidBalancesFields(List<String> prepaidBalancesFields) {
            this.prepaidBalancesFields = prepaidBalancesFields;
            return this;
        }

        public CreateSubscriptionParams validityPeriodFields(List<String> validityPeriodFields) {
            this.validityPeriodFields = validityPeriodFields;
            return this;
        }

        public CreateSubscriptionParams transactionsFields(List<String> transactionsFields) {
            this.transactionsFields = transactionsFields;
            return this;
        }

        public CreateSubscriptionParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CreateSubscriptionParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CreateSubscriptionParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class CancelSubscriptionParams {
        private final String subscriptionId;
        private final CancelSubscriptionRequest cancelSubscriptionRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> subscriptionFields;
        private List<String> subscriptionPlansFields;
        private List<String> subscriptionItemsFields;
        private List<String> accountFields;
        private List<String> invoiceOwnerAccountFields;
        private List<String> planFields;
        private List<String> productFields;
        private List<String> priceFields;
        private List<String> billToFields;
        private List<String> prepaidBalanceFields;
        private List<String> prepaidBalancesFields;
        private List<String> validityPeriodFields;
        private List<String> transactionsFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public CancelSubscriptionParams(String subscriptionId, CancelSubscriptionRequest cancelSubscriptionRequest) {
            this.subscriptionId = subscriptionId;
            this.cancelSubscriptionRequest = cancelSubscriptionRequest;
        }

        public CancelSubscriptionParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CancelSubscriptionParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CancelSubscriptionParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CancelSubscriptionParams subscriptionFields(List<String> subscriptionFields) {
            this.subscriptionFields = subscriptionFields;
            return this;
        }

        public CancelSubscriptionParams subscriptionPlansFields(List<String> subscriptionPlansFields) {
            this.subscriptionPlansFields = subscriptionPlansFields;
            return this;
        }

        public CancelSubscriptionParams subscriptionItemsFields(List<String> subscriptionItemsFields) {
            this.subscriptionItemsFields = subscriptionItemsFields;
            return this;
        }

        public CancelSubscriptionParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public CancelSubscriptionParams invoiceOwnerAccountFields(List<String> invoiceOwnerAccountFields) {
            this.invoiceOwnerAccountFields = invoiceOwnerAccountFields;
            return this;
        }

        public CancelSubscriptionParams planFields(List<String> planFields) {
            this.planFields = planFields;
            return this;
        }

        public CancelSubscriptionParams productFields(List<String> productFields) {
            this.productFields = productFields;
            return this;
        }

        public CancelSubscriptionParams priceFields(List<String> priceFields) {
            this.priceFields = priceFields;
            return this;
        }

        public CancelSubscriptionParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public CancelSubscriptionParams prepaidBalanceFields(List<String> prepaidBalanceFields) {
            this.prepaidBalanceFields = prepaidBalanceFields;
            return this;
        }

        public CancelSubscriptionParams prepaidBalancesFields(List<String> prepaidBalancesFields) {
            this.prepaidBalancesFields = prepaidBalancesFields;
            return this;
        }

        public CancelSubscriptionParams validityPeriodFields(List<String> validityPeriodFields) {
            this.validityPeriodFields = validityPeriodFields;
            return this;
        }

        public CancelSubscriptionParams transactionsFields(List<String> transactionsFields) {
            this.transactionsFields = transactionsFields;
            return this;
        }

        public CancelSubscriptionParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CancelSubscriptionParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CancelSubscriptionParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class ActivateSubscriptionParams {
        private final String subscriptionId;
        private final SubscriptionActivateRequest subscriptionActivateRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> subscriptionFields;
        private List<String> subscriptionPlansFields;
        private List<String> subscriptionItemsFields;
        private List<String> accountFields;
        private List<String> invoiceOwnerAccountFields;
        private List<String> planFields;
        private List<String> productFields;
        private List<String> priceFields;
        private List<String> billToFields;
        private List<String> prepaidBalanceFields;
        private List<String> prepaidBalancesFields;
        private List<String> validityPeriodFields;
        private List<String> transactionsFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public ActivateSubscriptionParams(String subscriptionId, SubscriptionActivateRequest subscriptionActivateRequest) {
            this.subscriptionId = subscriptionId;
            this.subscriptionActivateRequest = subscriptionActivateRequest;
        }

        public ActivateSubscriptionParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public ActivateSubscriptionParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public ActivateSubscriptionParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public ActivateSubscriptionParams subscriptionFields(List<String> subscriptionFields) {
            this.subscriptionFields = subscriptionFields;
            return this;
        }

        public ActivateSubscriptionParams subscriptionPlansFields(List<String> subscriptionPlansFields) {
            this.subscriptionPlansFields = subscriptionPlansFields;
            return this;
        }

        public ActivateSubscriptionParams subscriptionItemsFields(List<String> subscriptionItemsFields) {
            this.subscriptionItemsFields = subscriptionItemsFields;
            return this;
        }

        public ActivateSubscriptionParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public ActivateSubscriptionParams invoiceOwnerAccountFields(List<String> invoiceOwnerAccountFields) {
            this.invoiceOwnerAccountFields = invoiceOwnerAccountFields;
            return this;
        }

        public ActivateSubscriptionParams planFields(List<String> planFields) {
            this.planFields = planFields;
            return this;
        }

        public ActivateSubscriptionParams productFields(List<String> productFields) {
            this.productFields = productFields;
            return this;
        }

        public ActivateSubscriptionParams priceFields(List<String> priceFields) {
            this.priceFields = priceFields;
            return this;
        }

        public ActivateSubscriptionParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public ActivateSubscriptionParams prepaidBalanceFields(List<String> prepaidBalanceFields) {
            this.prepaidBalanceFields = prepaidBalanceFields;
            return this;
        }

        public ActivateSubscriptionParams prepaidBalancesFields(List<String> prepaidBalancesFields) {
            this.prepaidBalancesFields = prepaidBalancesFields;
            return this;
        }

        public ActivateSubscriptionParams validityPeriodFields(List<String> validityPeriodFields) {
            this.validityPeriodFields = validityPeriodFields;
            return this;
        }

        public ActivateSubscriptionParams transactionsFields(List<String> transactionsFields) {
            this.transactionsFields = transactionsFields;
            return this;
        }

        public ActivateSubscriptionParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public ActivateSubscriptionParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public ActivateSubscriptionParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }
}

