/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.GetByIdQueryParams;
import org.openapitools.client.model.Headers;
import org.openapitools.client.model.ListQueryParams;
import org.openapitools.client.model.Product;
import org.openapitools.client.model.ProductCreateRequest;
import org.openapitools.client.model.ProductListResponse;
import org.openapitools.client.model.ProductPatchRequest;

public class ProductsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ProductsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProductsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createProductCall(ProductCreateRequest productCreateRequest, List<String> fields, List<String> productFields, List<String> plansFields, List<String> pricesFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ProductCreateRequest localVarPostBody = productCreateRequest;
        String localVarPath = "/products";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (productFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "product.fields[]", productFields));
        }
        if (plansFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "plans.fields[]", plansFields));
        }
        if (pricesFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prices.fields[]", pricesFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createProductValidateBeforeCall(ProductCreateRequest productCreateRequest, List<String> fields, List<String> productFields, List<String> plansFields, List<String> pricesFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (productCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'productCreateRequest' when calling createProduct(Async)");
        }
        return this.createProductCall(productCreateRequest, fields, productFields, plansFields, pricesFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Product> createProductWithHttpInfo(ProductCreateRequest productCreateRequest, List<String> fields, List<String> productFields, List<String> plansFields, List<String> pricesFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createProductValidateBeforeCall(productCreateRequest, fields, productFields, plansFields, pricesFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Product>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createProductAsync(ProductCreateRequest productCreateRequest, List<String> fields, List<String> productFields, List<String> plansFields, List<String> pricesFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Product> _callback) throws ApiException {
        Call localVarCall = this.createProductValidateBeforeCall(productCreateRequest, fields, productFields, plansFields, pricesFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Product>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateProductParams createProductParams(ProductCreateRequest productCreateRequest) {
        return new CreateProductParams(productCreateRequest);
    }

    public Product createProduct(ProductCreateRequest productCreateRequest) throws ApiException {
        CreateProductParams params = new CreateProductParams(productCreateRequest);
        return this.executeCreateProductAPICall(params).getData();
    }

    public Product createProduct(ProductCreateRequest productCreateRequest, List<String> expand) throws ApiException {
        CreateProductParams params = new CreateProductParams(productCreateRequest);
        params.expand(expand);
        return this.executeCreateProductAPICall(params).getData();
    }

    public Product createProduct(ProductCreateRequest productCreateRequest, List<String> expand, Headers headers) throws ApiException {
        CreateProductParams params = new CreateProductParams(productCreateRequest).expand(expand).headers(headers);
        return this.executeCreateProductAPICall(params).getData();
    }

    public Product create(CreateProductParams params) throws ApiException {
        return this.executeCreateProductAPICall(params).getData();
    }

    public ApiResponse<Product> createWithHttpInfo(CreateProductParams params) throws ApiException {
        return this.executeCreateProductAPICall(params);
    }

    ApiResponse<Product> executeCreateProductAPICall(CreateProductParams params) throws ApiException {
        return this.createProductWithHttpInfo(params.productCreateRequest, params.fields, params.productFields, params.plansFields, params.pricesFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call deleteProductCall(String productId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/products/{product_id}".replace("{product_id}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteProductValidateBeforeCall(String productId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling deleteProduct(Async)");
        }
        return this.deleteProductCall(productId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Void> deleteProductWithHttpInfo(String productId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.deleteProductValidateBeforeCall(productId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteProductAsync(String productId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteProductValidateBeforeCall(productId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public DeleteProductParams deleteProductParams(String productId) {
        return new DeleteProductParams(productId);
    }

    public void deleteProduct(String productId) throws ApiException {
        DeleteProductParams params = new DeleteProductParams(productId);
        this.executeDeleteProductAPICall(params);
    }

    public void deleteProduct(String productId, Headers headers) throws ApiException {
        DeleteProductParams params = new DeleteProductParams(productId).headers(headers);
        this.executeDeleteProductAPICall(params);
    }

    public void delete(DeleteProductParams params) throws ApiException {
        this.executeDeleteProductAPICall(params).getData();
    }

    public ApiResponse<Void> deleteWithHttpInfo(DeleteProductParams params) throws ApiException {
        return this.executeDeleteProductAPICall(params);
    }

    ApiResponse<Void> executeDeleteProductAPICall(DeleteProductParams params) throws ApiException {
        return this.deleteProductWithHttpInfo(params.productId, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getProductCall(String productId, List<String> fields, List<String> productFields, List<String> plansFields, List<String> pricesFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/products/{product_id}".replace("{product_id}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (productFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "product.fields[]", productFields));
        }
        if (plansFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "plans.fields[]", plansFields));
        }
        if (pricesFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prices.fields[]", pricesFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProductValidateBeforeCall(String productId, List<String> fields, List<String> productFields, List<String> plansFields, List<String> pricesFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling getProduct(Async)");
        }
        return this.getProductCall(productId, fields, productFields, plansFields, pricesFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Product> getProductWithHttpInfo(String productId, List<String> fields, List<String> productFields, List<String> plansFields, List<String> pricesFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getProductValidateBeforeCall(productId, fields, productFields, plansFields, pricesFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Product>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getProductAsync(String productId, List<String> fields, List<String> productFields, List<String> plansFields, List<String> pricesFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Product> _callback) throws ApiException {
        Call localVarCall = this.getProductValidateBeforeCall(productId, fields, productFields, plansFields, pricesFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Product>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetProductParams getProductParams(String productId) {
        return new GetProductParams(productId);
    }

    public Product getProduct(String productId) throws ApiException {
        GetProductParams params = new GetProductParams(productId);
        return this.executeGetProductAPICall(params).getData();
    }

    public Product getProduct(String productId, List<String> expand) throws ApiException {
        GetProductParams params = new GetProductParams(productId);
        params.expand(expand);
        return this.executeGetProductAPICall(params).getData();
    }

    public Product getProduct(String productId, List<String> expand, Headers headers) throws ApiException {
        GetProductParams params = new GetProductParams(productId).expand(expand).headers(headers);
        return this.executeGetProductAPICall(params).getData();
    }

    public Product get(GetProductParams params) throws ApiException {
        return this.executeGetProductAPICall(params).getData();
    }

    public ApiResponse<Product> getWithHttpInfo(GetProductParams params) throws ApiException {
        return this.executeGetProductAPICall(params);
    }

    ApiResponse<Product> executeGetProductAPICall(GetProductParams params) throws ApiException {
        return this.getProductWithHttpInfo(params.productId, params.fields, params.productFields, params.plansFields, params.pricesFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getProductsCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> productFields, List<String> plansFields, List<String> pricesFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/products";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (sort != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sort[]", sort));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (productFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "product.fields[]", productFields));
        }
        if (plansFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "plans.fields[]", plansFields));
        }
        if (pricesFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prices.fields[]", pricesFields));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProductsValidateBeforeCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> productFields, List<String> plansFields, List<String> pricesFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getProductsCall(cursor, expand, filter, sort, pageSize, fields, productFields, plansFields, pricesFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<ProductListResponse> getProductsWithHttpInfo(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> productFields, List<String> plansFields, List<String> pricesFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getProductsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, productFields, plansFields, pricesFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<ProductListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getProductsAsync(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> productFields, List<String> plansFields, List<String> pricesFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<ProductListResponse> _callback) throws ApiException {
        Call localVarCall = this.getProductsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, productFields, plansFields, pricesFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<ProductListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetProductsParams getProductsParams() {
        return new GetProductsParams();
    }

    public ProductListResponse getProducts() throws ApiException {
        GetProductsParams params = new GetProductsParams();
        return this.executeGetProductsAPICall(params).getData();
    }

    public ProductListResponse getProducts(String cursor, List<String> expand, List<String> filter) throws ApiException {
        GetProductsParams params = new GetProductsParams();
        params.cursor(cursor);
        params.expand(expand);
        params.filter(filter);
        return this.executeGetProductsAPICall(params).getData();
    }

    public ProductListResponse getProducts(String cursor, List<String> expand, List<String> filter, Headers headers) throws ApiException {
        GetProductsParams params = new GetProductsParams().cursor(cursor).expand(expand).filter(filter).headers(headers);
        return this.executeGetProductsAPICall(params).getData();
    }

    public ProductListResponse list(GetProductsParams params) throws ApiException {
        return this.executeGetProductsAPICall(params).getData();
    }

    public ApiResponse<ProductListResponse> listWithHttpInfo(GetProductsParams params) throws ApiException {
        return this.executeGetProductsAPICall(params);
    }

    ApiResponse<ProductListResponse> executeGetProductsAPICall(GetProductsParams params) throws ApiException {
        return this.getProductsWithHttpInfo(params.cursor, params.expand, params.filter, params.sort, params.pageSize, params.fields, params.productFields, params.plansFields, params.pricesFields, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call updateProductCall(String productId, ProductPatchRequest productPatchRequest, List<String> fields, List<String> productFields, List<String> plansFields, List<String> pricesFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ProductPatchRequest localVarPostBody = productPatchRequest;
        String localVarPath = "/products/{product_id}".replace("{product_id}", this.localVarApiClient.escapeString(productId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (productFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "product.fields[]", productFields));
        }
        if (plansFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "plans.fields[]", plansFields));
        }
        if (pricesFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prices.fields[]", pricesFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateProductValidateBeforeCall(String productId, ProductPatchRequest productPatchRequest, List<String> fields, List<String> productFields, List<String> plansFields, List<String> pricesFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (productId == null) {
            throw new ApiException("Missing the required parameter 'productId' when calling updateProduct(Async)");
        }
        if (productPatchRequest == null) {
            throw new ApiException("Missing the required parameter 'productPatchRequest' when calling updateProduct(Async)");
        }
        return this.updateProductCall(productId, productPatchRequest, fields, productFields, plansFields, pricesFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Product> updateProductWithHttpInfo(String productId, ProductPatchRequest productPatchRequest, List<String> fields, List<String> productFields, List<String> plansFields, List<String> pricesFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updateProductValidateBeforeCall(productId, productPatchRequest, fields, productFields, plansFields, pricesFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Product>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call updateProductAsync(String productId, ProductPatchRequest productPatchRequest, List<String> fields, List<String> productFields, List<String> plansFields, List<String> pricesFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Product> _callback) throws ApiException {
        Call localVarCall = this.updateProductValidateBeforeCall(productId, productPatchRequest, fields, productFields, plansFields, pricesFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Product>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdateProductParams updateProductParams(String productId, ProductPatchRequest productPatchRequest) {
        return new UpdateProductParams(productId, productPatchRequest);
    }

    public Product updateProduct(String productId, ProductPatchRequest productPatchRequest) throws ApiException {
        UpdateProductParams params = new UpdateProductParams(productId, productPatchRequest);
        return this.executeUpdateProductAPICall(params).getData();
    }

    public Product updateProduct(String productId, ProductPatchRequest productPatchRequest, List<String> expand) throws ApiException {
        UpdateProductParams params = new UpdateProductParams(productId, productPatchRequest);
        params.expand(expand);
        return this.executeUpdateProductAPICall(params).getData();
    }

    public Product updateProduct(String productId, ProductPatchRequest productPatchRequest, List<String> expand, Headers headers) throws ApiException {
        UpdateProductParams params = new UpdateProductParams(productId, productPatchRequest).expand(expand).headers(headers);
        return this.executeUpdateProductAPICall(params).getData();
    }

    public Product update(UpdateProductParams params) throws ApiException {
        return this.executeUpdateProductAPICall(params).getData();
    }

    public ApiResponse<Product> updateWithHttpInfo(UpdateProductParams params) throws ApiException {
        return this.executeUpdateProductAPICall(params);
    }

    ApiResponse<Product> executeUpdateProductAPICall(UpdateProductParams params) throws ApiException {
        return this.updateProductWithHttpInfo(params.productId, params.productPatchRequest, params.fields, params.productFields, params.plansFields, params.pricesFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    public static class UpdateProductParams {
        private final String productId;
        private final ProductPatchRequest productPatchRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> productFields;
        private List<String> plansFields;
        private List<String> pricesFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public UpdateProductParams(String productId, ProductPatchRequest productPatchRequest) {
            this.productId = productId;
            this.productPatchRequest = productPatchRequest;
        }

        public UpdateProductParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public UpdateProductParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public UpdateProductParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public UpdateProductParams productFields(List<String> productFields) {
            this.productFields = productFields;
            return this;
        }

        public UpdateProductParams plansFields(List<String> plansFields) {
            this.plansFields = plansFields;
            return this;
        }

        public UpdateProductParams pricesFields(List<String> pricesFields) {
            this.pricesFields = pricesFields;
            return this;
        }

        public UpdateProductParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public UpdateProductParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public UpdateProductParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class GetProductsParams {
        private Headers headers;
        private ListQueryParams listQueryParams;
        private String cursor;
        private List<String> expand;
        private List<String> filter;
        private List<String> sort;
        private Integer pageSize;
        private List<String> fields;
        private List<String> productFields;
        private List<String> plansFields;
        private List<String> pricesFields;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetProductsParams listQueryParams(ListQueryParams listQueryParams) {
            this.listQueryParams = listQueryParams;
            if (this.cursor != null) {
                this.cursor = listQueryParams.getCursor();
            }
            if (this.expand != null) {
                this.expand = listQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = listQueryParams.getFilter();
            }
            if (this.sort != null) {
                this.sort = listQueryParams.getSort();
            }
            if (this.pageSize != null) {
                this.pageSize = listQueryParams.getPageSize();
            }
            return this;
        }

        public GetProductsParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetProductsParams cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public GetProductsParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetProductsParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetProductsParams sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public GetProductsParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetProductsParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetProductsParams productFields(List<String> productFields) {
            this.productFields = productFields;
            return this;
        }

        public GetProductsParams plansFields(List<String> plansFields) {
            this.plansFields = plansFields;
            return this;
        }

        public GetProductsParams pricesFields(List<String> pricesFields) {
            this.pricesFields = pricesFields;
            return this;
        }
    }

    public static class GetProductParams {
        private final String productId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> productFields;
        private List<String> plansFields;
        private List<String> pricesFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetProductParams(String productId) {
            this.productId = productId;
        }

        public GetProductParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public GetProductParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetProductParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetProductParams productFields(List<String> productFields) {
            this.productFields = productFields;
            return this;
        }

        public GetProductParams plansFields(List<String> plansFields) {
            this.plansFields = plansFields;
            return this;
        }

        public GetProductParams pricesFields(List<String> pricesFields) {
            this.pricesFields = pricesFields;
            return this;
        }

        public GetProductParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetProductParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetProductParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class DeleteProductParams {
        private final String productId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public DeleteProductParams(String productId) {
            this.productId = productId;
        }

        public DeleteProductParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }
    }

    public static class CreateProductParams {
        private final ProductCreateRequest productCreateRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> productFields;
        private List<String> plansFields;
        private List<String> pricesFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public CreateProductParams(ProductCreateRequest productCreateRequest) {
            this.productCreateRequest = productCreateRequest;
        }

        public CreateProductParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CreateProductParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CreateProductParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CreateProductParams productFields(List<String> productFields) {
            this.productFields = productFields;
            return this;
        }

        public CreateProductParams plansFields(List<String> plansFields) {
            this.plansFields = plansFields;
            return this;
        }

        public CreateProductParams pricesFields(List<String> pricesFields) {
            this.pricesFields = pricesFields;
            return this;
        }

        public CreateProductParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CreateProductParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CreateProductParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }
}

