/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.GetByIdQueryParams;
import org.openapitools.client.model.Headers;
import org.openapitools.client.model.ListQueryParams;
import org.openapitools.client.model.PaymentMethod;
import org.openapitools.client.model.PaymentMethodAuthorizationRequest;
import org.openapitools.client.model.PaymentMethodAuthorizationResponse;
import org.openapitools.client.model.PaymentMethodCreateRequest;
import org.openapitools.client.model.PaymentMethodListResponse;
import org.openapitools.client.model.PaymentMethodPatchRequest;
import org.openapitools.client.model.PaymentMethodVerificationRequest;
import org.openapitools.client.model.PaymentMethodVoidAuthorizationRequest;

public class PaymentMethodsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PaymentMethodsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PaymentMethodsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call authorizePaymentMethodCall(String paymentMethodId, PaymentMethodAuthorizationRequest paymentMethodAuthorizationRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PaymentMethodAuthorizationRequest localVarPostBody = paymentMethodAuthorizationRequest;
        String localVarPath = "/payment_methods/{payment_method_id}/authorize".replace("{payment_method_id}", this.localVarApiClient.escapeString(paymentMethodId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call authorizePaymentMethodValidateBeforeCall(String paymentMethodId, PaymentMethodAuthorizationRequest paymentMethodAuthorizationRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentMethodId == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodId' when calling authorizePaymentMethod(Async)");
        }
        if (paymentMethodAuthorizationRequest == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodAuthorizationRequest' when calling authorizePaymentMethod(Async)");
        }
        return this.authorizePaymentMethodCall(paymentMethodId, paymentMethodAuthorizationRequest, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<PaymentMethodAuthorizationResponse> authorizePaymentMethodWithHttpInfo(String paymentMethodId, PaymentMethodAuthorizationRequest paymentMethodAuthorizationRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.authorizePaymentMethodValidateBeforeCall(paymentMethodId, paymentMethodAuthorizationRequest, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentMethodAuthorizationResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call authorizePaymentMethodAsync(String paymentMethodId, PaymentMethodAuthorizationRequest paymentMethodAuthorizationRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<PaymentMethodAuthorizationResponse> _callback) throws ApiException {
        Call localVarCall = this.authorizePaymentMethodValidateBeforeCall(paymentMethodId, paymentMethodAuthorizationRequest, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentMethodAuthorizationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public AuthorizePaymentMethodParams authorizePaymentMethodParams(String paymentMethodId, PaymentMethodAuthorizationRequest paymentMethodAuthorizationRequest) {
        return new AuthorizePaymentMethodParams(paymentMethodId, paymentMethodAuthorizationRequest);
    }

    public PaymentMethodAuthorizationResponse authorizePaymentMethod(String paymentMethodId, PaymentMethodAuthorizationRequest paymentMethodAuthorizationRequest) throws ApiException {
        AuthorizePaymentMethodParams params = new AuthorizePaymentMethodParams(paymentMethodId, paymentMethodAuthorizationRequest);
        return this.executeAuthorizePaymentMethodAPICall(params).getData();
    }

    public PaymentMethodAuthorizationResponse authorizePaymentMethod(String paymentMethodId, PaymentMethodAuthorizationRequest paymentMethodAuthorizationRequest, Headers headers) throws ApiException {
        AuthorizePaymentMethodParams params = new AuthorizePaymentMethodParams(paymentMethodId, paymentMethodAuthorizationRequest).headers(headers);
        return this.executeAuthorizePaymentMethodAPICall(params).getData();
    }

    public PaymentMethodAuthorizationResponse authorize(AuthorizePaymentMethodParams params) throws ApiException {
        return this.executeAuthorizePaymentMethodAPICall(params).getData();
    }

    public ApiResponse<PaymentMethodAuthorizationResponse> authorizeWithHttpInfo(AuthorizePaymentMethodParams params) throws ApiException {
        return this.executeAuthorizePaymentMethodAPICall(params);
    }

    ApiResponse<PaymentMethodAuthorizationResponse> executeAuthorizePaymentMethodAPICall(AuthorizePaymentMethodParams params) throws ApiException {
        return this.authorizePaymentMethodWithHttpInfo(params.paymentMethodId, params.paymentMethodAuthorizationRequest, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call createPaymentMethodCall(PaymentMethodCreateRequest paymentMethodCreateRequest, List<String> fields, List<String> paymentMethodFields, List<String> accountFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PaymentMethodCreateRequest localVarPostBody = paymentMethodCreateRequest;
        String localVarPath = "/payment_methods";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentMethodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_method.fields[]", paymentMethodFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createPaymentMethodValidateBeforeCall(PaymentMethodCreateRequest paymentMethodCreateRequest, List<String> fields, List<String> paymentMethodFields, List<String> accountFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentMethodCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodCreateRequest' when calling createPaymentMethod(Async)");
        }
        return this.createPaymentMethodCall(paymentMethodCreateRequest, fields, paymentMethodFields, accountFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<PaymentMethod> createPaymentMethodWithHttpInfo(PaymentMethodCreateRequest paymentMethodCreateRequest, List<String> fields, List<String> paymentMethodFields, List<String> accountFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createPaymentMethodValidateBeforeCall(paymentMethodCreateRequest, fields, paymentMethodFields, accountFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentMethod>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createPaymentMethodAsync(PaymentMethodCreateRequest paymentMethodCreateRequest, List<String> fields, List<String> paymentMethodFields, List<String> accountFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<PaymentMethod> _callback) throws ApiException {
        Call localVarCall = this.createPaymentMethodValidateBeforeCall(paymentMethodCreateRequest, fields, paymentMethodFields, accountFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentMethod>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreatePaymentMethodParams createPaymentMethodParams(PaymentMethodCreateRequest paymentMethodCreateRequest) {
        return new CreatePaymentMethodParams(paymentMethodCreateRequest);
    }

    public PaymentMethod createPaymentMethod(PaymentMethodCreateRequest paymentMethodCreateRequest) throws ApiException {
        CreatePaymentMethodParams params = new CreatePaymentMethodParams(paymentMethodCreateRequest);
        return this.executeCreatePaymentMethodAPICall(params).getData();
    }

    public PaymentMethod createPaymentMethod(PaymentMethodCreateRequest paymentMethodCreateRequest, List<String> expand) throws ApiException {
        CreatePaymentMethodParams params = new CreatePaymentMethodParams(paymentMethodCreateRequest);
        params.expand(expand);
        return this.executeCreatePaymentMethodAPICall(params).getData();
    }

    public PaymentMethod createPaymentMethod(PaymentMethodCreateRequest paymentMethodCreateRequest, List<String> expand, Headers headers) throws ApiException {
        CreatePaymentMethodParams params = new CreatePaymentMethodParams(paymentMethodCreateRequest).expand(expand).headers(headers);
        return this.executeCreatePaymentMethodAPICall(params).getData();
    }

    public PaymentMethod create(CreatePaymentMethodParams params) throws ApiException {
        return this.executeCreatePaymentMethodAPICall(params).getData();
    }

    public ApiResponse<PaymentMethod> createWithHttpInfo(CreatePaymentMethodParams params) throws ApiException {
        return this.executeCreatePaymentMethodAPICall(params);
    }

    ApiResponse<PaymentMethod> executeCreatePaymentMethodAPICall(CreatePaymentMethodParams params) throws ApiException {
        return this.createPaymentMethodWithHttpInfo(params.paymentMethodCreateRequest, params.fields, params.paymentMethodFields, params.accountFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call deletePaymentMethodCall(String paymentMethodId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/payment_methods/{payment_method_id}".replace("{payment_method_id}", this.localVarApiClient.escapeString(paymentMethodId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deletePaymentMethodValidateBeforeCall(String paymentMethodId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentMethodId == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodId' when calling deletePaymentMethod(Async)");
        }
        return this.deletePaymentMethodCall(paymentMethodId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Void> deletePaymentMethodWithHttpInfo(String paymentMethodId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.deletePaymentMethodValidateBeforeCall(paymentMethodId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deletePaymentMethodAsync(String paymentMethodId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deletePaymentMethodValidateBeforeCall(paymentMethodId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public DeletePaymentMethodParams deletePaymentMethodParams(String paymentMethodId) {
        return new DeletePaymentMethodParams(paymentMethodId);
    }

    public void deletePaymentMethod(String paymentMethodId) throws ApiException {
        DeletePaymentMethodParams params = new DeletePaymentMethodParams(paymentMethodId);
        this.executeDeletePaymentMethodAPICall(params);
    }

    public void deletePaymentMethod(String paymentMethodId, Headers headers) throws ApiException {
        DeletePaymentMethodParams params = new DeletePaymentMethodParams(paymentMethodId).headers(headers);
        this.executeDeletePaymentMethodAPICall(params);
    }

    public void delete(DeletePaymentMethodParams params) throws ApiException {
        this.executeDeletePaymentMethodAPICall(params).getData();
    }

    public ApiResponse<Void> deleteWithHttpInfo(DeletePaymentMethodParams params) throws ApiException {
        return this.executeDeletePaymentMethodAPICall(params);
    }

    ApiResponse<Void> executeDeletePaymentMethodAPICall(DeletePaymentMethodParams params) throws ApiException {
        return this.deletePaymentMethodWithHttpInfo(params.paymentMethodId, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getPaymentMethodByIdCall(String paymentMethodId, List<String> fields, List<String> paymentMethodFields, List<String> accountFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/payment_methods/{payment_method_id}".replace("{payment_method_id}", this.localVarApiClient.escapeString(paymentMethodId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentMethodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_method.fields[]", paymentMethodFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentMethodByIdValidateBeforeCall(String paymentMethodId, List<String> fields, List<String> paymentMethodFields, List<String> accountFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentMethodId == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodId' when calling getPaymentMethodById(Async)");
        }
        return this.getPaymentMethodByIdCall(paymentMethodId, fields, paymentMethodFields, accountFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<PaymentMethod> getPaymentMethodByIdWithHttpInfo(String paymentMethodId, List<String> fields, List<String> paymentMethodFields, List<String> accountFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getPaymentMethodByIdValidateBeforeCall(paymentMethodId, fields, paymentMethodFields, accountFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentMethod>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getPaymentMethodByIdAsync(String paymentMethodId, List<String> fields, List<String> paymentMethodFields, List<String> accountFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<PaymentMethod> _callback) throws ApiException {
        Call localVarCall = this.getPaymentMethodByIdValidateBeforeCall(paymentMethodId, fields, paymentMethodFields, accountFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentMethod>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPaymentMethodByIdParams getPaymentMethodByIdParams(String paymentMethodId) {
        return new GetPaymentMethodByIdParams(paymentMethodId);
    }

    public PaymentMethod getPaymentMethodById(String paymentMethodId) throws ApiException {
        GetPaymentMethodByIdParams params = new GetPaymentMethodByIdParams(paymentMethodId);
        return this.executeGetPaymentMethodByIdAPICall(params).getData();
    }

    public PaymentMethod getPaymentMethodById(String paymentMethodId, List<String> expand) throws ApiException {
        GetPaymentMethodByIdParams params = new GetPaymentMethodByIdParams(paymentMethodId);
        params.expand(expand);
        return this.executeGetPaymentMethodByIdAPICall(params).getData();
    }

    public PaymentMethod getPaymentMethodById(String paymentMethodId, List<String> expand, Headers headers) throws ApiException {
        GetPaymentMethodByIdParams params = new GetPaymentMethodByIdParams(paymentMethodId).expand(expand).headers(headers);
        return this.executeGetPaymentMethodByIdAPICall(params).getData();
    }

    public PaymentMethod get(GetPaymentMethodByIdParams params) throws ApiException {
        return this.executeGetPaymentMethodByIdAPICall(params).getData();
    }

    public ApiResponse<PaymentMethod> getWithHttpInfo(GetPaymentMethodByIdParams params) throws ApiException {
        return this.executeGetPaymentMethodByIdAPICall(params);
    }

    ApiResponse<PaymentMethod> executeGetPaymentMethodByIdAPICall(GetPaymentMethodByIdParams params) throws ApiException {
        return this.getPaymentMethodByIdWithHttpInfo(params.paymentMethodId, params.fields, params.paymentMethodFields, params.accountFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getPaymentMethodsCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> paymentMethodFields, List<String> accountFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/payment_methods";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (sort != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sort[]", sort));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentMethodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_method.fields[]", paymentMethodFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentMethodsValidateBeforeCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> paymentMethodFields, List<String> accountFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getPaymentMethodsCall(cursor, expand, filter, sort, pageSize, fields, paymentMethodFields, accountFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<PaymentMethodListResponse> getPaymentMethodsWithHttpInfo(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> paymentMethodFields, List<String> accountFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getPaymentMethodsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, paymentMethodFields, accountFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentMethodListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getPaymentMethodsAsync(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> paymentMethodFields, List<String> accountFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<PaymentMethodListResponse> _callback) throws ApiException {
        Call localVarCall = this.getPaymentMethodsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, paymentMethodFields, accountFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentMethodListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPaymentMethodsParams getPaymentMethodsParams() {
        return new GetPaymentMethodsParams();
    }

    public PaymentMethodListResponse getPaymentMethods() throws ApiException {
        GetPaymentMethodsParams params = new GetPaymentMethodsParams();
        return this.executeGetPaymentMethodsAPICall(params).getData();
    }

    public PaymentMethodListResponse getPaymentMethods(String cursor, List<String> expand, List<String> filter) throws ApiException {
        GetPaymentMethodsParams params = new GetPaymentMethodsParams();
        params.cursor(cursor);
        params.expand(expand);
        params.filter(filter);
        return this.executeGetPaymentMethodsAPICall(params).getData();
    }

    public PaymentMethodListResponse getPaymentMethods(String cursor, List<String> expand, List<String> filter, Headers headers) throws ApiException {
        GetPaymentMethodsParams params = new GetPaymentMethodsParams().cursor(cursor).expand(expand).filter(filter).headers(headers);
        return this.executeGetPaymentMethodsAPICall(params).getData();
    }

    public PaymentMethodListResponse list(GetPaymentMethodsParams params) throws ApiException {
        return this.executeGetPaymentMethodsAPICall(params).getData();
    }

    public ApiResponse<PaymentMethodListResponse> listWithHttpInfo(GetPaymentMethodsParams params) throws ApiException {
        return this.executeGetPaymentMethodsAPICall(params);
    }

    ApiResponse<PaymentMethodListResponse> executeGetPaymentMethodsAPICall(GetPaymentMethodsParams params) throws ApiException {
        return this.getPaymentMethodsWithHttpInfo(params.cursor, params.expand, params.filter, params.sort, params.pageSize, params.fields, params.paymentMethodFields, params.accountFields, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call scrubPaymentMethodCall(String paymentMethodId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/payment_methods/{payment_method_id}/scrub".replace("{payment_method_id}", this.localVarApiClient.escapeString(paymentMethodId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call scrubPaymentMethodValidateBeforeCall(String paymentMethodId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentMethodId == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodId' when calling scrubPaymentMethod(Async)");
        }
        return this.scrubPaymentMethodCall(paymentMethodId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Void> scrubPaymentMethodWithHttpInfo(String paymentMethodId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.scrubPaymentMethodValidateBeforeCall(paymentMethodId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call scrubPaymentMethodAsync(String paymentMethodId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.scrubPaymentMethodValidateBeforeCall(paymentMethodId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public ScrubPaymentMethodParams scrubPaymentMethodParams(String paymentMethodId) {
        return new ScrubPaymentMethodParams(paymentMethodId);
    }

    public void scrubPaymentMethod(String paymentMethodId) throws ApiException {
        ScrubPaymentMethodParams params = new ScrubPaymentMethodParams(paymentMethodId);
        this.executeScrubPaymentMethodAPICall(params);
    }

    public void scrubPaymentMethod(String paymentMethodId, Headers headers) throws ApiException {
        ScrubPaymentMethodParams params = new ScrubPaymentMethodParams(paymentMethodId).headers(headers);
        this.executeScrubPaymentMethodAPICall(params);
    }

    public void scrub(ScrubPaymentMethodParams params) throws ApiException {
        this.executeScrubPaymentMethodAPICall(params).getData();
    }

    public ApiResponse<Void> scrubWithHttpInfo(ScrubPaymentMethodParams params) throws ApiException {
        return this.executeScrubPaymentMethodAPICall(params);
    }

    ApiResponse<Void> executeScrubPaymentMethodAPICall(ScrubPaymentMethodParams params) throws ApiException {
        return this.scrubPaymentMethodWithHttpInfo(params.paymentMethodId, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call updatePaymentMethodCall(String paymentMethodId, PaymentMethodPatchRequest paymentMethodPatchRequest, List<String> fields, List<String> paymentMethodFields, List<String> accountFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PaymentMethodPatchRequest localVarPostBody = paymentMethodPatchRequest;
        String localVarPath = "/payment_methods/{payment_method_id}".replace("{payment_method_id}", this.localVarApiClient.escapeString(paymentMethodId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentMethodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_method.fields[]", paymentMethodFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updatePaymentMethodValidateBeforeCall(String paymentMethodId, PaymentMethodPatchRequest paymentMethodPatchRequest, List<String> fields, List<String> paymentMethodFields, List<String> accountFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentMethodId == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodId' when calling updatePaymentMethod(Async)");
        }
        if (paymentMethodPatchRequest == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodPatchRequest' when calling updatePaymentMethod(Async)");
        }
        return this.updatePaymentMethodCall(paymentMethodId, paymentMethodPatchRequest, fields, paymentMethodFields, accountFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<PaymentMethod> updatePaymentMethodWithHttpInfo(String paymentMethodId, PaymentMethodPatchRequest paymentMethodPatchRequest, List<String> fields, List<String> paymentMethodFields, List<String> accountFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updatePaymentMethodValidateBeforeCall(paymentMethodId, paymentMethodPatchRequest, fields, paymentMethodFields, accountFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentMethod>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call updatePaymentMethodAsync(String paymentMethodId, PaymentMethodPatchRequest paymentMethodPatchRequest, List<String> fields, List<String> paymentMethodFields, List<String> accountFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<PaymentMethod> _callback) throws ApiException {
        Call localVarCall = this.updatePaymentMethodValidateBeforeCall(paymentMethodId, paymentMethodPatchRequest, fields, paymentMethodFields, accountFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentMethod>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdatePaymentMethodParams updatePaymentMethodParams(String paymentMethodId, PaymentMethodPatchRequest paymentMethodPatchRequest) {
        return new UpdatePaymentMethodParams(paymentMethodId, paymentMethodPatchRequest);
    }

    public PaymentMethod updatePaymentMethod(String paymentMethodId, PaymentMethodPatchRequest paymentMethodPatchRequest) throws ApiException {
        UpdatePaymentMethodParams params = new UpdatePaymentMethodParams(paymentMethodId, paymentMethodPatchRequest);
        return this.executeUpdatePaymentMethodAPICall(params).getData();
    }

    public PaymentMethod updatePaymentMethod(String paymentMethodId, PaymentMethodPatchRequest paymentMethodPatchRequest, List<String> expand) throws ApiException {
        UpdatePaymentMethodParams params = new UpdatePaymentMethodParams(paymentMethodId, paymentMethodPatchRequest);
        params.expand(expand);
        return this.executeUpdatePaymentMethodAPICall(params).getData();
    }

    public PaymentMethod updatePaymentMethod(String paymentMethodId, PaymentMethodPatchRequest paymentMethodPatchRequest, List<String> expand, Headers headers) throws ApiException {
        UpdatePaymentMethodParams params = new UpdatePaymentMethodParams(paymentMethodId, paymentMethodPatchRequest).expand(expand).headers(headers);
        return this.executeUpdatePaymentMethodAPICall(params).getData();
    }

    public PaymentMethod update(UpdatePaymentMethodParams params) throws ApiException {
        return this.executeUpdatePaymentMethodAPICall(params).getData();
    }

    public ApiResponse<PaymentMethod> updateWithHttpInfo(UpdatePaymentMethodParams params) throws ApiException {
        return this.executeUpdatePaymentMethodAPICall(params);
    }

    ApiResponse<PaymentMethod> executeUpdatePaymentMethodAPICall(UpdatePaymentMethodParams params) throws ApiException {
        return this.updatePaymentMethodWithHttpInfo(params.paymentMethodId, params.paymentMethodPatchRequest, params.fields, params.paymentMethodFields, params.accountFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call verifyPaymentMethodCall(String paymentMethodId, PaymentMethodVerificationRequest paymentMethodVerificationRequest, List<String> fields, List<String> paymentMethodFields, List<String> accountFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PaymentMethodVerificationRequest localVarPostBody = paymentMethodVerificationRequest;
        String localVarPath = "/payment_methods/{payment_method_id}/verify".replace("{payment_method_id}", this.localVarApiClient.escapeString(paymentMethodId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentMethodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_method.fields[]", paymentMethodFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call verifyPaymentMethodValidateBeforeCall(String paymentMethodId, PaymentMethodVerificationRequest paymentMethodVerificationRequest, List<String> fields, List<String> paymentMethodFields, List<String> accountFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentMethodId == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodId' when calling verifyPaymentMethod(Async)");
        }
        if (paymentMethodVerificationRequest == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodVerificationRequest' when calling verifyPaymentMethod(Async)");
        }
        return this.verifyPaymentMethodCall(paymentMethodId, paymentMethodVerificationRequest, fields, paymentMethodFields, accountFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<PaymentMethod> verifyPaymentMethodWithHttpInfo(String paymentMethodId, PaymentMethodVerificationRequest paymentMethodVerificationRequest, List<String> fields, List<String> paymentMethodFields, List<String> accountFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.verifyPaymentMethodValidateBeforeCall(paymentMethodId, paymentMethodVerificationRequest, fields, paymentMethodFields, accountFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentMethod>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call verifyPaymentMethodAsync(String paymentMethodId, PaymentMethodVerificationRequest paymentMethodVerificationRequest, List<String> fields, List<String> paymentMethodFields, List<String> accountFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<PaymentMethod> _callback) throws ApiException {
        Call localVarCall = this.verifyPaymentMethodValidateBeforeCall(paymentMethodId, paymentMethodVerificationRequest, fields, paymentMethodFields, accountFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentMethod>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public VerifyPaymentMethodParams verifyPaymentMethodParams(String paymentMethodId, PaymentMethodVerificationRequest paymentMethodVerificationRequest) {
        return new VerifyPaymentMethodParams(paymentMethodId, paymentMethodVerificationRequest);
    }

    public PaymentMethod verifyPaymentMethod(String paymentMethodId, PaymentMethodVerificationRequest paymentMethodVerificationRequest) throws ApiException {
        VerifyPaymentMethodParams params = new VerifyPaymentMethodParams(paymentMethodId, paymentMethodVerificationRequest);
        return this.executeVerifyPaymentMethodAPICall(params).getData();
    }

    public PaymentMethod verifyPaymentMethod(String paymentMethodId, PaymentMethodVerificationRequest paymentMethodVerificationRequest, List<String> expand) throws ApiException {
        VerifyPaymentMethodParams params = new VerifyPaymentMethodParams(paymentMethodId, paymentMethodVerificationRequest);
        params.expand(expand);
        return this.executeVerifyPaymentMethodAPICall(params).getData();
    }

    public PaymentMethod verifyPaymentMethod(String paymentMethodId, PaymentMethodVerificationRequest paymentMethodVerificationRequest, List<String> expand, Headers headers) throws ApiException {
        VerifyPaymentMethodParams params = new VerifyPaymentMethodParams(paymentMethodId, paymentMethodVerificationRequest).expand(expand).headers(headers);
        return this.executeVerifyPaymentMethodAPICall(params).getData();
    }

    public PaymentMethod verify(VerifyPaymentMethodParams params) throws ApiException {
        return this.executeVerifyPaymentMethodAPICall(params).getData();
    }

    public ApiResponse<PaymentMethod> verifyWithHttpInfo(VerifyPaymentMethodParams params) throws ApiException {
        return this.executeVerifyPaymentMethodAPICall(params);
    }

    ApiResponse<PaymentMethod> executeVerifyPaymentMethodAPICall(VerifyPaymentMethodParams params) throws ApiException {
        return this.verifyPaymentMethodWithHttpInfo(params.paymentMethodId, params.paymentMethodVerificationRequest, params.fields, params.paymentMethodFields, params.accountFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call voidAuthorizationPaymentMethodCall(String paymentMethodId, PaymentMethodVoidAuthorizationRequest paymentMethodVoidAuthorizationRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PaymentMethodVoidAuthorizationRequest localVarPostBody = paymentMethodVoidAuthorizationRequest;
        String localVarPath = "/payment_methods/{payment_method_id}/void_authorization".replace("{payment_method_id}", this.localVarApiClient.escapeString(paymentMethodId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call voidAuthorizationPaymentMethodValidateBeforeCall(String paymentMethodId, PaymentMethodVoidAuthorizationRequest paymentMethodVoidAuthorizationRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentMethodId == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodId' when calling voidAuthorizationPaymentMethod(Async)");
        }
        if (paymentMethodVoidAuthorizationRequest == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodVoidAuthorizationRequest' when calling voidAuthorizationPaymentMethod(Async)");
        }
        return this.voidAuthorizationPaymentMethodCall(paymentMethodId, paymentMethodVoidAuthorizationRequest, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<PaymentMethodAuthorizationResponse> voidAuthorizationPaymentMethodWithHttpInfo(String paymentMethodId, PaymentMethodVoidAuthorizationRequest paymentMethodVoidAuthorizationRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.voidAuthorizationPaymentMethodValidateBeforeCall(paymentMethodId, paymentMethodVoidAuthorizationRequest, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentMethodAuthorizationResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call voidAuthorizationPaymentMethodAsync(String paymentMethodId, PaymentMethodVoidAuthorizationRequest paymentMethodVoidAuthorizationRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<PaymentMethodAuthorizationResponse> _callback) throws ApiException {
        Call localVarCall = this.voidAuthorizationPaymentMethodValidateBeforeCall(paymentMethodId, paymentMethodVoidAuthorizationRequest, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentMethodAuthorizationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public VoidAuthorizationPaymentMethodParams voidAuthorizationPaymentMethodParams(String paymentMethodId, PaymentMethodVoidAuthorizationRequest paymentMethodVoidAuthorizationRequest) {
        return new VoidAuthorizationPaymentMethodParams(paymentMethodId, paymentMethodVoidAuthorizationRequest);
    }

    public PaymentMethodAuthorizationResponse voidAuthorizationPaymentMethod(String paymentMethodId, PaymentMethodVoidAuthorizationRequest paymentMethodVoidAuthorizationRequest) throws ApiException {
        VoidAuthorizationPaymentMethodParams params = new VoidAuthorizationPaymentMethodParams(paymentMethodId, paymentMethodVoidAuthorizationRequest);
        return this.executeVoidAuthorizationPaymentMethodAPICall(params).getData();
    }

    public PaymentMethodAuthorizationResponse voidAuthorizationPaymentMethod(String paymentMethodId, PaymentMethodVoidAuthorizationRequest paymentMethodVoidAuthorizationRequest, Headers headers) throws ApiException {
        VoidAuthorizationPaymentMethodParams params = new VoidAuthorizationPaymentMethodParams(paymentMethodId, paymentMethodVoidAuthorizationRequest).headers(headers);
        return this.executeVoidAuthorizationPaymentMethodAPICall(params).getData();
    }

    public PaymentMethodAuthorizationResponse voidPaymentMethod(VoidAuthorizationPaymentMethodParams params) throws ApiException {
        return this.executeVoidAuthorizationPaymentMethodAPICall(params).getData();
    }

    public ApiResponse<PaymentMethodAuthorizationResponse> voidPaymentMethodWithHttpInfo(VoidAuthorizationPaymentMethodParams params) throws ApiException {
        return this.executeVoidAuthorizationPaymentMethodAPICall(params);
    }

    ApiResponse<PaymentMethodAuthorizationResponse> executeVoidAuthorizationPaymentMethodAPICall(VoidAuthorizationPaymentMethodParams params) throws ApiException {
        return this.voidAuthorizationPaymentMethodWithHttpInfo(params.paymentMethodId, params.paymentMethodVoidAuthorizationRequest, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    public static class VoidAuthorizationPaymentMethodParams {
        private final String paymentMethodId;
        private final PaymentMethodVoidAuthorizationRequest paymentMethodVoidAuthorizationRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public VoidAuthorizationPaymentMethodParams(String paymentMethodId, PaymentMethodVoidAuthorizationRequest paymentMethodVoidAuthorizationRequest) {
            this.paymentMethodId = paymentMethodId;
            this.paymentMethodVoidAuthorizationRequest = paymentMethodVoidAuthorizationRequest;
        }

        public VoidAuthorizationPaymentMethodParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }
    }

    public static class VerifyPaymentMethodParams {
        private final String paymentMethodId;
        private final PaymentMethodVerificationRequest paymentMethodVerificationRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> paymentMethodFields;
        private List<String> accountFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public VerifyPaymentMethodParams(String paymentMethodId, PaymentMethodVerificationRequest paymentMethodVerificationRequest) {
            this.paymentMethodId = paymentMethodId;
            this.paymentMethodVerificationRequest = paymentMethodVerificationRequest;
        }

        public VerifyPaymentMethodParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public VerifyPaymentMethodParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public VerifyPaymentMethodParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public VerifyPaymentMethodParams paymentMethodFields(List<String> paymentMethodFields) {
            this.paymentMethodFields = paymentMethodFields;
            return this;
        }

        public VerifyPaymentMethodParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public VerifyPaymentMethodParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public VerifyPaymentMethodParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public VerifyPaymentMethodParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class UpdatePaymentMethodParams {
        private final String paymentMethodId;
        private final PaymentMethodPatchRequest paymentMethodPatchRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> paymentMethodFields;
        private List<String> accountFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public UpdatePaymentMethodParams(String paymentMethodId, PaymentMethodPatchRequest paymentMethodPatchRequest) {
            this.paymentMethodId = paymentMethodId;
            this.paymentMethodPatchRequest = paymentMethodPatchRequest;
        }

        public UpdatePaymentMethodParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public UpdatePaymentMethodParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public UpdatePaymentMethodParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public UpdatePaymentMethodParams paymentMethodFields(List<String> paymentMethodFields) {
            this.paymentMethodFields = paymentMethodFields;
            return this;
        }

        public UpdatePaymentMethodParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public UpdatePaymentMethodParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public UpdatePaymentMethodParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public UpdatePaymentMethodParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class ScrubPaymentMethodParams {
        private final String paymentMethodId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public ScrubPaymentMethodParams(String paymentMethodId) {
            this.paymentMethodId = paymentMethodId;
        }

        public ScrubPaymentMethodParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }
    }

    public static class GetPaymentMethodsParams {
        private Headers headers;
        private ListQueryParams listQueryParams;
        private String cursor;
        private List<String> expand;
        private List<String> filter;
        private List<String> sort;
        private Integer pageSize;
        private List<String> fields;
        private List<String> paymentMethodFields;
        private List<String> accountFields;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetPaymentMethodsParams listQueryParams(ListQueryParams listQueryParams) {
            this.listQueryParams = listQueryParams;
            if (this.cursor != null) {
                this.cursor = listQueryParams.getCursor();
            }
            if (this.expand != null) {
                this.expand = listQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = listQueryParams.getFilter();
            }
            if (this.sort != null) {
                this.sort = listQueryParams.getSort();
            }
            if (this.pageSize != null) {
                this.pageSize = listQueryParams.getPageSize();
            }
            return this;
        }

        public GetPaymentMethodsParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetPaymentMethodsParams cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public GetPaymentMethodsParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetPaymentMethodsParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetPaymentMethodsParams sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public GetPaymentMethodsParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetPaymentMethodsParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetPaymentMethodsParams paymentMethodFields(List<String> paymentMethodFields) {
            this.paymentMethodFields = paymentMethodFields;
            return this;
        }

        public GetPaymentMethodsParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }
    }

    public static class GetPaymentMethodByIdParams {
        private final String paymentMethodId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> paymentMethodFields;
        private List<String> accountFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetPaymentMethodByIdParams(String paymentMethodId) {
            this.paymentMethodId = paymentMethodId;
        }

        public GetPaymentMethodByIdParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public GetPaymentMethodByIdParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetPaymentMethodByIdParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetPaymentMethodByIdParams paymentMethodFields(List<String> paymentMethodFields) {
            this.paymentMethodFields = paymentMethodFields;
            return this;
        }

        public GetPaymentMethodByIdParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public GetPaymentMethodByIdParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetPaymentMethodByIdParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetPaymentMethodByIdParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class DeletePaymentMethodParams {
        private final String paymentMethodId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public DeletePaymentMethodParams(String paymentMethodId) {
            this.paymentMethodId = paymentMethodId;
        }

        public DeletePaymentMethodParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }
    }

    public static class CreatePaymentMethodParams {
        private final PaymentMethodCreateRequest paymentMethodCreateRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> paymentMethodFields;
        private List<String> accountFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public CreatePaymentMethodParams(PaymentMethodCreateRequest paymentMethodCreateRequest) {
            this.paymentMethodCreateRequest = paymentMethodCreateRequest;
        }

        public CreatePaymentMethodParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CreatePaymentMethodParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CreatePaymentMethodParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CreatePaymentMethodParams paymentMethodFields(List<String> paymentMethodFields) {
            this.paymentMethodFields = paymentMethodFields;
            return this;
        }

        public CreatePaymentMethodParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public CreatePaymentMethodParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CreatePaymentMethodParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CreatePaymentMethodParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class AuthorizePaymentMethodParams {
        private final String paymentMethodId;
        private final PaymentMethodAuthorizationRequest paymentMethodAuthorizationRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public AuthorizePaymentMethodParams(String paymentMethodId, PaymentMethodAuthorizationRequest paymentMethodAuthorizationRequest) {
            this.paymentMethodId = paymentMethodId;
            this.paymentMethodAuthorizationRequest = paymentMethodAuthorizationRequest;
        }

        public AuthorizePaymentMethodParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }
    }
}

