/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.ExpandedAuthentication;
import com.zuora.model.ExpandedOAuth;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class AuthenticationApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AuthenticationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthenticationApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call integrationV1AuthenticatePostCall(String role, String clientname, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/authenticate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (role != null) {
            localVarHeaderParams.put("role", this.localVarApiClient.parameterToString(role));
        }
        if (clientname != null) {
            localVarHeaderParams.put("clientname", this.localVarApiClient.parameterToString(clientname));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call integrationV1AuthenticatePostValidateBeforeCall(String role, String clientname, ApiCallback _callback) throws ApiException {
        if (role == null) {
            throw new ApiException("Missing the required parameter 'role' when calling integrationV1AuthenticatePost(Async)");
        }
        if (clientname == null) {
            throw new ApiException("Missing the required parameter 'clientname' when calling integrationV1AuthenticatePost(Async)");
        }
        return this.integrationV1AuthenticatePostCall(role, clientname, _callback);
    }

    protected ExpandedAuthentication integrationV1AuthenticatePost(String role, String clientname) throws ApiException {
        ApiResponse<ExpandedAuthentication> localVarResp = this.integrationV1AuthenticatePostWithHttpInfo(role, clientname);
        return localVarResp.getData();
    }

    private ApiResponse<ExpandedAuthentication> integrationV1AuthenticatePostWithHttpInfo(String role, String clientname) throws ApiException {
        Call localVarCall = this.integrationV1AuthenticatePostValidateBeforeCall(role, clientname, null);
        Type localVarReturnType = new TypeToken<ExpandedAuthentication>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call integrationV1AuthenticatePostAsync(String role, String clientname, ApiCallback<ExpandedAuthentication> _callback) throws ApiException {
        Call localVarCall = this.integrationV1AuthenticatePostValidateBeforeCall(role, clientname, _callback);
        Type localVarReturnType = new TypeToken<ExpandedAuthentication>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public IntegrationV1AuthenticatePostApi integrationV1AuthenticatePostApi(String role, String clientname) {
        return new IntegrationV1AuthenticatePostApi(role, clientname);
    }

    private Call oauth2TokenPostCall(String clientId, String clientSecret, String grantType, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/oauth2/token";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (clientId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("client_id", clientId));
        }
        if (clientSecret != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("client_secret", clientSecret));
        }
        if (grantType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("grant_type", grantType));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call oauth2TokenPostValidateBeforeCall(String clientId, String clientSecret, String grantType, ApiCallback _callback) throws ApiException {
        if (clientId == null) {
            throw new ApiException("Missing the required parameter 'clientId' when calling oauth2TokenPost(Async)");
        }
        if (clientSecret == null) {
            throw new ApiException("Missing the required parameter 'clientSecret' when calling oauth2TokenPost(Async)");
        }
        if (grantType == null) {
            throw new ApiException("Missing the required parameter 'grantType' when calling oauth2TokenPost(Async)");
        }
        return this.oauth2TokenPostCall(clientId, clientSecret, grantType, _callback);
    }

    protected ExpandedOAuth oauth2TokenPost(String clientId, String clientSecret, String grantType) throws ApiException {
        ApiResponse<ExpandedOAuth> localVarResp = this.oauth2TokenPostWithHttpInfo(clientId, clientSecret, grantType);
        return localVarResp.getData();
    }

    private ApiResponse<ExpandedOAuth> oauth2TokenPostWithHttpInfo(String clientId, String clientSecret, String grantType) throws ApiException {
        Call localVarCall = this.oauth2TokenPostValidateBeforeCall(clientId, clientSecret, grantType, null);
        Type localVarReturnType = new TypeToken<ExpandedOAuth>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call oauth2TokenPostAsync(String clientId, String clientSecret, String grantType, ApiCallback<ExpandedOAuth> _callback) throws ApiException {
        Call localVarCall = this.oauth2TokenPostValidateBeforeCall(clientId, clientSecret, grantType, _callback);
        Type localVarReturnType = new TypeToken<ExpandedOAuth>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Oauth2TokenPostApi oauth2TokenPostApi(String clientId, String clientSecret, String grantType) {
        return new Oauth2TokenPostApi(clientId, clientSecret, grantType);
    }

    public class Oauth2TokenPostApi {
        private final String clientId;
        private final String clientSecret;
        private final String grantType;

        private Oauth2TokenPostApi(String clientId, String clientSecret, String grantType) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.grantType = grantType;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthenticationApi.this.oauth2TokenPostCall(this.clientId, this.clientSecret, this.grantType, _callback);
        }

        public ExpandedOAuth execute() throws ApiException {
            ApiResponse localVarResp = AuthenticationApi.this.oauth2TokenPostWithHttpInfo(this.clientId, this.clientSecret, this.grantType);
            return (ExpandedOAuth)localVarResp.getData();
        }

        private ApiResponse<ExpandedOAuth> executeWithHttpInfo() throws ApiException {
            return AuthenticationApi.this.oauth2TokenPostWithHttpInfo(this.clientId, this.clientSecret, this.grantType);
        }

        public Call executeAsync(ApiCallback<ExpandedOAuth> _callback) throws ApiException {
            return AuthenticationApi.this.oauth2TokenPostAsync(this.clientId, this.clientSecret, this.grantType, _callback);
        }
    }

    public class IntegrationV1AuthenticatePostApi {
        private final String role;
        private final String clientname;

        private IntegrationV1AuthenticatePostApi(String role, String clientname) {
            this.role = role;
            this.clientname = clientname;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthenticationApi.this.integrationV1AuthenticatePostCall(this.role, this.clientname, _callback);
        }

        public ExpandedAuthentication execute() throws ApiException {
            ApiResponse localVarResp = AuthenticationApi.this.integrationV1AuthenticatePostWithHttpInfo(this.role, this.clientname);
            return (ExpandedAuthentication)localVarResp.getData();
        }

        private ApiResponse<ExpandedAuthentication> executeWithHttpInfo() throws ApiException {
            return AuthenticationApi.this.integrationV1AuthenticatePostWithHttpInfo(this.role, this.clientname);
        }

        public Call executeAsync(ApiCallback<ExpandedAuthentication> _callback) throws ApiException {
            return AuthenticationApi.this.integrationV1AuthenticatePostAsync(this.role, this.clientname, _callback);
        }
    }
}

