/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.CommonResponse;
import com.zuora.model.DeleteAttachmentResponse;
import com.zuora.model.GetAttachmentResponse;
import com.zuora.model.GetAttachmentsResponse;
import com.zuora.model.PostAttachmentResponse;
import com.zuora.model.PutAttachmentRequest;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class AttachmentsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AttachmentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AttachmentsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call deleteAttachmentsCall(String attachmentId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/attachments/{attachment-id}".replace("{attachment-id}", this.localVarApiClient.escapeString(attachmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAttachmentsValidateBeforeCall(String attachmentId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (attachmentId == null) {
            throw new ApiException("Missing the required parameter 'attachmentId' when calling deleteAttachments(Async)");
        }
        return this.deleteAttachmentsCall(attachmentId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    protected DeleteAttachmentResponse deleteAttachments(String attachmentId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<DeleteAttachmentResponse> localVarResp = this.deleteAttachmentsWithHttpInfo(attachmentId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<DeleteAttachmentResponse> deleteAttachmentsWithHttpInfo(String attachmentId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.deleteAttachmentsValidateBeforeCall(attachmentId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<DeleteAttachmentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteAttachmentsAsync(String attachmentId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<DeleteAttachmentResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteAttachmentsValidateBeforeCall(attachmentId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<DeleteAttachmentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public DeleteAttachmentsApi deleteAttachmentsApi(String attachmentId) {
        return new DeleteAttachmentsApi(attachmentId);
    }

    private Call getAttachmentsCall(String attachmentId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/attachments/{attachment-id}".replace("{attachment-id}", this.localVarApiClient.escapeString(attachmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAttachmentsValidateBeforeCall(String attachmentId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (attachmentId == null) {
            throw new ApiException("Missing the required parameter 'attachmentId' when calling getAttachments(Async)");
        }
        return this.getAttachmentsCall(attachmentId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    protected GetAttachmentResponse getAttachments(String attachmentId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<GetAttachmentResponse> localVarResp = this.getAttachmentsWithHttpInfo(attachmentId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<GetAttachmentResponse> getAttachmentsWithHttpInfo(String attachmentId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.getAttachmentsValidateBeforeCall(attachmentId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<GetAttachmentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getAttachmentsAsync(String attachmentId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<GetAttachmentResponse> _callback) throws ApiException {
        Call localVarCall = this.getAttachmentsValidateBeforeCall(attachmentId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<GetAttachmentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetAttachmentsApi getAttachmentsApi(String attachmentId) {
        return new GetAttachmentsApi(attachmentId);
    }

    private Call getAttachmentsListCall(String objectType, String objectKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/attachments/{object-type}/{object-key}".replace("{object-type}", this.localVarApiClient.escapeString(objectType.toString())).replace("{object-key}", this.localVarApiClient.escapeString(objectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAttachmentsListValidateBeforeCall(String objectType, String objectKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (objectType == null) {
            throw new ApiException("Missing the required parameter 'objectType' when calling getAttachmentsList(Async)");
        }
        if (objectKey == null) {
            throw new ApiException("Missing the required parameter 'objectKey' when calling getAttachmentsList(Async)");
        }
        return this.getAttachmentsListCall(objectType, objectKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, _callback);
    }

    protected GetAttachmentsResponse getAttachmentsList(String objectType, String objectKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion) throws ApiException {
        ApiResponse<GetAttachmentsResponse> localVarResp = this.getAttachmentsListWithHttpInfo(objectType, objectKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<GetAttachmentsResponse> getAttachmentsListWithHttpInfo(String objectType, String objectKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion) throws ApiException {
        Call localVarCall = this.getAttachmentsListValidateBeforeCall(objectType, objectKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<GetAttachmentsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getAttachmentsListAsync(String objectType, String objectKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, ApiCallback<GetAttachmentsResponse> _callback) throws ApiException {
        Call localVarCall = this.getAttachmentsListValidateBeforeCall(objectType, objectKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<GetAttachmentsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetAttachmentsListApi getAttachmentsListApi(String objectType, String objectKey) {
        return new GetAttachmentsListApi(objectType, objectKey);
    }

    private Call postAttachmentsCall(String associatedObjectType, String associatedObjectKey, File _file, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String description, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/attachments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        if (description != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("description", description));
        }
        if (associatedObjectType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("associatedObjectType", associatedObjectType));
        }
        if (associatedObjectKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("associatedObjectKey", associatedObjectKey));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postAttachmentsValidateBeforeCall(String associatedObjectType, String associatedObjectKey, File _file, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String description, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (associatedObjectType == null) {
            throw new ApiException("Missing the required parameter 'associatedObjectType' when calling postAttachments(Async)");
        }
        if (associatedObjectKey == null) {
            throw new ApiException("Missing the required parameter 'associatedObjectKey' when calling postAttachments(Async)");
        }
        if (_file == null) {
            throw new ApiException("Missing the required parameter '_file' when calling postAttachments(Async)");
        }
        return this.postAttachmentsCall(associatedObjectType, associatedObjectKey, _file, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, description, zuoraVersion, _callback);
    }

    protected PostAttachmentResponse postAttachments(String associatedObjectType, String associatedObjectKey, File _file, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String description, String zuoraVersion) throws ApiException {
        ApiResponse<PostAttachmentResponse> localVarResp = this.postAttachmentsWithHttpInfo(associatedObjectType, associatedObjectKey, _file, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, description, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<PostAttachmentResponse> postAttachmentsWithHttpInfo(String associatedObjectType, String associatedObjectKey, File _file, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String description, String zuoraVersion) throws ApiException {
        Call localVarCall = this.postAttachmentsValidateBeforeCall(associatedObjectType, associatedObjectKey, _file, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, description, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<PostAttachmentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call postAttachmentsAsync(String associatedObjectType, String associatedObjectKey, File _file, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String description, String zuoraVersion, ApiCallback<PostAttachmentResponse> _callback) throws ApiException {
        Call localVarCall = this.postAttachmentsValidateBeforeCall(associatedObjectType, associatedObjectKey, _file, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, description, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<PostAttachmentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PostAttachmentsApi postAttachmentsApi(String associatedObjectType, String associatedObjectKey, File _file) {
        return new PostAttachmentsApi(associatedObjectType, associatedObjectKey, _file);
    }

    private Call putAttachmentsCall(String attachmentId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, PutAttachmentRequest request, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PutAttachmentRequest localVarPostBody = request;
        String localVarPath = "/v1/attachments/{attachment-id}".replace("{attachment-id}", this.localVarApiClient.escapeString(attachmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call putAttachmentsValidateBeforeCall(String attachmentId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, PutAttachmentRequest request, ApiCallback _callback) throws ApiException {
        if (attachmentId == null) {
            throw new ApiException("Missing the required parameter 'attachmentId' when calling putAttachments(Async)");
        }
        return this.putAttachmentsCall(attachmentId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, request, _callback);
    }

    protected CommonResponse putAttachments(String attachmentId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, PutAttachmentRequest request) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.putAttachmentsWithHttpInfo(attachmentId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, request);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> putAttachmentsWithHttpInfo(String attachmentId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, PutAttachmentRequest request) throws ApiException {
        Call localVarCall = this.putAttachmentsValidateBeforeCall(attachmentId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, request, null);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call putAttachmentsAsync(String attachmentId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, PutAttachmentRequest request, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.putAttachmentsValidateBeforeCall(attachmentId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, request, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PutAttachmentsApi putAttachmentsApi(String attachmentId) {
        return new PutAttachmentsApi(attachmentId);
    }

    public class PutAttachmentsApi {
        private final String attachmentId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private PutAttachmentRequest request;

        private PutAttachmentsApi(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        public PutAttachmentsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PutAttachmentsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PutAttachmentsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PutAttachmentsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PutAttachmentsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PutAttachmentsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public PutAttachmentsApi request(PutAttachmentRequest request) {
            this.request = request;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AttachmentsApi.this.putAttachmentsCall(this.attachmentId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.request, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse localVarResp = AttachmentsApi.this.putAttachmentsWithHttpInfo(this.attachmentId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.request);
            return (CommonResponse)localVarResp.getData();
        }

        private ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return AttachmentsApi.this.putAttachmentsWithHttpInfo(this.attachmentId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.request);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return AttachmentsApi.this.putAttachmentsAsync(this.attachmentId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.request, _callback);
        }
    }

    public class PostAttachmentsApi {
        private final String associatedObjectType;
        private final String associatedObjectKey;
        private final File _file;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String description;
        private String zuoraVersion;

        private PostAttachmentsApi(String associatedObjectType, String associatedObjectKey, File _file) {
            this.associatedObjectType = associatedObjectType;
            this.associatedObjectKey = associatedObjectKey;
            this._file = _file;
        }

        public PostAttachmentsApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public PostAttachmentsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PostAttachmentsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PostAttachmentsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PostAttachmentsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PostAttachmentsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PostAttachmentsApi description(String description) {
            this.description = description;
            return this;
        }

        public PostAttachmentsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AttachmentsApi.this.postAttachmentsCall(this.associatedObjectType, this.associatedObjectKey, this._file, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.description, this.zuoraVersion, _callback);
        }

        public PostAttachmentResponse execute() throws ApiException {
            ApiResponse localVarResp = AttachmentsApi.this.postAttachmentsWithHttpInfo(this.associatedObjectType, this.associatedObjectKey, this._file, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.description, this.zuoraVersion);
            return (PostAttachmentResponse)localVarResp.getData();
        }

        private ApiResponse<PostAttachmentResponse> executeWithHttpInfo() throws ApiException {
            return AttachmentsApi.this.postAttachmentsWithHttpInfo(this.associatedObjectType, this.associatedObjectKey, this._file, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.description, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<PostAttachmentResponse> _callback) throws ApiException {
            return AttachmentsApi.this.postAttachmentsAsync(this.associatedObjectType, this.associatedObjectKey, this._file, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.description, this.zuoraVersion, _callback);
        }
    }

    public class GetAttachmentsListApi {
        private final String objectType;
        private final String objectKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer page;
        private Integer pageSize;
        private String zuoraVersion;

        private GetAttachmentsListApi(String objectType, String objectKey) {
            this.objectType = objectType;
            this.objectKey = objectKey;
        }

        public GetAttachmentsListApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetAttachmentsListApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetAttachmentsListApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetAttachmentsListApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetAttachmentsListApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetAttachmentsListApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetAttachmentsListApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetAttachmentsListApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AttachmentsApi.this.getAttachmentsListCall(this.objectType, this.objectKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, _callback);
        }

        public GetAttachmentsResponse execute() throws ApiException {
            ApiResponse localVarResp = AttachmentsApi.this.getAttachmentsListWithHttpInfo(this.objectType, this.objectKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion);
            return (GetAttachmentsResponse)localVarResp.getData();
        }

        private ApiResponse<GetAttachmentsResponse> executeWithHttpInfo() throws ApiException {
            return AttachmentsApi.this.getAttachmentsListWithHttpInfo(this.objectType, this.objectKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<GetAttachmentsResponse> _callback) throws ApiException {
            return AttachmentsApi.this.getAttachmentsListAsync(this.objectType, this.objectKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, _callback);
        }
    }

    public class GetAttachmentsApi {
        private final String attachmentId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private GetAttachmentsApi(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        public GetAttachmentsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetAttachmentsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetAttachmentsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetAttachmentsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetAttachmentsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetAttachmentsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AttachmentsApi.this.getAttachmentsCall(this.attachmentId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public GetAttachmentResponse execute() throws ApiException {
            ApiResponse localVarResp = AttachmentsApi.this.getAttachmentsWithHttpInfo(this.attachmentId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (GetAttachmentResponse)localVarResp.getData();
        }

        private ApiResponse<GetAttachmentResponse> executeWithHttpInfo() throws ApiException {
            return AttachmentsApi.this.getAttachmentsWithHttpInfo(this.attachmentId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<GetAttachmentResponse> _callback) throws ApiException {
            return AttachmentsApi.this.getAttachmentsAsync(this.attachmentId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class DeleteAttachmentsApi {
        private final String attachmentId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private DeleteAttachmentsApi(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        public DeleteAttachmentsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public DeleteAttachmentsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public DeleteAttachmentsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public DeleteAttachmentsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public DeleteAttachmentsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public DeleteAttachmentsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AttachmentsApi.this.deleteAttachmentsCall(this.attachmentId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public DeleteAttachmentResponse execute() throws ApiException {
            ApiResponse localVarResp = AttachmentsApi.this.deleteAttachmentsWithHttpInfo(this.attachmentId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (DeleteAttachmentResponse)localVarResp.getData();
        }

        private ApiResponse<DeleteAttachmentResponse> executeWithHttpInfo() throws ApiException {
            return AttachmentsApi.this.deleteAttachmentsWithHttpInfo(this.attachmentId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<DeleteAttachmentResponse> _callback) throws ApiException {
            return AttachmentsApi.this.deleteAttachmentsAsync(this.attachmentId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }
}

