/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Nullable;

public class ResponseHeaders {
    public static final String SERIALIZED_NAME_RATELIMIT_LIMIT = "ratelimit-limit";
    @SerializedName(value="ratelimit-limit")
    private String ratelimitLimit;
    public static final String SERIALIZED_NAME_RATELIMIT_REMAINING = "ratelimit-remaining";
    @SerializedName(value="ratelimit-remaining")
    private BigDecimal ratelimitRemaining;
    public static final String SERIALIZED_NAME_RATELIMIT_RESET = "ratelimit-reset";
    @SerializedName(value="ratelimit-reset")
    private BigDecimal ratelimitReset;
    public static final String SERIALIZED_NAME_ZUORA_REQUEST_ID = "zuora-request-id";
    @SerializedName(value="zuora-request-id")
    private String zuoraRequestId;
    public static final String SERIALIZED_NAME_ZUORA_TRACK_ID = "zuora-track-id";
    @SerializedName(value="zuora-track-id")
    private String zuoraTrackId;

    public ResponseHeaders ratelimitLimit(String ratelimitLimit) {
        this.ratelimitLimit = ratelimitLimit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The request limit quota for the time window closest to exhaustion. See [rate limits](https://developer.zuora.com/rest-api/general-concepts/rate-concurrency-limits/#rate-limits) for more information.")
    public String getRatelimitLimit() {
        return this.ratelimitLimit;
    }

    public void setRatelimitLimit(String ratelimitLimit) {
        this.ratelimitLimit = ratelimitLimit;
    }

    public ResponseHeaders ratelimitRemaining(BigDecimal ratelimitRemaining) {
        this.ratelimitRemaining = ratelimitRemaining;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of requests remaining in the time window closest to quota exhaustion. See [rate limits](https://developer.zuora.com/rest-api/general-concepts/rate-concurrency-limits/#rate-limits) for more information.")
    public BigDecimal getRatelimitRemaining() {
        return this.ratelimitRemaining;
    }

    public void setRatelimitRemaining(BigDecimal ratelimitRemaining) {
        this.ratelimitRemaining = ratelimitRemaining;
    }

    public ResponseHeaders ratelimitReset(BigDecimal ratelimitReset) {
        this.ratelimitReset = ratelimitReset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of seconds until the quota resets for the time window closest to quota exhaustion. See [rate limits](https://developer.zuora.com/rest-api/general-concepts/rate-concurrency-limits/#rate-limits) for more information.")
    public BigDecimal getRatelimitReset() {
        return this.ratelimitReset;
    }

    public void setRatelimitReset(BigDecimal ratelimitReset) {
        this.ratelimitReset = ratelimitReset;
    }

    public ResponseHeaders zuoraRequestId(String zuoraRequestId) {
        this.zuoraRequestId = zuoraRequestId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Zuora\u2019s internal identifier for this request.")
    public String getZuoraRequestId() {
        return this.zuoraRequestId;
    }

    public void setZuoraRequestId(String zuoraRequestId) {
        this.zuoraRequestId = zuoraRequestId;
    }

    public ResponseHeaders zuoraTrackId(String zuoraTrackId) {
        this.zuoraTrackId = zuoraTrackId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A user-supplied identifier for this request. If you supply a `zuora-track-id` as a request header, Zuora returns the `zuora-track-id` as a response header. ")
    public String getZuoraTrackId() {
        return this.zuoraTrackId;
    }

    public void setZuoraTrackId(String zuoraTrackId) {
        this.zuoraTrackId = zuoraTrackId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseHeaders responseHeaders = (ResponseHeaders)o;
        return Objects.equals(this.ratelimitLimit, responseHeaders.ratelimitLimit) && Objects.equals(this.ratelimitRemaining, responseHeaders.ratelimitRemaining) && Objects.equals(this.ratelimitReset, responseHeaders.ratelimitReset) && Objects.equals(this.zuoraRequestId, responseHeaders.zuoraRequestId) && Objects.equals(this.zuoraTrackId, responseHeaders.zuoraTrackId);
    }

    public int hashCode() {
        return Objects.hash(this.ratelimitLimit, this.ratelimitRemaining, this.ratelimitReset, this.zuoraRequestId, this.zuoraTrackId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResponseHeaders {\n");
        sb.append("    ratelimitLimit: ").append(this.toIndentedString(this.ratelimitLimit)).append("\n");
        sb.append("    ratelimitRemaining: ").append(this.toIndentedString(this.ratelimitRemaining)).append("\n");
        sb.append("    ratelimitReset: ").append(this.toIndentedString(this.ratelimitReset)).append("\n");
        sb.append("    zuoraRequestId: ").append(this.toIndentedString(this.zuoraRequestId)).append("\n");
        sb.append("    zuoraTrackId: ").append(this.toIndentedString(this.zuoraTrackId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

