/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.Payment;
import org.openapitools.jackson.nullable.JsonNullable;

public class PaymentTransactions {
    public static final String SERIALIZED_NAME_PAYMENT_NUMBER = "payment_number";
    @SerializedName(value="payment_number")
    private String paymentNumber;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private List<String> amount = null;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private Object state;
    public static final String SERIALIZED_NAME_PAYMENTS = "payments";
    @SerializedName(value="payments")
    private Payment payments;

    public PaymentTransactions paymentNumber(String paymentNumber) {
        this.paymentNumber = paymentNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of the payment.")
    public String getPaymentNumber() {
        return this.paymentNumber;
    }

    public void setPaymentNumber(String paymentNumber) {
        this.paymentNumber = paymentNumber;
    }

    public PaymentTransactions amount(List<String> amount) {
        this.amount = amount;
        return this;
    }

    public PaymentTransactions addAmountItem(String amountItem) {
        if (this.amount == null) {
            this.amount = new ArrayList<String>();
        }
        this.amount.add(amountItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The payment transaction amount.")
    public List<String> getAmount() {
        return this.amount;
    }

    public void setAmount(List<String> amount) {
        this.amount = amount;
    }

    public PaymentTransactions state(Object state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The state of the payment.")
    public Object getState() {
        return this.state;
    }

    public void setState(Object state) {
        this.state = state;
    }

    public PaymentTransactions payments(Payment payments) {
        this.payments = payments;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The related payments.")
    public Payment getPayments() {
        return this.payments;
    }

    public void setPayments(Payment payments) {
        this.payments = payments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentTransactions paymentTransactions = (PaymentTransactions)o;
        return Objects.equals(this.paymentNumber, paymentTransactions.paymentNumber) && Objects.equals(this.amount, paymentTransactions.amount) && Objects.equals(this.state, paymentTransactions.state) && Objects.equals(this.payments, paymentTransactions.payments);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.paymentNumber, this.amount, this.state, this.payments);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentTransactions {\n");
        sb.append("    paymentNumber: ").append(this.toIndentedString(this.paymentNumber)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    payments: ").append(this.toIndentedString(this.payments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

