/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.Account;
import org.openapitools.client.model.PaymentMethod;
import org.openapitools.client.model.RefundCreditMemoRequest;
import org.openapitools.client.model.RefundStateTransitions;
import org.openapitools.client.model.RefundsAppliedToResponse;
import org.openapitools.jackson.nullable.JsonNullable;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class Refund {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updated_by_id";
    @SerializedName(value="updated_by_id")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, String> customFields = null;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_GATEWAY_OPTIONS = "gateway_options";
    @SerializedName(value="gateway_options")
    private Map<String, String> gatewayOptions = null;
    public static final String SERIALIZED_NAME_REFUND_DATE = "refund_date";
    @SerializedName(value="refund_date")
    private LocalDate refundDate;
    public static final String SERIALIZED_NAME_REFUND_METHOD_TYPE = "refund_method_type";
    @SerializedName(value="refund_method_type")
    private RefundMethodTypeEnum refundMethodType;
    public static final String SERIALIZED_NAME_PAYMENT_ID = "payment_id";
    @SerializedName(value="payment_id")
    private String paymentId;
    public static final String SERIALIZED_NAME_REASON_CODE = "reason_code";
    @SerializedName(value="reason_code")
    private String reasonCode;
    public static final String SERIALIZED_NAME_STATEMENT_DESCRIPTOR = "statement_descriptor";
    @SerializedName(value="statement_descriptor")
    private String statementDescriptor;
    public static final String SERIALIZED_NAME_STATEMENT_DESCRIPTOR_PHONE = "statement_descriptor_phone";
    @SerializedName(value="statement_descriptor_phone")
    private String statementDescriptorPhone;
    public static final String SERIALIZED_NAME_EXTERNAL = "external";
    @SerializedName(value="external")
    private Boolean external;
    public static final String SERIALIZED_NAME_REFERENCE_ID = "reference_id";
    @SerializedName(value="reference_id")
    private String referenceId;
    public static final String SERIALIZED_NAME_SECOND_REFERENCE_ID = "second_reference_id";
    @SerializedName(value="second_reference_id")
    private String secondReferenceId;
    public static final String SERIALIZED_NAME_BANK_ACCOUNT_ACCOUNT = "bank_account_account";
    @SerializedName(value="bank_account_account")
    private String bankAccountAccount;
    public static final String SERIALIZED_NAME_ON_ACCOUNT_ACCOUNT = "on_account_account";
    @SerializedName(value="on_account_account")
    private String onAccountAccount;
    public static final String SERIALIZED_NAME_UNAPPLIED_PAYMENT_ACCOUNT = "unapplied_payment_account";
    @SerializedName(value="unapplied_payment_account")
    private String unappliedPaymentAccount;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD_ID = "payment_method_id";
    @SerializedName(value="payment_method_id")
    private String paymentMethodId;
    public static final String SERIALIZED_NAME_CREDIT_MEMO = "credit_memo";
    @SerializedName(value="credit_memo")
    private RefundCreditMemoRequest creditMemo;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT = "account";
    @SerializedName(value="account")
    private Account account;
    public static final String SERIALIZED_NAME_GATEWAY_ID = "gateway_id";
    @SerializedName(value="gateway_id")
    private String gatewayId;
    public static final String SERIALIZED_NAME_COMMENT = "comment";
    @SerializedName(value="comment")
    private String comment;
    public static final String SERIALIZED_NAME_GATEWAY_RESPONSE = "gateway_response";
    @SerializedName(value="gateway_response")
    private String gatewayResponse;
    public static final String SERIALIZED_NAME_GATEWAY_RESPONSE_CODE = "gateway_response_code";
    @SerializedName(value="gateway_response_code")
    private String gatewayResponseCode;
    public static final String SERIALIZED_NAME_GATEWAY_STATE = "gateway_state";
    @SerializedName(value="gateway_state")
    private GatewayStateEnum gatewayState;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD = "payment_method";
    @SerializedName(value="payment_method")
    private PaymentMethod paymentMethod;
    public static final String SERIALIZED_NAME_REFUND_NUMBER = "refund_number";
    @SerializedName(value="refund_number")
    private String refundNumber;
    public static final String SERIALIZED_NAME_STATE_TRANSITIONS = "state_transitions";
    @SerializedName(value="state_transitions")
    private RefundStateTransitions stateTransitions;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_GATEWAY_RECONCILIATION_REASON = "gateway_reconciliation_reason";
    @SerializedName(value="gateway_reconciliation_reason")
    private String gatewayReconciliationReason;
    public static final String SERIALIZED_NAME_GATEWAY_RECONCILIATION_STATUS = "gateway_reconciliation_status";
    @SerializedName(value="gateway_reconciliation_status")
    private String gatewayReconciliationStatus;
    public static final String SERIALIZED_NAME_PAYOUT_ID = "payout_id";
    @SerializedName(value="payout_id")
    private String payoutId;
    public static final String SERIALIZED_NAME_APPLIED_TO = "applied_to";
    @SerializedName(value="applied_to")
    private List<RefundsAppliedToResponse> appliedTo = null;

    public Refund() {
    }

    public Refund(String updatedById, OffsetDateTime updatedTime, String createdById, OffsetDateTime createdTime, Map<String, Object> customObjects, String paymentId, String paymentMethodId, String gatewayResponse, String gatewayResponseCode, GatewayStateEnum gatewayState, StateEnum state, String gatewayReconciliationReason, String gatewayReconciliationStatus, String payoutId, List<RefundsAppliedToResponse> appliedTo) {
        this();
        this.updatedById = updatedById;
        this.updatedTime = updatedTime;
        this.createdById = createdById;
        this.createdTime = createdTime;
        this.customObjects = customObjects;
        this.paymentId = paymentId;
        this.paymentMethodId = paymentMethodId;
        this.gatewayResponse = gatewayResponse;
        this.gatewayResponseCode = gatewayResponseCode;
        this.gatewayState = gatewayState;
        this.state = state;
        this.gatewayReconciliationReason = gatewayReconciliationReason;
        this.gatewayReconciliationStatus = gatewayReconciliationStatus;
        this.payoutId = payoutId;
        this.appliedTo = appliedTo;
    }

    public Refund id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who last updated the object")
    public String getUpdatedById() {
        return this.updatedById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO 8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was created in ISO 8601 UTC format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public Refund customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public Refund putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public Refund amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Refund amount.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Refund description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An arbitrary string attached to the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Refund gatewayOptions(Map<String, String> gatewayOptions) {
        this.gatewayOptions = gatewayOptions;
        return this;
    }

    public Refund putGatewayOptionsItem(String key, String gatewayOptionsItem) {
        if (this.gatewayOptions == null) {
            this.gatewayOptions = new HashMap<String, String>();
        }
        this.gatewayOptions.put(key, gatewayOptionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"key\":\"value\"}", value="")
    public Map<String, String> getGatewayOptions() {
        return this.gatewayOptions;
    }

    public void setGatewayOptions(Map<String, String> gatewayOptions) {
        this.gatewayOptions = gatewayOptions;
    }

    public Refund refundDate(LocalDate refundDate) {
        this.refundDate = refundDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date when the refund takes effect.")
    public LocalDate getRefundDate() {
        return this.refundDate;
    }

    public void setRefundDate(LocalDate refundDate) {
        this.refundDate = refundDate;
    }

    public Refund refundMethodType(RefundMethodTypeEnum refundMethodType) {
        this.refundMethodType = refundMethodType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public RefundMethodTypeEnum getRefundMethodType() {
        return this.refundMethodType;
    }

    public void setRefundMethodType(RefundMethodTypeEnum refundMethodType) {
        this.refundMethodType = refundMethodType;
    }

    @Nullable
    @ApiModelProperty(value="Identifier for the payment, either `payment_number` or `payment_id.")
    public String getPaymentId() {
        return this.paymentId;
    }

    public Refund reasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="User-provided reason for the refund.")
    public String getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    public Refund statementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A payment gateway-specific field used by Orbital, Vantiv and Verifi.")
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    public Refund statementDescriptorPhone(String statementDescriptorPhone) {
        this.statementDescriptorPhone = statementDescriptorPhone;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A payment gateway-specific field used by Orbital, Vantiv and Verifi.")
    public String getStatementDescriptorPhone() {
        return this.statementDescriptorPhone;
    }

    public void setStatementDescriptorPhone(String statementDescriptorPhone) {
        this.statementDescriptorPhone = statementDescriptorPhone;
    }

    public Refund external(Boolean external) {
        this.external = external;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, indicates that this refund is not handled by Zuora.")
    public Boolean getExternal() {
        return this.external;
    }

    public void setExternal(Boolean external) {
        this.external = external;
    }

    public Refund referenceId(String referenceId) {
        this.referenceId = referenceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Transaction identifier returned by the payment gateway. You may use this field to reconcile refunds between your payment gateway and Zuora Payments.")
    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public Refund secondReferenceId(String secondReferenceId) {
        this.secondReferenceId = secondReferenceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A second transaction identifier returned by the payment gateway if there is an additional transaction for the refunds. You may use this field to reconcile payments between your payment gateway and Zuora Payments.")
    public String getSecondReferenceId() {
        return this.secondReferenceId;
    }

    public void setSecondReferenceId(String secondReferenceId) {
        this.secondReferenceId = secondReferenceId;
    }

    public Refund bankAccountAccount(String bankAccountAccount) {
        this.bankAccountAccount = bankAccountAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active account in your Zuora Chart of Accounts.")
    public String getBankAccountAccount() {
        return this.bankAccountAccount;
    }

    public void setBankAccountAccount(String bankAccountAccount) {
        this.bankAccountAccount = bankAccountAccount;
    }

    public Refund onAccountAccount(String onAccountAccount) {
        this.onAccountAccount = onAccountAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active account in your Zuora Chart of Accounts.")
    public String getOnAccountAccount() {
        return this.onAccountAccount;
    }

    public void setOnAccountAccount(String onAccountAccount) {
        this.onAccountAccount = onAccountAccount;
    }

    public Refund unappliedPaymentAccount(String unappliedPaymentAccount) {
        this.unappliedPaymentAccount = unappliedPaymentAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active account in your Zuora Chart of Accounts.")
    public String getUnappliedPaymentAccount() {
        return this.unappliedPaymentAccount;
    }

    public void setUnappliedPaymentAccount(String unappliedPaymentAccount) {
        this.unappliedPaymentAccount = unappliedPaymentAccount;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the payment method used to create this refund.")
    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public Refund creditMemo(RefundCreditMemoRequest creditMemo) {
        this.creditMemo = creditMemo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The related credit memo.")
    public RefundCreditMemoRequest getCreditMemo() {
        return this.creditMemo;
    }

    public void setCreditMemo(RefundCreditMemoRequest creditMemo) {
        this.creditMemo = creditMemo;
    }

    public Refund accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the customer this refund is for, if one exists.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public Refund account(Account account) {
        this.account = account;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The account that owns the refund")
    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public Refund gatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the payment gateway that Zuora will use to authorize the payments that are made with this payment method. If you do not set this field, Zuora will use one of the following payment gateways instead: The default payment gateway of the customer account that owns the payment method, if the payment method is associated with a customer account or the default payment gateway of your Zuora tenant.")
    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    public Refund comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Comments about the refund.")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Nullable
    @ApiModelProperty(value="Message returned by the payment gateway for this refund.")
    public String getGatewayResponse() {
        return this.gatewayResponse;
    }

    @Nullable
    @ApiModelProperty(value="Code returned by the payment gateway for this refund.")
    public String getGatewayResponseCode() {
        return this.gatewayResponseCode;
    }

    @Nullable
    @ApiModelProperty(value="The payment gateway state of the refund.")
    public GatewayStateEnum getGatewayState() {
        return this.gatewayState;
    }

    public Refund paymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public Refund refundNumber(String refundNumber) {
        this.refundNumber = refundNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable identifier for this object; may be user-supplied.")
    public String getRefundNumber() {
        return this.refundNumber;
    }

    public void setRefundNumber(String refundNumber) {
        this.refundNumber = refundNumber;
    }

    public Refund stateTransitions(RefundStateTransitions stateTransitions) {
        this.stateTransitions = stateTransitions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public RefundStateTransitions getStateTransitions() {
        return this.stateTransitions;
    }

    public void setStateTransitions(RefundStateTransitions stateTransitions) {
        this.stateTransitions = stateTransitions;
    }

    @Nullable
    @ApiModelProperty(value="The state of the refund.")
    public StateEnum getState() {
        return this.state;
    }

    @Nullable
    @ApiModelProperty(value="Gateway reconciliation reason.")
    public String getGatewayReconciliationReason() {
        return this.gatewayReconciliationReason;
    }

    @Nullable
    @ApiModelProperty(value="Gateway reconciliation state.")
    public String getGatewayReconciliationStatus() {
        return this.gatewayReconciliationStatus;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the payout from the payment gateway.")
    public String getPayoutId() {
        return this.payoutId;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<RefundsAppliedToResponse> getAppliedTo() {
        return this.appliedTo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Refund refund = (Refund)o;
        return Objects.equals(this.id, refund.id) && Objects.equals(this.updatedById, refund.updatedById) && Objects.equals(this.updatedTime, refund.updatedTime) && Objects.equals(this.createdById, refund.createdById) && Objects.equals(this.createdTime, refund.createdTime) && Objects.equals(this.customFields, refund.customFields) && Objects.equals(this.customObjects, refund.customObjects) && Objects.equals(this.amount, refund.amount) && Objects.equals(this.description, refund.description) && Objects.equals(this.gatewayOptions, refund.gatewayOptions) && Objects.equals(this.refundDate, refund.refundDate) && Objects.equals((Object)this.refundMethodType, (Object)refund.refundMethodType) && Objects.equals(this.paymentId, refund.paymentId) && Objects.equals(this.reasonCode, refund.reasonCode) && Objects.equals(this.statementDescriptor, refund.statementDescriptor) && Objects.equals(this.statementDescriptorPhone, refund.statementDescriptorPhone) && Objects.equals(this.external, refund.external) && Objects.equals(this.referenceId, refund.referenceId) && Objects.equals(this.secondReferenceId, refund.secondReferenceId) && Objects.equals(this.bankAccountAccount, refund.bankAccountAccount) && Objects.equals(this.onAccountAccount, refund.onAccountAccount) && Objects.equals(this.unappliedPaymentAccount, refund.unappliedPaymentAccount) && Objects.equals(this.paymentMethodId, refund.paymentMethodId) && Objects.equals(this.creditMemo, refund.creditMemo) && Objects.equals(this.accountId, refund.accountId) && Objects.equals(this.account, refund.account) && Objects.equals(this.gatewayId, refund.gatewayId) && Objects.equals(this.comment, refund.comment) && Objects.equals(this.gatewayResponse, refund.gatewayResponse) && Objects.equals(this.gatewayResponseCode, refund.gatewayResponseCode) && Objects.equals((Object)this.gatewayState, (Object)refund.gatewayState) && Objects.equals(this.paymentMethod, refund.paymentMethod) && Objects.equals(this.refundNumber, refund.refundNumber) && Objects.equals(this.stateTransitions, refund.stateTransitions) && Objects.equals((Object)this.state, (Object)refund.state) && Objects.equals(this.gatewayReconciliationReason, refund.gatewayReconciliationReason) && Objects.equals(this.gatewayReconciliationStatus, refund.gatewayReconciliationStatus) && Objects.equals(this.payoutId, refund.payoutId) && Objects.equals(this.appliedTo, refund.appliedTo);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.updatedById, this.updatedTime, this.createdById, this.createdTime, this.customFields, this.customObjects, this.amount, this.description, this.gatewayOptions, this.refundDate, this.refundMethodType, this.paymentId, this.reasonCode, this.statementDescriptor, this.statementDescriptorPhone, this.external, this.referenceId, this.secondReferenceId, this.bankAccountAccount, this.onAccountAccount, this.unappliedPaymentAccount, this.paymentMethodId, this.creditMemo, this.accountId, this.account, this.gatewayId, this.comment, this.gatewayResponse, this.gatewayResponseCode, this.gatewayState, this.paymentMethod, this.refundNumber, this.stateTransitions, this.state, this.gatewayReconciliationReason, this.gatewayReconciliationStatus, this.payoutId, this.appliedTo});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Refund {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    gatewayOptions: ").append(this.toIndentedString(this.gatewayOptions)).append("\n");
        sb.append("    refundDate: ").append(this.toIndentedString(this.refundDate)).append("\n");
        sb.append("    refundMethodType: ").append(this.toIndentedString((Object)this.refundMethodType)).append("\n");
        sb.append("    paymentId: ").append(this.toIndentedString(this.paymentId)).append("\n");
        sb.append("    reasonCode: ").append(this.toIndentedString(this.reasonCode)).append("\n");
        sb.append("    statementDescriptor: ").append(this.toIndentedString(this.statementDescriptor)).append("\n");
        sb.append("    statementDescriptorPhone: ").append(this.toIndentedString(this.statementDescriptorPhone)).append("\n");
        sb.append("    external: ").append(this.toIndentedString(this.external)).append("\n");
        sb.append("    referenceId: ").append(this.toIndentedString(this.referenceId)).append("\n");
        sb.append("    secondReferenceId: ").append(this.toIndentedString(this.secondReferenceId)).append("\n");
        sb.append("    bankAccountAccount: ").append(this.toIndentedString(this.bankAccountAccount)).append("\n");
        sb.append("    onAccountAccount: ").append(this.toIndentedString(this.onAccountAccount)).append("\n");
        sb.append("    unappliedPaymentAccount: ").append(this.toIndentedString(this.unappliedPaymentAccount)).append("\n");
        sb.append("    paymentMethodId: ").append(this.toIndentedString(this.paymentMethodId)).append("\n");
        sb.append("    creditMemo: ").append(this.toIndentedString(this.creditMemo)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    gatewayId: ").append(this.toIndentedString(this.gatewayId)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    gatewayResponse: ").append(this.toIndentedString(this.gatewayResponse)).append("\n");
        sb.append("    gatewayResponseCode: ").append(this.toIndentedString(this.gatewayResponseCode)).append("\n");
        sb.append("    gatewayState: ").append(this.toIndentedString((Object)this.gatewayState)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    refundNumber: ").append(this.toIndentedString(this.refundNumber)).append("\n");
        sb.append("    stateTransitions: ").append(this.toIndentedString(this.stateTransitions)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    gatewayReconciliationReason: ").append(this.toIndentedString(this.gatewayReconciliationReason)).append("\n");
        sb.append("    gatewayReconciliationStatus: ").append(this.toIndentedString(this.gatewayReconciliationStatus)).append("\n");
        sb.append("    payoutId: ").append(this.toIndentedString(this.payoutId)).append("\n");
        sb.append("    appliedTo: ").append(this.toIndentedString(this.appliedTo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        DRAFT("draft"),
        POSTED("posted"),
        PROCESSING("processing"),
        PROCESSED("processed"),
        ERROR("error"),
        CANCELED("canceled"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum GatewayStateEnum {
        MARKED_FOR_SUBMISSION("marked_for_submission"),
        SUBMITTED("submitted"),
        SETTLED("settled"),
        NOT_SUBMITTED("not_submitted"),
        FAILED("failed"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private GatewayStateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static GatewayStateEnum fromValue(String value) {
            for (GatewayStateEnum b : GatewayStateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<GatewayStateEnum> {
            public void write(JsonWriter jsonWriter, GatewayStateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public GatewayStateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return GatewayStateEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RefundMethodTypeEnum {
        CASH("cash"),
        CHECK("check"),
        WIRE_TRANSFER("wire_transfer"),
        PAY_PAL("pay_pal"),
        CREDIT_CARD("credit_card"),
        CC_REF("cc_ref"),
        ACH_DEBIT("ach_debit"),
        DEBIT_CARD("debit_card"),
        OTHER("other"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private RefundMethodTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RefundMethodTypeEnum fromValue(String value) {
            for (RefundMethodTypeEnum b : RefundMethodTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<RefundMethodTypeEnum> {
            public void write(JsonWriter jsonWriter, RefundMethodTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RefundMethodTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RefundMethodTypeEnum.fromValue(value);
            }
        }
    }
}

