/*
 * Decompiled with CFR 0.152.
 */
package com.zpj.http.core;

import android.text.TextUtils;
import com.zpj.http.core.CookieJar;
import com.zpj.http.core.DefaultConstant;
import com.zpj.http.core.IHttp;
import com.zpj.http.parser.html.TokenQueue;
import com.zpj.http.utils.StringUtil;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;

public abstract class BaseConfig<T extends BaseConfig<T>> {
    URI baseUrl;
    boolean debug;
    int bufferSize = 1024;
    long maxBodySize = 0L;
    boolean ignoreHttpErrors = true;
    boolean ignoreContentType = false;
    String postDataCharset = "UTF-8";
    String userAgent = DefaultConstant.USER_AGENT;
    int retryCount = 3;
    int retryDelay = 10000;
    int connectTimeout = 30000;
    int readTimeout = 30000;
    final Map<String, String> cookies = new HashMap<String, String>();
    boolean allowAllSSL = true;
    final Map<String, String> headers = new HashMap<String, String>();
    Proxy proxy;
    private SSLSocketFactory sslSocketFactory;
    int maxRedirectCount = 20;
    IHttp.OnRedirectListener onRedirectListener;
    CookieJar cookieJar;

    public URI baseUrl() {
        return this.baseUrl;
    }

    public boolean debug() {
        return this.debug;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public long maxBodySize() {
        return this.maxBodySize;
    }

    public String postDataCharset() {
        return this.postDataCharset;
    }

    public boolean ignoreHttpErrors() {
        return this.ignoreHttpErrors;
    }

    public boolean ignoreContentType() {
        return this.ignoreContentType;
    }

    public String userAgent() {
        return this.userAgent;
    }

    public int retryCount() {
        return this.retryCount;
    }

    public String getCookie(String name) {
        return this.cookies.get(name);
    }

    public boolean hasCookie(String name) {
        return this.cookies.containsKey(name);
    }

    public String removeCookie(String name) {
        return this.cookies.remove(name);
    }

    public Map<String, String> cookies() {
        return this.cookies;
    }

    public String cookieStr() {
        StringBuilder sb = StringUtil.borrowBuilder();
        boolean first = true;
        for (Map.Entry<String, String> cookie : this.cookies.entrySet()) {
            if (!first) {
                sb.append("; ");
            } else {
                first = false;
            }
            sb.append(cookie.getKey()).append('=').append(cookie.getValue());
        }
        return StringUtil.releaseBuilder(sb);
    }

    public int retryDelay() {
        return this.retryDelay;
    }

    public int connectTimeout() {
        return this.connectTimeout;
    }

    public int readTimeout() {
        return this.readTimeout;
    }

    public boolean allowAllSSL() {
        return this.allowAllSSL;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public String removeHeader(String key) {
        return this.headers.remove(key);
    }

    public boolean hasHeader(String name) {
        return this.headers.containsKey(name);
    }

    public boolean hasHeaderWithValue(String name, String value) {
        return value.equalsIgnoreCase(this.header(name));
    }

    public String header(String name) {
        return this.headers.get(name);
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public SSLSocketFactory sslSocketFactory() {
        return this.sslSocketFactory;
    }

    public int maxRedirectCount() {
        return this.maxRedirectCount;
    }

    public IHttp.OnRedirectListener getOnRedirectListener() {
        return this.onRedirectListener;
    }

    public CookieJar cookieJar() {
        return this.cookieJar;
    }

    public T baseUrl(String baseUrl) {
        try {
            this.baseUrl = new URI(baseUrl);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            this.baseUrl = null;
        }
        return (T)this;
    }

    public T baseUrl(URI baseUrl) {
        this.baseUrl = baseUrl;
        return (T)this;
    }

    public T debug(boolean debug) {
        this.debug = debug;
        return (T)this;
    }

    public T referer(String referer) {
        if (!TextUtils.isEmpty((CharSequence)referer)) {
            this.headers.put("Referer", referer);
        }
        return (T)this;
    }

    public T contentType(String contentType) {
        if (!TextUtils.isEmpty((CharSequence)contentType)) {
            this.headers.put("Content-Type", contentType);
        }
        return (T)this;
    }

    public T acceptLanguage(String acceptLanguage) {
        if (!TextUtils.isEmpty((CharSequence)acceptLanguage)) {
            this.headers.put("Accept-Language", acceptLanguage);
        }
        return (T)this;
    }

    public T host(String host) {
        if (!TextUtils.isEmpty((CharSequence)host)) {
            this.headers.put("Host", host);
        }
        return (T)this;
    }

    public T accept(String accept) {
        if (!TextUtils.isEmpty((CharSequence)accept)) {
            this.headers.put("Accept", accept);
        }
        return (T)this;
    }

    public T acceptEncoding(String acceptEncoding) {
        if (!TextUtils.isEmpty((CharSequence)acceptEncoding)) {
            this.headers.put("Accept-Encoding", acceptEncoding);
        }
        return (T)this;
    }

    public T connectionMethod(String connection) {
        if (!TextUtils.isEmpty((CharSequence)connection)) {
            this.headers.put("Connection", connection);
        }
        return (T)this;
    }

    public T acceptCharset(String acceptCharset) {
        if (!TextUtils.isEmpty((CharSequence)acceptCharset)) {
            this.headers.put("Accept-Charset", acceptCharset);
        }
        return (T)this;
    }

    public T bufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return (T)this;
    }

    public T maxBodySize(long maxBodySize) {
        this.maxBodySize = maxBodySize;
        return (T)this;
    }

    public T postDataCharset(String charset) {
        if (!TextUtils.isEmpty((CharSequence)charset) && Charset.isSupported(charset)) {
            this.postDataCharset = charset;
        }
        return (T)this;
    }

    public T ignoreHttpErrors(boolean ignoreHttpErrors) {
        this.ignoreHttpErrors = ignoreHttpErrors;
        return (T)this;
    }

    public T ignoreContentType(boolean ignoreContentType) {
        this.ignoreContentType = ignoreContentType;
        return (T)this;
    }

    public T userAgent(String userAgent) {
        this.userAgent = userAgent;
        return (T)this;
    }

    public T retryCount(int retryCount) {
        this.retryCount = retryCount;
        return (T)this;
    }

    public T cookie(String name, String value) {
        if (!TextUtils.isEmpty((CharSequence)name)) {
            this.cookies.put(name, value);
        }
        return (T)this;
    }

    public T cookie(String cookie) {
        if (!TextUtils.isEmpty((CharSequence)cookie)) {
            TokenQueue cd = new TokenQueue(cookie);
            while (!cd.isEmpty()) {
                String cookieName = cd.chompTo("=").trim();
                String cookieVal = cd.consumeTo(";").trim();
                cd.chompTo(";");
                this.cookie(cookieName, cookieVal);
            }
        }
        return (T)this;
    }

    public T cookies(Map<String, String> cookies) {
        this.cookies.clear();
        for (Map.Entry<String, String> entry : cookies.entrySet()) {
            this.cookies.put(entry.getKey(), entry.getValue());
        }
        return (T)this;
    }

    public T retryDelay(int retryDelay) {
        this.retryDelay = retryDelay;
        return (T)this;
    }

    public T connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return (T)this;
    }

    public T readTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return (T)this;
    }

    public T allowAllSSL(boolean allowAllSSL) {
        this.allowAllSSL = allowAllSSL;
        return (T)this;
    }

    public T headers(Map<String, String> headers) {
        this.headers.clear();
        this.headers.putAll(headers);
        return (T)this;
    }

    public T header(String key, String value) {
        this.headers.put(key, value);
        return (T)this;
    }

    public T proxy(Proxy proxy) {
        this.proxy = proxy;
        return (T)this;
    }

    public T proxy(String host, int port) {
        this.proxy = new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(host, port));
        return (T)this;
    }

    public T sslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
        return (T)this;
    }

    public T maxRedirectCount(int maxRedirectCount) {
        if (maxRedirectCount > 0) {
            this.maxRedirectCount = maxRedirectCount;
        }
        return (T)this;
    }

    public T onRedirect(IHttp.OnRedirectListener onRedirectListener) {
        this.onRedirectListener = onRedirectListener;
        return (T)this;
    }

    public T cookieJar(CookieJar cookieJar) {
        this.cookieJar = cookieJar;
        return (T)this;
    }
}

