/*
 * Decompiled with CFR 0.152.
 */
package com.zpj.http.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;

public final class ConstrainableInputStream
extends BufferedInputStream {
    private static final int DefaultSize = 32768;
    private final boolean capped;
    private final long maxSize;
    private long startTime;
    private long timeout = 0L;
    private long remaining;
    private boolean interrupted;

    private ConstrainableInputStream(InputStream in, int bufferSize, long maxSize) {
        super(in, bufferSize);
        if (maxSize < 0L) {
            maxSize = 0L;
        }
        this.maxSize = maxSize;
        this.remaining = maxSize;
        this.capped = maxSize != 0L;
        this.startTime = System.nanoTime();
    }

    public static ConstrainableInputStream wrap(InputStream in, int bufferSize, long maxSize) {
        return in instanceof ConstrainableInputStream ? (ConstrainableInputStream)in : new ConstrainableInputStream(in, bufferSize, maxSize);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.interrupted || this.capped && this.remaining <= 0L) {
            return -1;
        }
        if (Thread.interrupted()) {
            this.interrupted = true;
            return -1;
        }
        if (this.expired()) {
            throw new SocketTimeoutException("Read timeout");
        }
        if (this.capped && (long)len > this.remaining) {
            len = (int)this.remaining;
        }
        try {
            int read = super.read(b, off, len);
            this.remaining -= (long)read;
            return read;
        }
        catch (SocketTimeoutException e) {
            return 0;
        }
    }

    public ByteBuffer readToByteBuffer(long max) throws IOException {
        int read;
        if (max < 0L) {
            max = 0L;
        }
        boolean localCapped = max > 0L;
        int bufferSize = (int)(localCapped && max < 32768L ? max : 32768L);
        byte[] readBuffer = new byte[bufferSize];
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(bufferSize);
        long remaining = max;
        while ((read = this.read(readBuffer)) != -1) {
            if (localCapped) {
                if ((long)read >= remaining) {
                    outStream.write(readBuffer, 0, (int)remaining);
                    break;
                }
                remaining -= (long)read;
            }
            outStream.write(readBuffer, 0, read);
        }
        return ByteBuffer.wrap(outStream.toByteArray());
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.remaining = this.maxSize - (long)this.markpos;
    }

    public ConstrainableInputStream timeout(long startTimeNanos, long timeoutMillis) {
        this.startTime = startTimeNanos;
        this.timeout = timeoutMillis * 1000000L;
        return this;
    }

    private boolean expired() {
        if (this.timeout == 0L) {
            return false;
        }
        long now = System.nanoTime();
        long dur = now - this.startTime;
        return dur > this.timeout;
    }
}

