/*
 * Decompiled with CFR 0.152.
 */
package com.zpj.http.core;

import android.util.Log;
import com.zpj.http.core.ConnectionFactory;
import com.zpj.http.core.HttpConfig;
import com.zpj.http.core.HttpRequest;
import com.zpj.http.core.HttpResponse;
import com.zpj.http.core.IHttp;
import com.zpj.http.core.ResponseInfo;
import com.zpj.http.parser.html.utils.DataUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HttpResponseImpl
extends HttpResponse {
    private HttpURLConnection conn;

    protected HttpResponseImpl(HttpRequest req) {
        super(req);
    }

    @Override
    protected ResponseInfo onExecute(HttpConfig config) throws Exception {
        long length;
        String mimeBoundary = null;
        if (config.method().hasBody()) {
            Log.d((String)"HttpResponse", (String)("onExecute config.method.hasBody()=" + config.method.hasBody()));
            if (config.method.hasBody()) {
                mimeBoundary = this.setOutputContentType();
            }
        }
        this.conn = ConnectionFactory.createConnection(config);
        if (this.conn.getDoOutput()) {
            this.conn.setUseCaches(false);
            this.writePost2(this.conn, mimeBoundary);
        } else {
            this.conn.connect();
        }
        try {
            length = Long.parseLong(this.conn.getHeaderField("Content-Length"));
        }
        catch (Exception ignore) {
            length = this.conn.getContentLength();
        }
        Log.d((String)"onExecute", (String)("length=" + length + " content-length=" + this.conn.getContentLength()));
        Map<String, List<String>> map = this.conn.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            Log.d((String)"onExecute", (String)("key=" + entry.getKey() + " value=" + entry.getValue()));
        }
        return ResponseInfo.build().setStatusCode(this.conn.getResponseCode()).setStatusMessage(this.conn.getResponseMessage()).setContentType(this.conn.getContentType()).setContentLength(length).setHeaders(this.getHeaderMap(this.conn)).onGetBodyStream(new ResponseInfo.Callback(){

            @Override
            public InputStream get() throws Exception {
                return HttpResponseImpl.this.conn.getErrorStream() != null ? HttpResponseImpl.this.conn.getErrorStream() : HttpResponseImpl.this.conn.getInputStream();
            }
        });
    }

    @Override
    public void disconnect() {
        if (this.conn != null) {
            this.conn.disconnect();
            this.conn = null;
        }
    }

    private Map<String, String> getHeaderMap(HttpURLConnection conn) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        int i = 0;
        while (true) {
            String key = conn.getHeaderFieldKey(i);
            String val = conn.getHeaderField(i);
            if (key == null && val == null) break;
            ++i;
            if (key == null || val == null) continue;
            headers.put(key, val);
        }
        return headers;
    }

    private long getTotalBytes(String bound) throws IOException {
        String charset = this.config.postDataCharset();
        byte[] boundaryBytes = ("--" + bound + "\r\n").getBytes(charset);
        byte[] trailerBytes = ("--" + bound + "--").getBytes(charset);
        long total = 0L;
        for (IHttp.KeyVal keyVal : this.config.data()) {
            total += (long)boundaryBytes.length;
            String multipartHeader = "Content-Disposition: form-data; name=\"" + HttpResponseImpl.encodeMimeName(keyVal.key()) + "\"";
            if (keyVal.hasInputStream()) {
                multipartHeader = multipartHeader + "; filename=\"" + HttpResponseImpl.encodeMimeName(keyVal.value()) + "\"\r\nContent-Type: ";
                multipartHeader = multipartHeader + (keyVal.contentType() != null ? keyVal.contentType() : "application/octet-stream");
                multipartHeader = multipartHeader + "\r\n\r\n";
                total += (long)multipartHeader.getBytes(charset).length;
                if (keyVal.inputStream() instanceof FileInputStream) {
                    total += ((FileInputStream)keyVal.inputStream()).getChannel().size();
                } else {
                    int available = keyVal.inputStream().available();
                    if (available < Integer.MAX_VALUE) {
                        total += (long)available;
                    } else {
                        int len;
                        byte[] buf = new byte[524288];
                        while ((len = keyVal.inputStream().read(buf)) > 0) {
                            total += (long)len;
                        }
                    }
                }
            } else {
                multipartHeader = multipartHeader + "\r\n\r\n" + keyVal.value();
                total += (long)multipartHeader.getBytes(charset).length;
            }
            total += (long)"\r\n".getBytes(charset).length;
        }
        Log.d((String)"HttpResponse", (String)("total=" + (total += (long)trailerBytes.length)));
        return total;
    }

    private void writePost2(HttpURLConnection conn, String bound) throws IOException {
        OutputStream w;
        Collection<IHttp.KeyVal> data = this.config.data();
        String charset = this.config.postDataCharset();
        if (bound != null) {
            conn.setFixedLengthStreamingMode(this.getTotalBytes(bound));
            Log.d((String)"HttpResponse", (String)"setFixedLengthStreamingMode finished");
            w = conn.getOutputStream();
            byte[] boundaryBytes = ("--" + bound + "\r\n").getBytes(charset);
            byte[] trailerBytes = ("--" + bound + "--").getBytes(charset);
            for (IHttp.KeyVal keyVal : data) {
                w.write(boundaryBytes);
                String multipartHeader = "Content-Disposition: form-data; name=\"" + HttpResponseImpl.encodeMimeName(keyVal.key()) + "\"";
                if (keyVal.hasInputStream()) {
                    multipartHeader = multipartHeader + "; filename=\"" + HttpResponseImpl.encodeMimeName(keyVal.value()) + "\"\r\nContent-Type: ";
                    multipartHeader = multipartHeader + (keyVal.contentType() != null ? keyVal.contentType() : "application/octet-stream");
                    multipartHeader = multipartHeader + "\r\n\r\n";
                    w.write(multipartHeader.getBytes(charset));
                    Log.d((String)"HttpResponse", (String)"crossStreams");
                    DataUtil.crossStreams(keyVal.inputStream(), w, keyVal.getListener());
                    w.flush();
                } else {
                    multipartHeader = multipartHeader + "\r\n\r\n" + keyVal.value();
                    w.write(multipartHeader.getBytes(charset));
                }
                w.write("\r\n".getBytes(charset));
            }
            w.write(trailerBytes);
        } else if (this.config.requestBody() != null) {
            w = conn.getOutputStream();
            w.write(this.config.requestBody().getBytes(charset));
        } else {
            w = conn.getOutputStream();
            boolean first = true;
            for (IHttp.KeyVal keyVal : data) {
                if (!first) {
                    w.write("&".getBytes(charset));
                } else {
                    first = false;
                }
                w.write(URLEncoder.encode(keyVal.key(), this.config.postDataCharset()).getBytes(charset));
                w.write("=".getBytes(charset));
                w.write(URLEncoder.encode(keyVal.value(), this.config.postDataCharset()).getBytes(charset));
            }
        }
        w.close();
    }

    private static String encodeMimeName(String val) {
        if (val == null) {
            return null;
        }
        return val.replaceAll("\"", "%22");
    }
}

