/*
 * Decompiled with CFR 0.152.
 */
package com.zpj.http.core;

import android.util.Log;
import com.zpj.http.core.HttpConfig;
import com.zpj.http.core.HttpRequest;
import com.zpj.http.core.IHttp;
import com.zpj.http.core.ResponseInfo;
import com.zpj.http.exception.HttpStatusException;
import com.zpj.http.exception.UncheckedIOException;
import com.zpj.http.io.ConstrainableInputStream;
import com.zpj.http.parser.html.utils.DataUtil;
import com.zpj.http.utils.StringUtil;
import com.zpj.http.utils.UrlUtil;
import com.zpj.http.utils.Validate;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public abstract class HttpResponse
implements IHttp.Response {
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String FORM_URL_ENCODED = "application/x-www-form-urlencoded";
    public static final int HTTP_TEMP_REDIR = 307;
    public static final String DefaultUploadType = "application/octet-stream";
    public static final int MAX_REDIRECTS = 20;
    private static final Pattern xmlContentTypeRxp = Pattern.compile("(application|text)/\\w*\\+?xml.*");
    private static final Pattern htmlContentTypeRxp = Pattern.compile("(application|text)/\\w*\\+?html.*");
    protected final HttpRequest req;
    protected final HttpConfig config;
    private ByteBuffer byteData;
    private InputStream bodyStream;
    private int numRedirects = 0;
    protected boolean executed = false;
    private boolean inputStreamRead = false;
    protected String charset;
    private ResponseInfo info;

    protected HttpResponse(HttpRequest req) {
        this.req = req;
        this.config = req.getConfig();
    }

    @Override
    public final IHttp.Response execute() throws Exception {
        Validate.notNull(this.req, "Request must not be null");
        Validate.notNull(this.config.url(), "URL must be specified to connect");
        String protocol = this.config.url().getProtocol();
        if (!protocol.equals("http") && !protocol.equals("https")) {
            throw new MalformedURLException("Only http & https protocols supported");
        }
        boolean methodHasBody = this.config.method().hasBody();
        if (!methodHasBody) {
            this.config.requestBody(null);
        }
        if (this.config.data().size() > 0 && !methodHasBody) {
            UrlUtil.serialiseRequestUrl(this.config);
        }
        long startTime = System.nanoTime();
        try {
            this.info = this.onExecute(this.config);
            Log.d((String)"HttpResponse", (String)("execute info=" + this.info));
            if (this.info.headers.containsKey("Set-Cookie")) {
                this.config.setCookie(this.info.headers.get("Set-Cookie"));
            }
            if (this.hasHeader("Location")) {
                String location = this.header("Location");
                if (location.startsWith("http:/") && location.charAt(6) != '/') {
                    location = location.substring(6);
                }
                if (++this.numRedirects > this.config.maxRedirectCount) {
                    throw new IOException(String.format("Too many redirects occurred trying to load URL %s", this.config.url));
                }
                if (this.config.getOnRedirectListener() == null || this.config.getOnRedirectListener().onRedirect(this.numRedirects, location)) {
                    if (this.statusCode() != 307) {
                        this.config.method(IHttp.Method.GET);
                        this.config.data().clear();
                        this.config.requestBody(null);
                        this.config.removeHeader("Content-Type");
                    }
                    URL redir = StringUtil.resolve(this.config.url(), location);
                    this.config.url(UrlUtil.encodeUrl(redir));
                    this.close();
                    return this.execute();
                }
            }
            if (!(this.statusCode() >= 200 && this.statusCode() < 400 || this.config.ignoreHttpErrors())) {
                throw new HttpStatusException("HTTP error fetching URL", this.statusCode(), this.config.url().toString());
            }
            this.charset = DataUtil.getCharsetFromContentType(this.contentType());
            if (this.contentLength() != 0L && this.config.method != IHttp.Method.HEAD) {
                this.bodyStream = null;
                this.bodyStream = this.info.getBodyStream();
                if (this.hasHeaderWithValue("Content-Encoding", "gzip")) {
                    this.bodyStream = new GZIPInputStream(this.bodyStream);
                } else if (this.hasHeaderWithValue("Content-Encoding", "deflate")) {
                    this.bodyStream = new InflaterInputStream(this.bodyStream, new Inflater(true));
                }
                this.bodyStream = ConstrainableInputStream.wrap(this.bodyStream, 524288, this.config.maxBodySize).timeout(startTime, this.config.connectTimeout + this.config.readTimeout);
            } else {
                this.byteData = DataUtil.emptyByteBuffer();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.close();
            throw e;
        }
        this.executed = true;
        return this;
    }

    @Override
    public String body() {
        this.prepareByteData();
        String body = this.charset == null ? Charset.forName("UTF-8").decode(this.byteData).toString() : Charset.forName(this.charset).decode(this.byteData).toString();
        ((Buffer)this.byteData).rewind();
        return body;
    }

    @Override
    public byte[] bodyAsBytes() {
        this.prepareByteData();
        return this.byteData.array();
    }

    @Override
    public IHttp.Response bufferUp() {
        this.prepareByteData();
        return this;
    }

    @Override
    public BufferedInputStream bodyStream() {
        Validate.isTrue(this.executed, "Request must be executed (with .execute(), .get(), or .post() before getting response body");
        Validate.isFalse(this.inputStreamRead, "Request has already been read");
        this.inputStreamRead = true;
        return ConstrainableInputStream.wrap(this.bodyStream, 524288, this.config.maxBodySize);
    }

    protected abstract ResponseInfo onExecute(HttpConfig var1) throws Exception;

    @Override
    public void close() {
        this.closeIO();
        this.disconnect();
    }

    @Override
    public void closeIO() {
        if (this.bodyStream != null) {
            try {
                this.bodyStream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.bodyStream = null;
            }
        }
    }

    @Override
    public boolean hasHeader(String name) {
        return this.info.headers.containsKey(name);
    }

    @Override
    public boolean hasHeaderWithValue(String name, String value) {
        return value.equalsIgnoreCase(this.header(name));
    }

    @Override
    public String header(String name) {
        return this.info.headers.get(name);
    }

    @Override
    public IHttp.Method method() {
        return this.config.method();
    }

    @Override
    public int statusCode() {
        return this.info.getStatusCode();
    }

    @Override
    public String statusMessage() {
        return this.info.getStatusMessage();
    }

    @Override
    public String charset() {
        return this.charset;
    }

    @Override
    public String contentType() {
        return this.info.getContentType();
    }

    @Override
    public long contentLength() {
        return this.info.getContentLength();
    }

    protected String setOutputContentType() {
        String bound = null;
        if (this.config.hasHeader("Content-Type")) {
            if (this.config.header("Content-Type").contains(MULTIPART_FORM_DATA) && !this.config.header("Content-Type").contains("boundary")) {
                bound = DataUtil.mimeBoundary();
                this.config.header("Content-Type", "multipart/form-data; boundary=" + bound);
            }
        } else if (this.config.needsMultipart()) {
            bound = DataUtil.mimeBoundary();
            this.config.header("Content-Type", "multipart/form-data; boundary=" + bound);
        } else {
            this.config.header("Content-Type", "application/x-www-form-urlencoded; charset=" + this.config.postDataCharset());
        }
        return bound;
    }

    private void prepareByteData() {
        Validate.isTrue(this.executed, "Request must be executed (with .execute(), .get(), or .post() before getting response body");
        if (this.byteData == null) {
            Validate.isFalse(this.inputStreamRead, "Request has already been read (with .parse())");
            try {
                this.byteData = DataUtil.readToByteBuffer(this.bodyStream, this.config.maxBodySize);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.inputStreamRead = true;
                this.close();
            }
        }
    }
}

