/*
 * Decompiled with CFR 0.152.
 */
package com.zpj.http.core;

import com.zpj.http.core.HttpConfig;
import com.zpj.http.core.HttpObserver;
import com.zpj.http.core.HttpResponseImpl;
import com.zpj.http.core.IHttp;
import com.zpj.http.parser.html.nodes.Document;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.annotations.NonNull;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class HttpRequest
implements IHttp.Request {
    protected final HttpConfig config;

    HttpRequest(HttpConfig config) {
        this.config = config;
    }

    public HttpConfig getConfig() {
        return this.config;
    }

    @Override
    public IHttp.Response response() throws Exception {
        return new HttpResponseImpl(this);
    }

    @Override
    public final HttpObserver<IHttp.Response> execute() {
        return new HttpObserver<IHttp.Response>(new ObservableOnSubscribe<IHttp.Response>(){

            public void subscribe(@NonNull ObservableEmitter<IHttp.Response> emitter) throws Exception {
                emitter.onNext((Object)HttpRequest.this.syncExecute());
                emitter.onComplete();
            }
        });
    }

    @Override
    public final HttpObserver<String> toStr() {
        return new HttpObserver<String>(new ObservableOnSubscribe<String>(){

            public void subscribe(@NonNull ObservableEmitter<String> emitter) throws Exception {
                emitter.onNext((Object)HttpRequest.this.syncToStr());
                emitter.onComplete();
            }
        });
    }

    @Override
    public final HttpObserver<Document> toHtml() {
        return new HttpObserver<Document>(new ObservableOnSubscribe<Document>(){

            public void subscribe(@NonNull ObservableEmitter<Document> emitter) throws Exception {
                emitter.onNext((Object)HttpRequest.this.syncToHtml());
                emitter.onComplete();
            }
        });
    }

    @Override
    public final HttpObserver<JSONObject> toJsonObject() {
        return new HttpObserver<JSONObject>(new ObservableOnSubscribe<JSONObject>(){

            public void subscribe(@NonNull ObservableEmitter<JSONObject> emitter) throws Exception {
                emitter.onNext((Object)HttpRequest.this.syncToJsonObject());
                emitter.onComplete();
            }
        });
    }

    @Override
    public final HttpObserver<JSONArray> toJsonArray() {
        return new HttpObserver<JSONArray>(new ObservableOnSubscribe<JSONArray>(){

            public void subscribe(@NonNull ObservableEmitter<JSONArray> emitter) throws Exception {
                emitter.onNext((Object)HttpRequest.this.syncToJsonArray());
                emitter.onComplete();
            }
        });
    }

    @Override
    public final HttpObserver<Document> toXml() {
        return new HttpObserver<Document>(new ObservableOnSubscribe<Document>(){

            public void subscribe(@NonNull ObservableEmitter<Document> emitter) throws Exception {
                emitter.onNext((Object)HttpRequest.this.syncToXml());
                emitter.onComplete();
            }
        });
    }
}

