/*
 * Decompiled with CFR 0.152.
 */
package com.zpj.http.core;

import com.zpj.http.core.Connection;
import com.zpj.http.core.HttpBase;
import com.zpj.http.core.IHttp;
import com.zpj.http.parser.html.Parser;
import com.zpj.http.utils.Validate;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Collection;
import javax.net.ssl.SSLSocketFactory;

public class HttpRequest
extends HttpBase<Connection.Request>
implements Connection.Request {
    public static final String DEFAULT_UA = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.143 Safari/537.36";
    private Proxy proxy;
    private int timeoutMilliseconds = 30000;
    private int maxBodySizeBytes = 0x100000;
    private Collection<Connection.KeyVal> data = new ArrayList<Connection.KeyVal>();
    private String body = null;
    private boolean ignoreHttpErrors = false;
    private boolean ignoreContentType = false;
    private boolean validateTSLCertificates = true;
    private Parser parser;
    private boolean parserDefined = false;
    private String postDataCharset = "UTF-8";
    private SSLSocketFactory sslSocketFactory;
    private IHttp.OnRedirectListener onRedirectListener;

    HttpRequest() {
        this.method = Connection.Method.GET;
        this.addHeader("Accept-Encoding", "gzip");
        this.addHeader("User-Agent", DEFAULT_UA);
        this.parser = Parser.htmlParser();
    }

    @Override
    public Proxy proxy() {
        return this.proxy;
    }

    @Override
    public HttpRequest proxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    @Override
    public HttpRequest proxy(String host, int port) {
        this.proxy = new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(host, port));
        return this;
    }

    @Override
    public int timeout() {
        return this.timeoutMilliseconds;
    }

    @Override
    public HttpRequest timeout(int millis) {
        Validate.isTrue(millis >= 0, "Timeout milliseconds must be 0 (infinite) or greater");
        this.timeoutMilliseconds = millis;
        return this;
    }

    @Override
    public int maxBodySize() {
        return this.maxBodySizeBytes;
    }

    @Override
    public Connection.Request maxBodySize(int bytes) {
        Validate.isTrue(bytes >= 0, "maxSize must be 0 (unlimited) or larger");
        this.maxBodySizeBytes = bytes;
        return this;
    }

    @Override
    public boolean ignoreHttpErrors() {
        return this.ignoreHttpErrors;
    }

    @Override
    public SSLSocketFactory sslSocketFactory() {
        return this.sslSocketFactory;
    }

    @Override
    public void sslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    @Override
    public Connection.Request ignoreHttpErrors(boolean ignoreHttpErrors) {
        this.ignoreHttpErrors = ignoreHttpErrors;
        return this;
    }

    @Override
    public boolean ignoreContentType() {
        return this.ignoreContentType;
    }

    @Override
    public Connection.Request ignoreContentType(boolean ignoreContentType) {
        this.ignoreContentType = ignoreContentType;
        return this;
    }

    @Override
    public boolean validateTLSCertificates() {
        return this.validateTSLCertificates;
    }

    @Override
    public void validateTLSCertificates(boolean value) {
        this.validateTSLCertificates = value;
    }

    @Override
    public HttpRequest data(Connection.KeyVal keyval) {
        Validate.notNull(keyval, "Key val must not be null");
        this.data.add(keyval);
        return this;
    }

    @Override
    public Collection<Connection.KeyVal> data() {
        return this.data;
    }

    @Override
    public Connection.Request requestBody(String body) {
        this.body = body;
        return this;
    }

    @Override
    public String requestBody() {
        return this.body;
    }

    @Override
    public HttpRequest parser(Parser parser) {
        this.parser = parser;
        this.parserDefined = true;
        return this;
    }

    @Override
    public Parser parser() {
        return this.parser;
    }

    @Override
    public Connection.Request postDataCharset(String charset) {
        Validate.notNull(charset, "Charset must not be null");
        if (!Charset.isSupported(charset)) {
            throw new IllegalCharsetNameException(charset);
        }
        this.postDataCharset = charset;
        return this;
    }

    @Override
    public String postDataCharset() {
        return this.postDataCharset;
    }

    @Override
    public Connection.Request onRedirect(IHttp.OnRedirectListener listener) {
        this.onRedirectListener = listener;
        return this;
    }

    @Override
    public IHttp.OnRedirectListener getOnRedirectListener() {
        return this.onRedirectListener;
    }

    public boolean isParserDefined() {
        return this.parserDefined;
    }
}

