/*
 * Decompiled with CFR 0.152.
 */
package com.zpj.http.core;

import com.zpj.http.core.Connection;
import com.zpj.http.core.IHttp;
import com.zpj.http.utils.Validate;
import java.io.InputStream;

public class HttpKeyVal
implements Connection.KeyVal {
    private String key;
    private String value;
    private InputStream stream;
    private String contentType;
    private IHttp.OnStreamWriteListener listener;

    public static HttpKeyVal create(String key, String value) {
        return new HttpKeyVal().key(key).value(value);
    }

    public static HttpKeyVal create(String key, String filename, InputStream stream) {
        return new HttpKeyVal().key(key).value(filename).inputStream(stream);
    }

    public static HttpKeyVal create(String key, String filename, InputStream stream, IHttp.OnStreamWriteListener listener) {
        return new HttpKeyVal().key(key).value(filename).inputStream(stream).setListener(listener);
    }

    private HttpKeyVal() {
    }

    @Override
    public HttpKeyVal key(String key) {
        Validate.notEmpty(key, "Data key must not be empty");
        this.key = key;
        return this;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public HttpKeyVal value(String value) {
        Validate.notNull(value, "Data value must not be null");
        this.value = value;
        return this;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public HttpKeyVal inputStream(InputStream inputStream) {
        Validate.notNull(this.value, "Data input stream must not be null");
        this.stream = inputStream;
        return this;
    }

    @Override
    public InputStream inputStream() {
        return this.stream;
    }

    @Override
    public boolean hasInputStream() {
        return this.stream != null;
    }

    @Override
    public Connection.KeyVal contentType(String contentType) {
        Validate.notEmpty(contentType);
        this.contentType = contentType;
        return this;
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public IHttp.OnStreamWriteListener getListener() {
        return this.listener;
    }

    @Override
    public HttpKeyVal setListener(IHttp.OnStreamWriteListener listener) {
        this.listener = listener;
        return this;
    }

    public String toString() {
        return this.key + "=" + this.value;
    }
}

