/*
 * Decompiled with CFR 0.152.
 */
package com.zpj.http.core;

import android.text.TextUtils;
import com.zpj.http.core.Connection;
import com.zpj.http.core.HttpKeyVal;
import com.zpj.http.core.IHttp;
import com.zpj.http.core.ObservableTask;
import com.zpj.http.parser.html.Parser;
import com.zpj.http.parser.html.nodes.Document;
import com.zpj.http.utils.UrlUtil;
import com.zpj.http.utils.Validate;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractConnection
implements Connection {
    protected final Connection.Request req = this.createRequest();
    protected Connection.Response res;

    @Override
    public Connection url(URL url) {
        this.req.url(url);
        return this;
    }

    @Override
    public Connection url(String url) {
        Validate.notEmpty(url, "Must supply a valid URL");
        try {
            this.req.url(new URL(UrlUtil.encodeUrl(url)));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed URL: " + url, e);
        }
        return this;
    }

    @Override
    public Connection proxy(Proxy proxy) {
        this.req.proxy(proxy);
        return this;
    }

    @Override
    public Connection proxy(String host, int port) {
        this.req.proxy(host, port);
        return this;
    }

    @Override
    public Connection timeout(int millis) {
        this.req.timeout(millis);
        return this;
    }

    @Override
    public Connection maxBodySize(int bytes) {
        this.req.maxBodySize(bytes);
        return this;
    }

    @Override
    public Connection method(Connection.Method method) {
        this.req.method(method);
        return this;
    }

    @Override
    public Connection ignoreHttpErrors(boolean ignoreHttpErrors) {
        this.req.ignoreHttpErrors(ignoreHttpErrors);
        return this;
    }

    @Override
    public Connection ignoreContentType(boolean ignoreContentType) {
        this.req.ignoreContentType(ignoreContentType);
        return this;
    }

    @Override
    public Connection validateTLSCertificates(boolean value) {
        this.req.validateTLSCertificates(value);
        return this;
    }

    @Override
    public Connection data(String key, String value) {
        this.req.data(HttpKeyVal.create(key, value));
        return this;
    }

    @Override
    public Connection sslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.req.sslSocketFactory(sslSocketFactory);
        return this;
    }

    @Override
    public Connection data(String key, String filename, InputStream inputStream) {
        this.req.data(HttpKeyVal.create(key, filename, inputStream));
        return this;
    }

    @Override
    public Connection data(String key, String filename, InputStream inputStream, IHttp.OnStreamWriteListener listener) {
        this.req.data(HttpKeyVal.create(key, filename, inputStream, listener));
        return this;
    }

    @Override
    public Connection data(String key, String filename, InputStream inputStream, String contentType) {
        this.req.data(HttpKeyVal.create(key, filename, inputStream).contentType(contentType));
        return this;
    }

    @Override
    public Connection data(Map<String, String> data) {
        Validate.notNull(data, "Data map must not be null");
        for (Map.Entry<String, String> entry : data.entrySet()) {
            this.req.data(HttpKeyVal.create(entry.getKey(), entry.getValue()));
        }
        return this;
    }

    @Override
    public Connection data(String ... keyvals) {
        Validate.notNull(keyvals, "Data key value pairs must not be null");
        Validate.isTrue(keyvals.length % 2 == 0, "Must supply an even number of key value pairs");
        for (int i = 0; i < keyvals.length; i += 2) {
            String key = keyvals[i];
            String value = keyvals[i + 1];
            Validate.notEmpty(key, "Data key must not be empty");
            Validate.notNull(value, "Data value must not be null");
            this.req.data(HttpKeyVal.create(key, value));
        }
        return this;
    }

    @Override
    public Connection data(Collection<Connection.KeyVal> data) {
        Validate.notNull(data, "Data collection must not be null");
        for (Connection.KeyVal entry : data) {
            this.req.data(entry);
        }
        return this;
    }

    @Override
    public Connection.KeyVal data(String key) {
        Validate.notEmpty(key, "Data key must not be empty");
        for (Connection.KeyVal keyVal : this.request().data()) {
            if (!keyVal.key().equals(key)) continue;
            return keyVal;
        }
        return null;
    }

    @Override
    public Connection requestBody(String body) {
        this.req.requestBody(body);
        return this;
    }

    @Override
    public Connection header(String name, String value) {
        this.req.header(name, value);
        return this;
    }

    @Override
    public Connection headers(Map<String, String> headers) {
        Validate.notNull(headers, "Header map must not be null");
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.req.header(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public Connection cookie(String cookie) {
        Validate.notNull(cookie, "Cookie must not be null");
        this.req.header("Cookie", cookie);
        return this;
    }

    @Override
    public Connection cookie(String name, String value) {
        this.req.cookie(name, value);
        return this;
    }

    @Override
    public Connection cookies(Map<String, String> cookies) {
        Validate.notNull(cookies, "Cookie map must not be null");
        for (Map.Entry<String, String> entry : cookies.entrySet()) {
            this.req.cookie(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public Connection parser(Parser parser) {
        this.req.parser(parser);
        return this;
    }

    @Override
    public Connection postDataCharset(String charset) {
        this.req.postDataCharset(charset);
        return this;
    }

    @Override
    public Connection.Request request() {
        return this.req;
    }

    @Override
    public Connection.Response response() {
        return this.res;
    }

    @Override
    public Connection.Response syncExecute() throws IOException {
        return this.onExecute();
    }

    @Override
    public String syncToStr() throws IOException {
        this.res = this.onExecute();
        return this.res.body();
    }

    @Override
    public Document syncToHtml() throws IOException {
        this.res = this.onExecute();
        return this.res.parse();
    }

    @Override
    public JSONObject syncToJsonObject() throws IOException, JSONException {
        this.res = this.onExecute();
        return new JSONObject(this.res.body());
    }

    @Override
    public JSONArray syncToJsonArray() throws IOException, JSONException {
        this.res = this.onExecute();
        return new JSONArray(this.res.body());
    }

    @Override
    public Document syncToXml() throws IOException {
        this.res = this.onExecute();
        return this.res.parse();
    }

    @Override
    public final ObservableTask<Connection.Response> execute() {
        Observable observable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Connection.Response>(){

            public void subscribe(ObservableEmitter<Connection.Response> emitter) throws Exception {
                AbstractConnection.this.res = AbstractConnection.this.onExecute();
                emitter.onNext((Object)AbstractConnection.this.res);
                emitter.onComplete();
            }
        });
        return new ObservableTask<Connection.Response>(observable);
    }

    @Override
    public final ObservableTask<String> toStr() {
        Observable observable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

            public void subscribe(ObservableEmitter<String> emitter) throws Exception {
                AbstractConnection.this.res = AbstractConnection.this.onExecute();
                emitter.onNext((Object)AbstractConnection.this.res.body());
                emitter.onComplete();
            }
        });
        return new ObservableTask<String>(observable);
    }

    @Override
    public final ObservableTask<Document> toHtml() {
        Observable observable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Document>(){

            public void subscribe(ObservableEmitter<Document> emitter) throws Exception {
                AbstractConnection.this.res = AbstractConnection.this.onExecute();
                Document doc = AbstractConnection.this.res.parse();
                emitter.onNext((Object)doc);
                emitter.onComplete();
            }
        });
        return new ObservableTask<Document>(observable);
    }

    @Override
    public final ObservableTask<JSONObject> toJsonObject() {
        Observable observable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<JSONObject>(){

            public void subscribe(ObservableEmitter<JSONObject> emitter) throws Exception {
                AbstractConnection.this.res = AbstractConnection.this.onExecute();
                JSONObject jsonArray = new JSONObject(AbstractConnection.this.res.body());
                emitter.onNext((Object)jsonArray);
                emitter.onComplete();
            }
        });
        return new ObservableTask<JSONObject>(observable);
    }

    @Override
    public final ObservableTask<JSONArray> toJsonArray() {
        Observable observable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<JSONArray>(){

            public void subscribe(ObservableEmitter<JSONArray> emitter) throws Exception {
                AbstractConnection.this.res = AbstractConnection.this.onExecute();
                JSONArray jsonArray = new JSONArray(AbstractConnection.this.res.body());
                emitter.onNext((Object)jsonArray);
                emitter.onComplete();
            }
        });
        return new ObservableTask<JSONArray>(observable);
    }

    @Override
    public final ObservableTask<Document> toXml() {
        Observable observable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Document>(){

            public void subscribe(ObservableEmitter<Document> emitter) throws Exception {
                AbstractConnection.this.res = AbstractConnection.this.onExecute();
                Document doc = AbstractConnection.this.res.parse();
                emitter.onNext((Object)doc);
                emitter.onComplete();
            }
        });
        return new ObservableTask<Document>(observable);
    }

    @Override
    public final Connection onRedirect(IHttp.OnRedirectListener listener) {
        this.req.onRedirect(listener);
        return this;
    }

    @Override
    public Connection userAgent(String userAgent) {
        if (!TextUtils.isEmpty((CharSequence)userAgent)) {
            this.req.header("User-Agent", userAgent);
        }
        return this;
    }

    @Override
    public Connection referer(String referer) {
        if (!TextUtils.isEmpty((CharSequence)referer)) {
            this.req.header("Referer", referer);
        }
        return this;
    }

    @Override
    public Connection contentType(String contentType) {
        if (!TextUtils.isEmpty((CharSequence)contentType)) {
            this.req.header("Content-Type", contentType);
        }
        return this;
    }

    @Override
    public Connection acceptLanguage(String acceptLanguage) {
        if (!TextUtils.isEmpty((CharSequence)acceptLanguage)) {
            this.req.header("Accept-Language", acceptLanguage);
        }
        return this;
    }

    @Override
    public Connection host(String host) {
        if (!TextUtils.isEmpty((CharSequence)host)) {
            this.req.header("Host", host);
        }
        return this;
    }

    @Override
    public Connection accept(String accept) {
        if (!TextUtils.isEmpty((CharSequence)accept)) {
            this.req.header("Accept", accept);
        }
        return this;
    }

    @Override
    public Connection acceptEncoding(String acceptEncoding) {
        if (!TextUtils.isEmpty((CharSequence)acceptEncoding)) {
            this.req.header("Accept-Encoding", acceptEncoding);
        }
        return this;
    }

    @Override
    public Connection connection(String connection) {
        if (!TextUtils.isEmpty((CharSequence)connection)) {
            this.req.header("Connection", connection);
        }
        return this;
    }

    @Override
    public Connection range(String range) {
        if (!TextUtils.isEmpty((CharSequence)range)) {
            this.req.header("Range", range);
        }
        return this;
    }

    @Override
    public Connection contentLength(String contentLength) {
        if (!TextUtils.isEmpty((CharSequence)contentLength)) {
            this.req.header("Content-Length", contentLength);
        }
        return this;
    }

    @Override
    public Connection contentMD5(String contentMD5) {
        if (!TextUtils.isEmpty((CharSequence)contentMD5)) {
            this.req.header("Content-MD5", contentMD5);
        }
        return this;
    }

    @Override
    public Connection from(String from) {
        if (!TextUtils.isEmpty((CharSequence)from)) {
            this.req.header("From", from);
        }
        return this;
    }

    @Override
    public Connection xRequestedWith(String xRequestedWith) {
        if (!TextUtils.isEmpty((CharSequence)xRequestedWith)) {
            this.req.header("X-Requested-With", xRequestedWith);
        }
        return this;
    }

    @Override
    public Connection acceptCharset(String acceptCharset) {
        if (!TextUtils.isEmpty((CharSequence)acceptCharset)) {
            this.req.header("Accept-Charset", acceptCharset);
        }
        return this;
    }

    public abstract Connection.Request createRequest();

    public abstract Connection.Response onExecute() throws IOException;
}

