/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.media_thumbnail;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.FormatUtils;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.layout.ChBorderLayout;
import com.zoyi.channel.plugin.android.view.video_player.AbsVideoPlayerView;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.zoyi.com.bumptech.glide.load.resource.drawable.GlideDrawable;
import com.zoyi.com.bumptech.glide.request.animation.GlideAnimation;
import com.zoyi.com.bumptech.glide.request.target.SimpleTarget;
import com.zoyi.com.bumptech.glide.request.target.Target;

public abstract class MediaThumbnailView
extends ChBorderLayout {
    private Context context;
    private View viewPlayerController;
    private View layoutMediaThumbnailPreview;
    private ImageView imageMediaThumbnail;
    private View layoutPlaceholder;
    private View imagePlaceholder;
    private FrameLayout layoutMediaThumbnailVideos;
    private View viewPlayerDuration;
    private TextView textPlayerDuration;

    public MediaThumbnailView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public MediaThumbnailView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public MediaThumbnailView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(@NonNull Context context) {
        this.context = context;
        LayoutInflater.from((Context)context).inflate(R.layout.ch_view_media_thumbnail, (ViewGroup)this);
        this.viewPlayerController = this.findViewById(R.id.ch_viewPlayerController);
        this.layoutMediaThumbnailPreview = this.findViewById(R.id.ch_layoutMediaThumbnailPreview);
        this.imageMediaThumbnail = (ImageView)this.findViewById(R.id.ch_imageMediaThumbnail);
        this.layoutPlaceholder = this.findViewById(R.id.ch_layoutPlaceholder);
        this.imagePlaceholder = this.findViewById(R.id.ch_imagePlaceholder);
        this.layoutMediaThumbnailVideos = (FrameLayout)this.findViewById(R.id.ch_layoutMediaThumbnailVideos);
        this.viewPlayerDuration = this.findViewById(R.id.ch_viewPlayerDuration);
        this.textPlayerDuration = (TextView)this.findViewById(R.id.ch_textPlayerDuration);
        this.viewPlayerController.setOnClickListener(v -> this.onPlayClick());
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
        this.layoutMediaThumbnailPreview.setOnClickListener(l);
        this.imageMediaThumbnail.setOnClickListener(l);
        this.layoutPlaceholder.setOnClickListener(l);
    }

    public void setOnLongClickListener(@Nullable View.OnLongClickListener l) {
        this.viewPlayerController.setOnLongClickListener(l);
        this.layoutMediaThumbnailPreview.setOnLongClickListener(l);
        this.imageMediaThumbnail.setOnLongClickListener(l);
        this.layoutPlaceholder.setOnLongClickListener(l);
    }

    protected void setImage(@Nullable String url) {
        this.setImage(url, ImageView.ScaleType.CENTER_CROP);
    }

    protected void setImage(@Nullable String url, ImageView.ScaleType scaleType) {
        this.imageMediaThumbnail.setScaleType(scaleType);
        try {
            Glide.with((Context)this.context).load(url).diskCacheStrategy(DiskCacheStrategy.SOURCE).into((Target)new SimpleTarget<GlideDrawable>(){

                public void onResourceReady(GlideDrawable glideDrawable, GlideAnimation<? super GlideDrawable> glideAnimation) {
                    MediaThumbnailView.this.layoutPlaceholder.setVisibility(8);
                    MediaThumbnailView.this.imageMediaThumbnail.setVisibility(0);
                    MediaThumbnailView.this.imageMediaThumbnail.setImageDrawable((Drawable)glideDrawable);
                }

                public void onLoadFailed(Exception e, Drawable errorDrawable) {
                    MediaThumbnailView.this.imagePlaceholder.animate().alpha(1.0f).setDuration(200L).start();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setImage(@Nullable String url, int width, int height) {
        try {
            Glide.with((Context)this.context).load(url).centerCrop().override(width, height).diskCacheStrategy(DiskCacheStrategy.SOURCE).into((Target)new SimpleTarget<GlideDrawable>(){

                public void onResourceReady(GlideDrawable glideDrawable, GlideAnimation<? super GlideDrawable> glideAnimation) {
                    MediaThumbnailView.this.layoutPlaceholder.setVisibility(8);
                    MediaThumbnailView.this.imageMediaThumbnail.setVisibility(0);
                    MediaThumbnailView.this.imageMediaThumbnail.setImageDrawable((Drawable)glideDrawable);
                }

                public void onLoadFailed(Exception e, Drawable errorDrawable) {
                    MediaThumbnailView.this.imagePlaceholder.animate().alpha(1.0f).setDuration(200L).start();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected <E extends AbsVideoPlayerView> E appendVideoView(E view) {
        if (this.layoutMediaThumbnailVideos != null && this.layoutMediaThumbnailVideos.getChildCount() == 0 && view != null) {
            this.layoutMediaThumbnailVideos.setVisibility(0);
            this.layoutMediaThumbnailVideos.addView(view);
        }
        return view;
    }

    protected void activatePlayButton() {
        this.viewPlayerController.setVisibility(0);
    }

    protected void activateDuration(@Nullable Double duration) {
        Long durationMilliseconds = duration != null ? Long.valueOf(duration.longValue()) : null;
        String formattedDuration = FormatUtils.formatDuration(durationMilliseconds);
        if (formattedDuration != null && this.viewPlayerDuration != null) {
            this.viewPlayerDuration.setVisibility(0);
            this.textPlayerDuration.setText((CharSequence)formattedDuration);
        } else if (this.viewPlayerDuration != null) {
            this.viewPlayerDuration.setVisibility(8);
        }
    }

    public void onPlayClick() {
        this.layoutPlaceholder.setVisibility(8);
        this.layoutMediaThumbnailPreview.setVisibility(4);
        this.viewPlayerController.setVisibility(8);
        this.viewPlayerDuration.setVisibility(8);
    }

    public void setThumbnailBackground(int colorId) {
        if (this.layoutMediaThumbnailVideos != null) {
            this.layoutMediaThumbnailVideos.setBackgroundColor(colorId);
        }
        if (this.layoutMediaThumbnailPreview != null) {
            this.layoutMediaThumbnailPreview.setBackgroundColor(colorId);
        }
        if (this.layoutPlaceholder != null) {
            this.layoutPlaceholder.setBackgroundColor(colorId);
        }
    }

    public void clear() {
        if (this.layoutMediaThumbnailPreview != null) {
            this.layoutMediaThumbnailPreview.setVisibility(0);
        }
        if (this.layoutPlaceholder != null) {
            this.layoutPlaceholder.setVisibility(0);
        }
        if (this.imagePlaceholder != null) {
            this.imagePlaceholder.animate().alpha(0.0f).setDuration(0L).start();
        }
        if (this.imageMediaThumbnail != null) {
            this.imageMediaThumbnail.setVisibility(4);
            Glide.clear((View)this.imageMediaThumbnail);
        }
        if (this.layoutMediaThumbnailVideos != null) {
            for (int i = 0; i < this.layoutMediaThumbnailVideos.getChildCount(); ++i) {
                View child = this.layoutMediaThumbnailVideos.getChildAt(i);
                if (!(child instanceof AbsVideoPlayerView)) continue;
                ((AbsVideoPlayerView)child).clear();
            }
            this.layoutMediaThumbnailVideos.removeAllViews();
            this.layoutMediaThumbnailVideos.setVisibility(8);
        }
        if (this.viewPlayerController != null) {
            this.viewPlayerController.setVisibility(8);
        }
        if (this.viewPlayerDuration != null) {
            this.viewPlayerDuration.setVisibility(8);
        }
    }
}

