/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.util.ContextUtils;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.layout.ChBorderLayout;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;

public class AvatarLayout
extends FrameLayout {
    private ChBorderLayout rootLayout;
    private ImageView image;
    private Float borderRadius = Float.valueOf(0.0f);
    private boolean clearOnDetach = true;

    public AvatarLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public AvatarLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AvatarLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public AvatarLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Initializer
    protected void init(Context context, @Nullable AttributeSet attrs) {
        View root = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_layout_avatar, (ViewGroup)this);
        this.rootLayout = (ChBorderLayout)root.findViewById(R.id.ch_rootAvatarLayout);
        this.image = (ImageView)root.findViewById(R.id.ch_imageAvatar);
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.AvatarLayout, 0, 0);
            try {
                this.borderRadius = Float.valueOf(typedArray.getDimension(R.styleable.AvatarLayout_ch_avatar_border_radius, this.borderRadius.floatValue()));
                this.clearOnDetach = typedArray.getBoolean(R.styleable.AvatarLayout_ch_clear_on_detach, this.clearOnDetach);
            }
            finally {
                typedArray.recycle();
            }
        }
        this.rootLayout.setBorderRadius(this.borderRadius);
    }

    public void set(@Nullable ProfileEntity entity) {
        if (entity == null || entity.getAvatarUrl() == null) {
            this.image.setImageResource(R.drawable.ch_unknown);
        } else {
            Activity activity = ContextUtils.getActivity(this.getContext());
            if (activity != null && !activity.isFinishing()) {
                Glide.with((Activity)activity).load(entity.getAvatarUrl()).centerCrop().dontAnimate().diskCacheStrategy(DiskCacheStrategy.RESULT).into(this.image);
            }
        }
    }

    protected void onDetachedFromWindow() {
        if (this.clearOnDetach) {
            Glide.clear((View)this.image);
        }
        super.onDetachedFromWindow();
    }
}

