/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.integrations.instagram;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatImageView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.media.instagram.InstagramData;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.integrations.instagram.OnInstagramThumbnailClickListener;
import com.zoyi.com.bumptech.glide.Glide;

public class InstagramPreviewItemView
extends FrameLayout {
    private AppCompatImageView borderView;

    public InstagramPreviewItemView(@NonNull Context context, InstagramData data, OnInstagramThumbnailClickListener listener) {
        super(context);
        this.init(context, data, listener);
    }

    @Initializer
    private void init(Context context, InstagramData data, OnInstagramThumbnailClickListener listener) {
        LayoutInflater.from((Context)context).inflate(R.layout.ch_view_integration_instagram_preview_item, (ViewGroup)this);
        this.borderView = (AppCompatImageView)this.findViewById(R.id.ch_imageInstagramPreviewBorder);
        ImageView imageView = (ImageView)this.findViewById(R.id.ch_imageInstagramPreviewItem);
        ImageView iconAlbum = (ImageView)this.findViewById(R.id.ch_iconInstagramAlbum);
        ImageView iconVideo = (ImageView)this.findViewById(R.id.ch_iconInstagramVideo);
        switch (data.getMediaType()) {
            case "IMAGE": {
                this.setImage(imageView, data.getMediaUrl());
                break;
            }
            case "CAROUSEL_ALBUM": {
                this.setImage(imageView, data.getMediaUrl());
                iconAlbum.setVisibility(0);
                break;
            }
            case "VIDEO": {
                this.setImage(imageView, data.getThumbnailUrl());
                iconVideo.setVisibility(0);
            }
        }
        this.setOnClickListener(v -> listener.onDataClick(data, ((ViewGroup)v.getParent()).indexOfChild(v)));
    }

    public void setBorder(boolean visible) {
        if (this.borderView != null) {
            this.borderView.setVisibility(visible ? 0 : 8);
        }
    }

    private void setImage(ImageView imageView, @Nullable String imageUrl) {
        if (imageUrl != null) {
            Glide.with((Context)this.getContext()).load(imageUrl).centerCrop().into(imageView);
        }
    }
}

