/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.integrations.instagram;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.media.instagram.InstagramMediaEntity;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.view.media_thumbnail.MediaThumbnailView;
import com.zoyi.channel.plugin.android.view.video_player.InstagramVideoView;

public class InstagramMediaView
extends MediaThumbnailView {
    private Context context;
    @Nullable
    private InstagramVideoView videoView;

    public InstagramMediaView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public InstagramMediaView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public InstagramMediaView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        this.context = context;
        this.setThumbnailBackground(ResUtils.getColor(R.color.ch_grey900));
    }

    public void setData(InstagramMediaEntity data, boolean isVolumeOn) {
        if ("VIDEO".equals(data.getMediaType())) {
            if (data.getThumbnailUrl() != null) {
                super.onPlayClick();
                this.videoView = this.appendVideoView(new InstagramVideoView(this.context).setData(data, isVolumeOn));
            }
        } else if (data.getThumbnailUrl() != null) {
            this.setImage(data.getThumbnailUrl(), ImageView.ScaleType.FIT_CENTER);
        } else if (data.getMediaUrl() != null) {
            this.setImage(data.getMediaUrl(), ImageView.ScaleType.FIT_CENTER);
        }
    }

    public void onActive() {
        if (this.videoView != null) {
            this.videoView.onActive();
        }
    }

    public void onDeactive() {
        if (this.videoView != null) {
            this.videoView.onDeactivate();
        }
    }

    public void changeVideoVolumeState(boolean isVolumeOn) {
        if (this.videoView != null) {
            this.videoView.applyVolumeButton(isVolumeOn);
        }
    }
}

