/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.coordinator;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.widget.NestedScrollView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.zoyi.channel.plugin.android.view.coordinator.OnScrollPositionChangedListener;

public class PaddingNestedScrollView
extends NestedScrollView {
    @Nullable
    private OnScrollPositionChangedListener listener;

    public PaddingNestedScrollView(@NonNull Context context) {
        super(context);
    }

    public PaddingNestedScrollView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public PaddingNestedScrollView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setListener(@Nullable OnScrollPositionChangedListener listener) {
        this.listener = listener;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        int y = (int)ev.getY();
        if (y < this.getPaddingTop() - this.getScrollY()) {
            switch (ev.getAction()) {
                case 0: {
                    return false;
                }
            }
        }
        return super.onTouchEvent(ev);
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (this.listener != null) {
            this.listener.onScrollPositionChange(t);
        }
    }
}

