/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.button;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.selector.PluginSelector;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.rx.functions.Action1;

public class ChatStartButton
extends CardView
implements View.OnClickListener {
    private View background;
    private ImageView iconButton;
    private TextView textButton;
    @Nullable
    private View.OnClickListener listener;
    private int backColor = -16777216;
    private int textColor = -1;
    @Nullable
    private Binder styleBinder;
    @Nullable
    private Binder activeBinder;

    public ChatStartButton(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public ChatStartButton(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ChatStartButton(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_chat_start, (ViewGroup)this, true);
        this.background = view.findViewById(R.id.ch_layoutChatStartButton);
        this.iconButton = (ImageView)view.findViewById(R.id.ch_imageChatStartButton);
        this.textButton = (TextView)view.findViewById(R.id.ch_textChatStartButton);
        view.findViewById(R.id.ch_cardChatStartButton).setOnClickListener((View.OnClickListener)this);
        if (Build.VERSION.SDK_INT < 21) {
            this.getBackground().setAlpha(0);
        } else {
            this.setBackgroundColor(ContextCompat.getColor((Context)context, (int)17170445));
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.styleBinder = PluginSelector.bindPlugin((Action1<Plugin>)((Action1)plugin -> {
            if (plugin != null) {
                if (plugin.getTextColor() == -1) {
                    this.setTheme(plugin.getBackgroundColor(), -1);
                } else {
                    this.setTheme(plugin.getBackgroundColor(), ResUtils.getColor(R.color.ch_grey900));
                }
            }
        }));
        this.activeBinder = ChannelSelector.bindDisableStartChat((Action1<Boolean>)((Action1)disabled -> this.setEnabled(disabled == false)));
    }

    protected void onDetachedFromWindow() {
        if (this.styleBinder != null) {
            this.styleBinder.unbind();
        }
        if (this.activeBinder != null) {
            this.activeBinder.unbind();
        }
        super.onDetachedFromWindow();
    }

    public void setOnClickListener(@Nullable View.OnClickListener listener) {
        this.listener = listener;
    }

    public void onClick(View v) {
        if (this.listener != null && this.isEnabled()) {
            this.listener.onClick(v);
        }
    }

    private void setTheme(int backColor, int textColor) {
        this.backColor = backColor;
        this.textColor = textColor;
        this.applyTheme();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.applyTheme();
    }

    private void applyTheme() {
        if (this.isEnabled()) {
            this.background.setBackgroundColor(this.backColor);
            this.iconButton.setColorFilter(this.textColor);
            this.textButton.setTextColor(this.textColor);
            this.setCardElevation(Utils.dpToPx(4.0f));
        } else {
            this.background.setBackgroundColor(ResUtils.getColor(R.color.ch_grey200));
            this.iconButton.setColorFilter(ResUtils.getColor(R.color.ch_grey500));
            this.textButton.setTextColor(ResUtils.getColor(R.color.ch_grey500));
            this.setCardElevation(0.0f);
        }
    }
}

