/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.socket;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.SocketStatus;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.global.RxBus;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.rest.Bot;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.store.BotStore;
import com.zoyi.channel.plugin.android.store.ChannelStore;
import com.zoyi.channel.plugin.android.store.GlobalStore;
import com.zoyi.channel.plugin.android.store.ManagerStore;
import com.zoyi.channel.plugin.android.store.PopupStore;
import com.zoyi.channel.plugin.android.store.ProfileBotStore;
import com.zoyi.channel.plugin.android.store.SocketStore;
import com.zoyi.channel.plugin.android.store.TypingStore;
import com.zoyi.channel.plugin.android.store.UserChatStore;
import com.zoyi.channel.plugin.android.store.UserStore;
import com.zoyi.channel.plugin.android.util.ChannelUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.ParseUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.draw.Display;
import com.zoyi.channel.plugin.android.util.lang.StringUtils;
import com.zoyi.com.google.gson.Gson;
import com.zoyi.io.socket.client.IO;
import com.zoyi.io.socket.client.Socket;
import com.zoyi.io.socket.client.SocketIOException;
import com.zoyi.io.socket.emitter.Emitter;
import com.zoyi.io.socket.engineio.client.EngineIOException;
import com.zoyi.rx.Emitter;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.subjects.PublishSubject;
import java.net.URISyntaxException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONException;
import org.json.JSONObject;

public class SocketManager {
    private static SocketManager socketManager;
    private Application application;
    private Socket socket;
    private Timer reconnectConsumer;
    private AtomicBoolean forceDisconnect;
    private AtomicBoolean ready;
    private AtomicBoolean error;
    private Subscription heartbeat;
    private BlockingQueue<Integer> reconnectQueue;
    private int[] attemptDelay = new int[]{5, 8, 13, 21, 34, 55, 89};
    private AtomicInteger attemptCount = new AtomicInteger();
    private ConcurrentHashMap<String, Boolean> chatRoomMap = new ConcurrentHashMap();
    private static final int HEARTBEAT_INTERVAL = 30000;
    private static final int RECONNECT_POP_INTERVAL = 500;
    @Deprecated
    private static PublishSubject<String> chatJoinedPublishSubject;
    private String channelId;
    private Emitter.Listener onTyping = objects -> {
        L.d("onTyping: " + objects[0].toString());
        Typing typing = this.parseJson(objects[0].toString(), Typing.class);
        if (typing != null) {
            typing.setCreatedAt(TimeUtils.getCurrentTime());
            if ("start".equals(typing.getAction())) {
                TypingStore.get().hostTypingState.upsert(typing);
            } else if ("stop".equals(typing.getAction())) {
                TypingStore.get().hostTypingState.remove(typing);
            }
        }
    };
    private Emitter.Listener onConnect = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onConnect: ");
            try {
                SocketManager.this.error.set(false);
                SocketManager.this.forceDisconnect.set(false);
                SocketManager.this.attemptCount.set(0);
                SocketManager.this.authentication();
            }
            catch (Exception ex) {
                L.e(ex.getMessage());
            }
        }
    };
    private Emitter.Listener onConnectTimeout = objects -> {
        L.d("onConnectTimeout");
        SocketStore.get().socketState.set(SocketStatus.ERROR);
    };
    private Emitter.Listener onConnectError = new Emitter.Listener(){

        public void call(Object ... objects) {
            SocketManager.this.ready.set(false);
            SocketManager.this.enqueueReconnect();
            SocketManager.this.error.set(true);
            SocketStore.get().socketState.set(SocketStatus.ERROR);
            try {
                EngineIOException exception;
                String message = "";
                if (objects[0] instanceof EngineIOException) {
                    exception = (EngineIOException)objects[0];
                    message = exception.getMessage();
                }
                if (objects[0] instanceof SocketIOException) {
                    exception = (SocketIOException)objects[0];
                    message = exception.getMessage();
                }
                L.e("onConnectError: " + message);
            }
            catch (Exception ex) {
                L.e(ex.getMessage());
            }
            SocketManager.this.clear();
        }
    };
    private Emitter.Listener onConnecting = objects -> L.d("onConnecting");
    private Emitter.Listener onDisconnect = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.d("onDisconnect: " + objects[0] + " " + SocketManager.this.forceDisconnect.get());
            SocketManager.this.ready.set(false);
            SocketManager.this.stopHeartbeat();
            if (!SocketManager.this.forceDisconnect.get()) {
                SocketManager.this.enqueueReconnect();
                SocketStore.get().socketState.set(SocketStatus.ERROR);
            } else {
                SocketStore.get().socketState.set(SocketStatus.DISCONNECTED);
            }
            Action.invoke(ActionType.SOCKET_DISCONNECTED);
            SocketManager.this.clear();
        }
    };
    private Emitter.Listener onError = new Emitter.Listener(){

        public void call(Object ... objects) {
            try {
                EngineIOException exception = (EngineIOException)objects[0];
                L.e("onError: " + objects.length + " " + exception.getMessage());
            }
            catch (Exception e) {
                L.e("onError: " + objects.length + " " + objects[0].toString());
            }
            SocketManager.this.error.set(true);
            SocketStore.get().socketState.set(SocketStatus.ERROR);
            SocketManager.this.ready.set(false);
            SocketManager.this.enqueueReconnect();
            SocketManager.this.clear();
        }
    };
    private Emitter.Listener onPing = objects -> {};
    private Emitter.Listener onPong = objects -> {};
    private Emitter.Listener onReconnect = objects -> L.d("onReconnect: " + (Integer)objects[0]);
    private Emitter.Listener onReconnectAttempt = objects -> L.d("onReconnectAttempt: " + (Integer)objects[0]);
    private Emitter.Listener onReconnectError = new Emitter.Listener(){

        public void call(Object ... objects) {
            SocketIOException exception = (SocketIOException)objects[0];
            L.e("onReconnectError: " + exception.getMessage());
            SocketManager.this.enqueueReconnect();
            SocketManager.this.ready.set(false);
            SocketStore.get().socketState.set(SocketStatus.ERROR);
        }
    };
    private Emitter.Listener onReconnectFailed = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.e("onReconnectFailed");
            SocketManager.this.enqueueReconnect();
            SocketManager.this.ready.set(false);
            SocketStore.get().socketState.set(SocketStatus.ERROR);
        }
    };
    private Emitter.Listener onReconnecting = objects -> L.d("onReconnecting: " + (Integer)objects[0]);
    private Emitter.Listener onAuthenticated = objects -> L.d("onAuthenticated: " + objects[0]);
    private Emitter.Listener onReady = new Emitter.Listener(){

        public void call(Object ... objects) {
            if (Display.isLocked()) {
                L.d("Locked. disconnect.");
                SocketManager.disconnect();
            } else {
                L.d("Ready");
                SocketManager.this.ready.set(true);
                SocketManager.this.startHeartbeat();
                SocketManager.this.clearReconnectQueue();
                SocketStore.get().socketState.set(SocketStatus.READY);
            }
        }
    };
    private Emitter.Listener onJoined = objects -> {
        L.d("onJoined: " + objects[0]);
        try {
            String[] split = StringUtils.split((String)objects[0], '/');
            String id2 = split[1];
            if (id2 != null) {
                this.onChatJoined(id2);
                SocketManager.post(id2);
            }
        }
        catch (Exception ex) {
            L.e(ex.getMessage());
        }
    };
    private Emitter.Listener onLeaved = objects -> {
        L.d("onLeaved: " + objects[0]);
        try {
            String[] stringArray = StringUtils.split((String)objects[0], '/');
        }
        catch (Exception ex) {
            L.e(ex.getMessage());
        }
    };
    private Emitter.Listener onUnauthorized = new Emitter.Listener(){

        public void call(Object ... objects) {
            L.e("onUnauthorized: " + objects[0].toString());
            SocketManager.this.ready.set(false);
            SocketManager.this.forceDisconnect.set(true);
            SocketManager.this.socket.disconnect();
        }
    };
    private Emitter.Listener onPush = objects -> {
        L.d("onPush: " + objects[0].toString());
        try {
            Message message;
            JSONObject json = (JSONObject)objects[0];
            String type = json.getString("type");
            if (json.has("refers")) {
                JSONObject refers = json.getJSONObject("refers");
                if (refers.has("bot")) {
                    BotStore.get().bots.upsert(this.parseJson(refers.getString("bot"), Bot.class));
                }
                if (refers.has("manager")) {
                    ManagerStore.get().managers.upsert(this.parseJson(refers.getString("manager"), Manager.class));
                }
                if (refers.has("userChat")) {
                    UserChatStore.get().userChats.upsert(this.parseJson(refers.getString("userChat"), UserChat.class));
                }
                if (refers.has("user")) {
                    UserStore.get().user.set(this.parseJson(refers.getString("user"), User.class), false);
                }
            }
            if ("message".equals(type) && (message = this.parseJson(json.getString("entity"), Message.class)) != null) {
                Activity topActivity = GlobalStore.get().topActivity.get();
                if (!ChannelUtils.isChannelPluginActivity((Context)topActivity)) {
                    PopupStore.get().popupMessage.set(message);
                }
                UserChatStore.get().messages.upsert(message);
            }
        }
        catch (Exception e) {
            L.e(e.getMessage());
        }
    };
    private Emitter.Listener onCreate = objects -> {
        L.d("+ onCreate) " + this.getTag((JSONObject)objects[0]) + objects[0].toString());
        this.onMessage((JSONObject)objects[0], true);
    };
    private Emitter.Listener onUpdate = objects -> {
        L.d("~ onUpdate) " + this.getTag((JSONObject)objects[0]) + objects[0].toString());
        this.onMessage((JSONObject)objects[0], true);
    };
    private Emitter.Listener onDelete = objects -> {
        L.d("- onDelete) " + this.getTag((JSONObject)objects[0]) + objects[0].toString());
        this.onMessage((JSONObject)objects[0], false);
    };

    @Deprecated
    public static Observable<String> observable() {
        return chatJoinedPublishSubject.onBackpressureBuffer().observeOn(AndroidSchedulers.mainThread());
    }

    @Deprecated
    public static void post(String chatId) {
        if (chatJoinedPublishSubject != null) {
            chatJoinedPublishSubject.onNext((Object)chatId);
        }
    }

    String getSocketEndPoint() {
        if (this.application != null) {
            return this.application.getString(R.string.socket_endpoint);
        }
        return "https://ws.channel.io/front";
    }

    public static void create(Application application) {
        if (socketManager == null) {
            socketManager = new SocketManager();
            SocketManager.socketManager.application = application;
            socketManager.init();
        }
    }

    private void init() {
        this.forceDisconnect = new AtomicBoolean(false);
        this.ready = new AtomicBoolean(false);
        this.error = new AtomicBoolean(false);
        this.reconnectQueue = new ArrayBlockingQueue<Integer>(1);
        try {
            IO.Options options = new IO.Options();
            options.reconnection = false;
            options.transports = new String[]{"websocket"};
            this.socket = IO.socket((String)this.getSocketEndPoint(), (IO.Options)options);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.socket.on("connect", this.onConnect);
        this.socket.on("connect_error", this.onConnectError);
        this.socket.on("connect_timeout", this.onConnectTimeout);
        this.socket.on("connecting", this.onConnecting);
        this.socket.on("disconnect", this.onDisconnect);
        this.socket.on("error", this.onError);
        this.socket.on("ping", this.onPing);
        this.socket.on("pong", this.onPong);
        this.socket.on("reconnect", this.onReconnect);
        this.socket.on("reconnect_attempt", this.onReconnectAttempt);
        this.socket.on("reconnect_error", this.onReconnectError);
        this.socket.on("reconnect_failed", this.onReconnectFailed);
        this.socket.on("reconnecting", this.onReconnecting);
        this.socket.on("authenticated", this.onAuthenticated);
        this.socket.on("ready", this.onReady);
        this.socket.on("create", this.onCreate);
        this.socket.on("delete", this.onDelete);
        this.socket.on("joined", this.onJoined);
        this.socket.on("leaved", this.onLeaved);
        this.socket.on("push", this.onPush);
        this.socket.on("unauthorized", this.onUnauthorized);
        this.socket.on("update", this.onUpdate);
        this.socket.on("typing", this.onTyping);
    }

    public static void setChannelId(@Nullable String channelId) {
        if (socketManager != null) {
            SocketManager.socketManager.channelId = channelId;
        }
    }

    public static boolean isReady() {
        if (socketManager != null) {
            return SocketManager.socketManager.ready.get();
        }
        return false;
    }

    public static boolean isError() {
        if (socketManager != null) {
            return SocketManager.socketManager.error.get();
        }
        return false;
    }

    public static void connect() {
        if (socketManager != null) {
            socketManager.connectSocket(true);
        }
    }

    public static void reconnect() {
        if (socketManager != null && GlobalStore.get().messengerState.get().booleanValue()) {
            socketManager.enqueueReconnect();
        }
    }

    public static void joinChat(@Nullable String chatId) {
        if (socketManager != null) {
            socketManager.chatAction("join", chatId);
        }
    }

    public static void leaveChat(@Nullable String chatId) {
        if (socketManager != null && chatId != null) {
            socketManager.chatAction("leave", chatId);
            socketManager.onChatLeaved(chatId);
        }
    }

    public static Boolean isJoined(@Nullable String chatId) {
        if (socketManager != null && chatId != null) {
            try {
                return SocketManager.socketManager.chatRoomMap.containsKey(chatId);
            }
            catch (Exception ex) {
                L.e(ex.getMessage());
            }
        }
        return false;
    }

    public static Observable<Boolean> createJoinObservable(@Nullable String chatId) {
        if (SocketManager.isReady() && !SocketManager.isJoined(chatId).booleanValue()) {
            SocketManager.joinChat(chatId);
        }
        return Observable.create(emitter -> {
            try {
                while (true) {
                    if (SocketManager.isJoined(chatId).booleanValue()) {
                        emitter.onNext((Object)true);
                        break;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (Exception ex) {
                L.e(ex.getMessage());
            }
        }, (Emitter.BackpressureMode)Emitter.BackpressureMode.LATEST);
    }

    public static void typing(Typing typing) {
        try {
            if (socketManager != null) {
                socketManager.emit("typing", new JSONObject(new Gson().toJson((Object)typing)));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static void disconnect() {
        if (socketManager != null) {
            socketManager.disconnect(true);
            socketManager.stopHeartbeat();
        }
    }

    public static void destroy() {
        if (socketManager != null) {
            socketManager.setReconnectConsumer(false);
            SocketManager.socketManager.socket.off();
            SocketManager.socketManager.socket.disconnect();
            SocketManager.socketManager.channelId = null;
            SocketManager.socketManager.forceDisconnect = null;
            SocketManager.socketManager.ready = null;
            SocketManager.socketManager.reconnectQueue = null;
            SocketManager.socketManager.socket = null;
            socketManager = null;
        }
    }

    private void enqueueReconnect() {
        if (!this.ready.get()) {
            try {
                this.reconnectQueue.add(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void clearReconnectQueue() {
        try {
            this.reconnectQueue.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void connectSocket(boolean isManual) {
        if (this.socket != null && !this.socket.connected() && this.channelId != null) {
            L.d("try connect");
            this.socket.connect();
            this.setReconnectConsumer(true);
            if (isManual) {
                SocketStore.get().socketState.set(SocketStatus.CONNECTING);
            }
        }
    }

    private void disconnect(boolean force) {
        this.forceDisconnect.set(force);
        try {
            this.clearReconnectQueue();
            this.socket.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!force) {
            this.enqueueReconnect();
        } else {
            this.setReconnectConsumer(false);
        }
    }

    private void authentication() {
        String jwt = GlobalStore.get().jwt.get();
        if (jwt == null) {
            this.disconnect(true);
        } else {
            this.emit("authentication", jwt);
        }
    }

    private synchronized void setReconnectConsumer(boolean flag) {
        if (flag) {
            if (this.reconnectConsumer == null) {
                this.reconnectConsumer = new Timer();
                this.reconnectConsumer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            Integer data = (Integer)SocketManager.this.reconnectQueue.peek();
                            if (data != null) {
                                int index = Math.min(SocketManager.this.attemptCount.getAndIncrement(), SocketManager.this.attemptDelay.length - 1);
                                Thread.sleep(SocketManager.this.attemptDelay[index] * 1000);
                                SocketManager.this.reconnectQueue.remove();
                                SocketManager.this.connectSocket(false);
                            }
                        }
                        catch (Exception e) {
                            L.e(e.getMessage());
                        }
                    }
                }, 500L, 500L);
            }
        } else if (this.reconnectConsumer != null) {
            try {
                this.reconnectConsumer.cancel();
            }
            catch (Exception exception) {
            }
            finally {
                this.reconnectConsumer = null;
            }
        }
    }

    private void startHeartbeat() {
        this.stopHeartbeat();
        this.sendHeartbeat();
        this.heartbeat = Observable.interval((long)30000L, (TimeUnit)TimeUnit.MILLISECONDS).subscribe((Subscriber)new Subscriber<Long>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(Long aLong) {
                if (Display.isLocked()) {
                    L.d("Display locked. disconnect.");
                    SocketManager.this.disconnect(true);
                } else {
                    SocketManager.this.sendHeartbeat();
                }
            }
        });
    }

    private void sendHeartbeat() {
        try {
            L.i("Heartbeat");
            this.socket.emit("heartbeat", new Object[]{""});
        }
        catch (Exception ex) {
            L.e("socket error");
        }
    }

    private synchronized void stopHeartbeat() {
        if (this.heartbeat != null && !this.heartbeat.isUnsubscribed()) {
            this.heartbeat.unsubscribe();
        }
    }

    private void emit(String event, Object object) {
        if (object == null || this.socket == null) {
            return;
        }
        this.socket.emit(event, new Object[]{object});
    }

    private void chatAction(String action, @Nullable String chatId) {
        if (this.socket == null) {
            return;
        }
        if (chatId == null || !this.ready.get()) {
            return;
        }
        String message = String.format("/user-chats/%s", chatId);
        this.emit(action, message);
    }

    private void onChatJoined(@Nullable String chatId) {
        if (chatId != null) {
            this.chatRoomMap.put(chatId, true);
        }
    }

    private void onChatLeaved(@Nullable String chatId) {
        if (chatId != null) {
            this.chatRoomMap.remove(chatId);
        }
    }

    private void clear() {
        this.chatRoomMap.clear();
    }

    private String getTag(JSONObject json) {
        try {
            String type = json.getString("type");
            String id2 = json.getJSONObject("entity").getString("id");
            return String.format("%s (%s): ", type, id2);
        }
        catch (Exception ex) {
            return "";
        }
    }

    private void onMessage(JSONObject json, boolean upsert) {
        try {
            String type;
            if (!json.has("type") || !json.has("entity")) {
                return;
            }
            String entity = json.getString("entity");
            switch (type = json.getString("type")) {
                case "bot": {
                    Bot bot = this.parseJson(entity, Bot.class);
                    if (bot == null) break;
                    BotStore.get().bots.upsert(bot);
                    break;
                }
                case "manager": {
                    Manager manager = this.parseJson(entity, Manager.class);
                    if (manager == null) {
                        return;
                    }
                    ManagerStore.get().managers.upsert(manager);
                    break;
                }
                case "message": {
                    Message prevMessage;
                    JSONObject refers;
                    Message message = this.parseJson(entity, Message.class);
                    if (message == null) {
                        return;
                    }
                    if (json.has("refers") && (refers = json.getJSONObject("refers")).has("bot")) {
                        Bot botRefers = this.parseJson(refers.getString("bot"), Bot.class);
                        BotStore.get().bots.upsert(botRefers);
                    }
                    if ((prevMessage = (Message)UserChatStore.get().messages.get(message.getChatId())) == null || prevMessage.getCreatedAt() <= message.getCreatedAt()) {
                        UserChatStore.get().messages.upsert(message);
                    }
                    RxBus.post(message);
                    if (message.getProfileBot() != null) {
                        ProfileBotStore.get().requestFocus.set(true);
                    }
                    if (!message.isDeleted()) break;
                    Message popupMessage = PopupStore.get().popupMessage.get();
                    if (popupMessage != null && popupMessage.getId() != null && popupMessage.getId().equals(message.getId())) {
                        PopupStore.get().popupMessage.reset();
                    }
                    break;
                }
                case "userChat": {
                    UserChat userChat = this.parseJson(entity, UserChat.class);
                    if (userChat == null) {
                        return;
                    }
                    RxBus.post(userChat);
                    if (json.has("refers")) {
                        JSONObject refers = json.getJSONObject("refers");
                        if (refers.has("message")) {
                            Message referMessage = this.parseJson(refers.getString("message"), Message.class);
                            UserChatStore.get().messages.upsert(referMessage);
                        }
                        if (refers.has("manager")) {
                            Manager referManager = this.parseJson(refers.getString("manager"), Manager.class);
                            ManagerStore.get().managers.upsert(referManager);
                        }
                        if (refers.has("bot")) {
                            Bot referBot = this.parseJson(refers.getString("bot"), Bot.class);
                            BotStore.get().bots.upsert(referBot);
                        }
                    }
                    UserChatStore.get().userChats.upsert(userChat);
                    break;
                }
                case "chatSession": {
                    Session session = this.parseJson(entity, Session.class);
                    if (session == null) {
                        return;
                    }
                    if (json.has("refers")) {
                        JSONObject refers = json.getJSONObject("refers");
                        if (refers.has("bot")) {
                            Bot referBot = this.parseJson(refers.getString("bot"), Bot.class);
                            BotStore.get().bots.upsert(referBot);
                        }
                        if (refers.has("manager")) {
                            Manager referManager = this.parseJson(refers.getString("manager"), Manager.class);
                            ManagerStore.get().managers.upsert(referManager);
                        }
                    }
                    if (upsert) {
                        UserChatStore.get().sessions.upsert(session);
                        break;
                    }
                    UserChatStore.get().sessions.remove(session);
                    break;
                }
                case "channel": {
                    Channel channel = this.parseJson(entity, Channel.class);
                    if (channel == null) break;
                    ChannelStore.get().channelState.set(channel);
                    break;
                }
                case "user": {
                    User user = this.parseJson(entity, User.class);
                    if (user == null) break;
                    UserStore.get().user.set(user);
                }
            }
        }
        catch (Exception ex) {
            L.e(ex.getMessage());
        }
    }

    private <T> T parseJson(String entity, Class<T> target) {
        if (entity == null) {
            return null;
        }
        try {
            return (T)ParseUtils.getCustomGson().fromJson(entity, target);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static {
        chatJoinedPublishSubject = PublishSubject.create();
    }
}

