/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.network;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.annotation.Failed;
import com.zoyi.channel.plugin.android.annotation.Pass;
import com.zoyi.channel.plugin.android.annotation.Success;
import com.zoyi.channel.plugin.android.model.repo.EmptyRepo;
import com.zoyi.channel.plugin.android.model.repo.LoungeMediaRepo;
import com.zoyi.channel.plugin.android.model.repo.LoungeRepo;
import com.zoyi.channel.plugin.android.model.repo.ManagersRepo;
import com.zoyi.channel.plugin.android.model.repo.MessageRepo;
import com.zoyi.channel.plugin.android.model.repo.MessagesRepo;
import com.zoyi.channel.plugin.android.model.repo.PackageRepo;
import com.zoyi.channel.plugin.android.model.repo.ProfileBotSchemasRepo;
import com.zoyi.channel.plugin.android.model.repo.SupportBotRepo;
import com.zoyi.channel.plugin.android.model.repo.TranslationRepo;
import com.zoyi.channel.plugin.android.model.repo.UserChatRepo;
import com.zoyi.channel.plugin.android.model.repo.UserChatsRepo;
import com.zoyi.channel.plugin.android.model.repo.UserRepo;
import com.zoyi.channel.plugin.android.model.rest.AppMessengerUri;
import com.zoyi.channel.plugin.android.model.rest.Country;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.retrofit2.http.Body;
import com.zoyi.retrofit2.http.DELETE;
import com.zoyi.retrofit2.http.Field;
import com.zoyi.retrofit2.http.FormUrlEncoded;
import com.zoyi.retrofit2.http.GET;
import com.zoyi.retrofit2.http.Header;
import com.zoyi.retrofit2.http.Headers;
import com.zoyi.retrofit2.http.PATCH;
import com.zoyi.retrofit2.http.POST;
import com.zoyi.retrofit2.http.PUT;
import com.zoyi.retrofit2.http.Path;
import com.zoyi.retrofit2.http.Query;
import com.zoyi.rx.Observable;
import java.util.List;

public interface ChannelApi {
    @Success
    @GET(value="/packages/{packageId}/versions/latest")
    public Observable<PackageRepo> getLastestPackage(@Path(value="packageId") String var1, @Query(value="from") String var2);

    @Success
    @GET(value="/front/user-chats")
    public Observable<UserChatsRepo> getUserChats(@Query(value="sortField") String var1, @Query(value="sortOrder") String var2, @Query(value="limit") Integer var3, @Query(value="includeClosed") boolean var4);

    @Success
    @GET(value="/front/user-chats")
    public Observable<UserChatsRepo> getUserChatsNext(@Query(value="sortField") String var1, @Query(value="sortOrder") String var2, @Query(value="limit") Integer var3, @Query(value="includeClosed") boolean var4, @Query(value="since") String var5);

    @Success
    @GET(value="/front/user-chats/{userChatId}")
    public Observable<UserChatRepo> getUserChat(@Path(value="userChatId") String var1);

    @Success
    @GET(value="/front/user-chats/{userChatId}/messages")
    public Observable<MessagesRepo> getMessages(@Path(value="userChatId") String var1, @Query(value="since") @Nullable String var2, @Query(value="limit") Integer var3, @Query(value="sortOrder") String var4);

    @Success
    @FormUrlEncoded
    @POST(value="/front/plugins/{pluginId}/user-chats")
    public Observable<UserChatRepo> createUserChat(@Path(value="pluginId") String var1, @Field(value="url") String var2);

    @Success
    @PUT(value="/front/user-chats/{userChatId}/messages/read")
    public Observable<Void> read(@Path(value="userChatId") String var1);

    @Success
    @Headers(value={"Content-Type: application/json"})
    @POST(value="/front/user-chats/{userChatId}/messages")
    public Observable<MessageRepo> sendMessage(@Path(value="userChatId") String var1, @Body RequestBody var2);

    @Success
    @Headers(value={"Content-Type: application/json"})
    @POST(value="/front/elastic/push-tokens")
    public Observable<EmptyRepo> sendToken(@Body RequestBody var1, @Header(value="x-session") String var2);

    @Success
    @Headers(value={"Content-Type: application/json"})
    @DELETE(value="/front/elastic/push-tokens/{key}")
    public Observable<Void> deleteToken(@Header(value="Accept-Language") @Nullable String var1, @Path(value="key") String var2, @Header(value="x-session") String var3);

    @Success
    @DELETE(value="/front/elastic/push-tokens/{key}/of")
    public Observable<Void> deleteToken(@Path(value="key") String var1, @Query(value="userId") @Nullable String var2);

    @Success
    @DELETE(value="/front/user-chats/{userChatId}")
    public Observable<UserChatRepo> removeUserChat(@Path(value="userChatId") String var1);

    @Success
    @PUT(value="/front/user-chats/{userChatId}/close")
    public Observable<MessageRepo> closeUserChat(@Path(value="userChatId") String var1, @Query(value="actionId") @Nullable String var2, @Query(value="requestId") String var3);

    @Success
    @FormUrlEncoded
    @PUT(value="/front/user-chats/{userChatId}/review")
    public Observable<MessageRepo> reviewUserChat(@Path(value="userChatId") String var1, @Query(value="actionId") @Nullable String var2, @Query(value="requestId") String var3, @Field(value="review") String var4);

    @Success
    @GET(value="/available/countries")
    public Observable<List<Country>> getCountries();

    @Success
    @POST(value="/front/user-chats/{userChatId}/messages/{messageId}/profile-bot")
    public Observable<MessageRepo> updateProfileBot(@Path(value="userChatId") String var1, @Path(value="messageId") String var2, @Body RequestBody var3);

    @Success
    @GET(value="/front/user-chats/{userChatId}/messages/{messageId}/translate")
    public Observable<TranslationRepo> getTranslatedMessage(@Path(value="userChatId") String var1, @Path(value="messageId") String var2, @Query(value="language") String var3);

    @Success
    @FormUrlEncoded
    @POST(value="/front/support-bots/{supportBotId}/user-chats")
    public Observable<UserChatRepo> createSupportBotUserChat(@Path(value="supportBotId") String var1, @Field(value="url") String var2);

    @Pass
    @POST(value="/front/user-chats/{userChatId}/support-bot/buttons/{buttonId}")
    public Observable<MessageRepo> submitButtonAction(@Path(value="userChatId") String var1, @Path(value="buttonId") @Nullable String var2, @Query(value="actionId") @Nullable String var3, @Query(value="requestId") @Nullable String var4);

    @Pass
    @PUT(value="/front/user-chats/{userChatId}/messages/receive")
    public Observable<Void> receivePushNotification(@Path(value="userChatId") String var1, @Header(value="x-session") String var2);

    @Failed(value="https://github.com/zoyi/ch-dropwizard/issues/1715")
    @GET(value="/front/plugins/{pluginId}/profile-bot-schemas")
    public Observable<ProfileBotSchemasRepo> getProfileBotSchemas(@Path(value="pluginId") String var1);

    @Success
    @PATCH(value="/front/users/me")
    public Observable<UserRepo> updateUser(@Body RequestBody var1);

    @Success
    @DELETE(value="/front/users/me/pop-up")
    public Observable<Void> closePopUp();

    @Success
    @FormUrlEncoded
    @POST(value="/front/plugins/{pluginId}/lounge")
    public Observable<LoungeRepo> getLounge(@Path(value="pluginId") String var1, @Field(value="url") @Nullable String var2);

    @Success
    @GET(value="/front/app/{appMessengerName}/connect")
    public Observable<AppMessengerUri> getMessengerConnect(@Path(value="appMessengerName") String var1);

    @Success
    @POST(value="/front/user-chats/{userChatId}/support-bots/{supportBotId}")
    public Observable<MessageRepo> createMarketingSupportBotUserChat(@Path(value="userChatId") String var1, @Path(value="supportBotId") @Nullable String var2);

    @GET(value="/front/campaigns/{campaignId}/users/{userId}/click")
    public Observable<Void> campaignClick(@Path(value="campaignId") String var1, @Path(value="userId") String var2, @Query(value="url") @Nullable String var3);

    @PUT(value="/front/campaigns/{campaignId}/view")
    public Observable<Void> campaignView(@Path(value="campaignId") String var1);

    @GET(value="/front/one-time-msgs/{oneTimeMsgId}/users/{userId}/click")
    public Observable<Void> oneTimeMsgClick(@Path(value="oneTimeMsgId") String var1, @Path(value="userId") String var2, @Query(value="url") @Nullable String var3);

    @PUT(value="/front/one-time-msgs/{oneTimeMsgId}/view")
    public Observable<Void> oneTimeMsgView(@Path(value="oneTimeMsgId") String var1);

    @PATCH(value="/front/users/me/tags")
    public Observable<UserRepo> addTags(@Query(value="tags") @Nullable List<String> var1);

    @DELETE(value="/front/users/me/tags")
    public Observable<UserRepo> removeTags(@Query(value="tags") @Nullable List<String> var1);

    @GET(value="/front/campaigns/{campaignId}/support-bot")
    public Observable<SupportBotRepo> getCampaignSupportBot(@Path(value="campaignId") @Nullable String var1);

    @GET(value="/front/one-time-msgs/{oneTimeMsgId}/support-bot")
    public Observable<SupportBotRepo> getOneTimeMessageSupportBot(@Path(value="oneTimeMsgId") @Nullable String var1);

    @DELETE(value="/front/user-chats/{userChatId}/messages/{messageId}")
    public Observable<MessageRepo> deleteMessage(@Path(value="userChatId") String var1, @Path(value="messageId") String var2);

    @GET(value="/front/managers")
    public Observable<ManagersRepo> getManagers(@Query(value="managerIds") @Nullable List<String> var1);

    @GET(value="/front/plugins/{pluginId}/lounge-media")
    public Observable<LoungeMediaRepo> getLoungeMedia(@Path(value="pluginId") String var1, @Query(value="types") @Nullable List<String> var2);
}

