/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.base;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.bind.BinderCollection;
import com.zoyi.channel.plugin.android.bind.BinderController;
import com.zoyi.channel.plugin.android.contract.BasePresenter;
import com.zoyi.channel.plugin.android.contract.BaseView;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.rx.Subscription;

public abstract class AbstractPresenter<V extends BaseView>
implements BasePresenter,
BinderController {
    protected V view;
    private BinderCollection binderCollection;
    @Nullable
    private Subscription subscription;

    public AbstractPresenter(V view) {
        this.view = view;
        this.binderCollection = new BinderCollection();
        this.subscription = Action.observable().subscribe(actionType -> {
            this.handleBaseAction((ActionType)((Object)actionType));
            this.handleAction((ActionType)((Object)actionType));
        });
    }

    @Override
    public abstract void init();

    @Override
    public BinderCollection getBinderCollection() {
        return this.binderCollection;
    }

    private void handleBaseAction(ActionType actionType) {
        switch (actionType) {
            case EXIT: {
                this.view.finish(Transition.SLIDE_FROM_BOTTOM);
                break;
            }
            case SHUTDOWN: {
                this.view.finish(Transition.NONE);
            }
        }
    }

    protected void handleAction(ActionType actionType) {
    }

    @Override
    public void release() {
        this.unbindAll();
        if (this.subscription != null && !this.subscription.isUnsubscribed()) {
            this.subscription.unsubscribe();
            this.subscription = null;
        }
    }
}

