/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.lounge.view.lounge_media;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.common.error.ErrorRefreshContentView;
import com.zoyi.channel.plugin.android.activity.common.error.OnErrorRefreshClickListener;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.open.option.Language;
import com.zoyi.channel.plugin.android.selector.SettingsSelector;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.rx.functions.Action1;

public class LoungeMediaErrorCardView
extends FrameLayout
implements ErrorRefreshContentView {
    private TextView textDesc;
    @Nullable
    private OnErrorRefreshClickListener listener;
    @Nullable
    private Binder binder;
    @Nullable
    private String type;

    public LoungeMediaErrorCardView(Context context) {
        super(context);
        this.init(context);
    }

    public LoungeMediaErrorCardView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public LoungeMediaErrorCardView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        View root = LayoutInflater.from((Context)context).inflate(R.layout.ch_view_lounge_media_error_card, (ViewGroup)this, true);
        root.findViewById(R.id.ch_imageLoungeMediaError).setOnClickListener(v -> {
            if (this.listener != null) {
                this.listener.onRefreshClick();
            }
        });
        root.findViewById(R.id.ch_textLoungeMediaErrorRefresh).setOnClickListener(v -> {
            if (this.listener != null) {
                this.listener.onRefreshClick();
            }
        });
        this.textDesc = (TextView)root.findViewById(R.id.ch_textLoungeMediaErrorDescription);
        this.textDesc.setOnClickListener(v -> {
            if (this.listener != null) {
                this.listener.onRefreshClick();
            }
        });
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.binder = SettingsSelector.bindLanguage((Action1<Language>)((Action1)language -> this.updateDescription()));
    }

    protected void onDetachedFromWindow() {
        if (this.binder != null) {
            this.binder.unbind();
            this.binder = null;
        }
        super.onDetachedFromWindow();
    }

    @Override
    public void setOnErrorRefreshClickListener(@Nullable OnErrorRefreshClickListener listener) {
        this.listener = listener;
    }

    public void setLoungeMediaType(String type) {
        this.type = type;
        this.updateDescription();
    }

    private void updateDescription() {
        if ("instagram".equals(this.type)) {
            this.textDesc.setText((CharSequence)String.format(ResUtils.getString(this.getContext(), "ch.lounge.media.error"), ResUtils.getString(this.getContext(), "ch.lounge.media.error.instagram")));
        }
    }
}

