/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.lounge;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.action.AppMessengerAction;
import com.zoyi.channel.plugin.android.action.ChatAction;
import com.zoyi.channel.plugin.android.action.LoungeAction;
import com.zoyi.channel.plugin.android.action.UserChatAction;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.UserChatItem;
import com.zoyi.channel.plugin.android.activity.common.watermark.OnWatermarkCounterCompleteListener;
import com.zoyi.channel.plugin.android.activity.common.watermark.WatermarkCounter;
import com.zoyi.channel.plugin.android.activity.lounge.contract.LoungeAdapterContract;
import com.zoyi.channel.plugin.android.activity.lounge.contract.LoungeContract;
import com.zoyi.channel.plugin.android.activity.lounge.enumerate.PreviewState;
import com.zoyi.channel.plugin.android.base.AbstractAdapterPresenter;
import com.zoyi.channel.plugin.android.bind.BindAction;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.enumerate.SocketStatus;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.repo.UserChatRepo;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.selector.ChatsSelector;
import com.zoyi.channel.plugin.android.selector.LoungeSelector;
import com.zoyi.channel.plugin.android.selector.ProfileSelector;
import com.zoyi.channel.plugin.android.selector.SettingsSelector;
import com.zoyi.channel.plugin.android.selector.SocketSelector;
import com.zoyi.channel.plugin.android.store.PluginStore;
import com.zoyi.channel.plugin.android.store.SocketStore;
import com.zoyi.channel.plugin.android.store.UserChatStore;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Action2;
import java.util.Collections;
import java.util.List;

public class LoungePresenter
extends AbstractAdapterPresenter<LoungeContract.View, LoungeAdapterContract.View, LoungeAdapterContract.Model>
implements LoungeContract.Presenter,
OnWatermarkCounterCompleteListener {
    @Nullable
    private String topActivityName;
    private WatermarkCounter watermarkCounter;

    public LoungePresenter(LoungeContract.View view, LoungeAdapterContract.View adapterView, LoungeAdapterContract.Model adapterModel, @Nullable String topActivityName) {
        super(view, adapterView, adapterModel);
        this.topActivityName = topActivityName;
        this.watermarkCounter = new WatermarkCounter(this);
        ChannelSelector.bindChannel((Action1<Channel>)((Action1)channel -> {
            if (!this.isRunning(BindAction.FETCH_LOUNGE) && this.watermarkCounter.isComplete()) {
                view.handleWatermarkVisibility();
            }
        })).bind(this);
    }

    @Override
    public void fetchBundleData() {
        this.fetchPreviewData();
    }

    @Override
    public void fetchPreviewData() {
        this.fetchLoungeData();
    }

    private void fetchUserChats(boolean showClosedChats) {
        UserChatAction.fetchUserChats(showClosedChats);
    }

    private void fetchLoungeData() {
        Plugin plugin = PluginStore.get().pluginState.get();
        this.resetLounge();
        if (plugin != null) {
            LoungeAction.fetchLounge(plugin.getId(), this.topActivityName, (Action1<List<String>>)((Action1)loungeMediaTypes -> {
                if (loungeMediaTypes != null && !loungeMediaTypes.isEmpty()) {
                    this.watermarkCounter.active(loungeMediaTypes.size());
                    for (String type : loungeMediaTypes) {
                        this.fetchLoungeMediaData(type);
                    }
                } else {
                    this.watermarkCounter.active(0);
                }
            })).bind(this, BindAction.FETCH_LOUNGE);
        }
    }

    @Override
    public void fetchLoungeMediaData(String type) {
        Plugin plugin = PluginStore.get().pluginState.get();
        if (plugin != null && "instagram".equals(type)) {
            ((LoungeContract.View)this.view).onLoungeMediaStateChange(type, FetchState.LOADING);
            Api.getLoungeMedia(plugin.getId(), Collections.singletonList(type)).onComplete(() -> this.watermarkCounter.next(type)).onError(ex -> ((LoungeContract.View)this.view).onLoungeMediaStateChange(type, FetchState.FAILED)).call(repo -> {
                if (!repo.getLoungeMedia().isEmpty()) {
                    ((LoungeContract.View)this.view).onLoungeMediaStateChange(type, FetchState.COMPLETE);
                    ((LoungeContract.View)this.view).onFetchLoungeMediaInstagram(repo.getLoungeMedia());
                } else {
                    ((LoungeContract.View)this.view).onLoungeMediaStateChange(type, FetchState.EMPTY);
                }
            }).bind(this, BindAction.GET_LOUNGE_MEDIA_INSTAGRAM);
        } else {
            this.watermarkCounter.next(type);
        }
    }

    @Override
    public void init() {
        if (SocketStore.get().socketState.get() != SocketStatus.READY) {
            ((LoungeContract.View)this.view).onPreviewStateChange(PreviewState.FAILED);
        }
        this.bind(LoungeSelector.bindPreviewState((Action1<PreviewState>)((Action1)previewState -> ((LoungeContract.View)this.view).onPreviewStateChange((PreviewState)((Object)previewState)))));
        this.bind(ProfileSelector.bindDefaultProfile((Action1<ProfileEntity>)((Action1)profile -> ((LoungeContract.View)this.view).onDefaultProfileChange((ProfileEntity)profile))));
        this.bind(LoungeSelector.bindWelcomeMessage((Action1<String>)((Action1)plaintText -> ((LoungeContract.View)this.view).onWelcomeMessageChange((String)plaintText))));
        this.bind(SettingsSelector.bindShowClosedChats((Action1<Boolean>)((Action1)showClosedChats -> {
            if (showClosedChats != null) {
                this.fetchUserChats((boolean)showClosedChats);
            }
        })));
        this.bind(ChatsSelector.bindChats((Action2<List<ChatItem>, List<ChatItem>>)((Action2)(activeChatItems, closedChatItems) -> ((LoungeAdapterContract.Model)this.adapterModel).updateChatItems((List<ChatItem>)activeChatItems))));
        this.bind(SocketSelector.bindSocket((Action1<SocketStatus>)((Action1)socketStatus -> {
            if (socketStatus == SocketStatus.READY) {
                this.fetchBundleData();
            }
        })));
    }

    @Override
    public void removeChat(ChatItem item) {
        if (item instanceof UserChatItem) {
            ((LoungeContract.View)this.view).showProgress(ResUtils.getString("ch.chat.delete_progress"));
            ChatAction.removeUserChat(item.getId(), (Action1<UserChatRepo>)((Action1)userChatRepo -> {
                ((LoungeContract.View)this.view).hideProgress();
                userChatRepo.remove();
                UserChatStore.get().userChats.removeByKey(item.getId());
            }), () -> ((LoungeContract.View)this.view).hideProgress());
        }
    }

    @Override
    public void fetchConnect(String appMessengerName) {
        AppMessengerAction.fetchConnect(appMessengerName);
    }

    @Override
    public void onComplete() {
        ((LoungeContract.View)this.view).handleWatermarkVisibility();
    }

    private void resetLounge() {
        this.unbind(BindAction.GET_LOUNGE_MEDIA_INSTAGRAM);
        this.watermarkCounter.reset();
        ((LoungeContract.View)this.view).deactivateWatermark();
    }
}

