/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.com.bumptech.glide.load.model;

import android.content.Context;
import com.zoyi.com.bumptech.glide.load.data.DataFetcher;
import com.zoyi.com.bumptech.glide.load.model.ModelLoader;
import com.zoyi.com.bumptech.glide.load.model.ModelLoaderFactory;
import java.util.HashMap;
import java.util.Map;

public class GenericLoaderFactory {
    private final Map<Class, Map<Class, ModelLoaderFactory>> modelClassToResourceFactories = new HashMap<Class, Map<Class, ModelLoaderFactory>>();
    private final Map<Class, Map<Class, ModelLoader>> cachedModelLoaders = new HashMap<Class, Map<Class, ModelLoader>>();
    private static final ModelLoader NULL_MODEL_LOADER = new ModelLoader(){

        public DataFetcher getResourceFetcher(Object model, int width, int height) {
            throw new NoSuchMethodError("This should never be called!");
        }

        public String toString() {
            return "NULL_MODEL_LOADER";
        }
    };
    private final Context context;

    public GenericLoaderFactory(Context context) {
        this.context = context.getApplicationContext();
    }

    public synchronized <T, Y> ModelLoaderFactory<T, Y> unregister(Class<T> modelClass, Class<Y> resourceClass) {
        this.cachedModelLoaders.clear();
        ModelLoaderFactory result = null;
        Map<Class, ModelLoaderFactory> resourceToFactories = this.modelClassToResourceFactories.get(modelClass);
        if (resourceToFactories != null) {
            result = resourceToFactories.remove(resourceClass);
        }
        return result;
    }

    public synchronized <T, Y> ModelLoaderFactory<T, Y> register(Class<T> modelClass, Class<Y> resourceClass, ModelLoaderFactory<T, Y> factory) {
        ModelLoaderFactory<T, Y> previous;
        this.cachedModelLoaders.clear();
        Map<Class, ModelLoaderFactory> resourceToFactories = this.modelClassToResourceFactories.get(modelClass);
        if (resourceToFactories == null) {
            resourceToFactories = new HashMap<Class, ModelLoaderFactory>();
            this.modelClassToResourceFactories.put(modelClass, resourceToFactories);
        }
        if ((previous = resourceToFactories.put(resourceClass, factory)) != null) {
            for (Map<Class, ModelLoaderFactory> factories : this.modelClassToResourceFactories.values()) {
                if (!factories.containsValue(previous)) continue;
                previous = null;
                break;
            }
        }
        return previous;
    }

    @Deprecated
    public synchronized <T, Y> ModelLoader<T, Y> buildModelLoader(Class<T> modelClass, Class<Y> resourceClass, Context context) {
        return this.buildModelLoader(modelClass, resourceClass);
    }

    public synchronized <T, Y> ModelLoader<T, Y> buildModelLoader(Class<T> modelClass, Class<Y> resourceClass) {
        ModelLoader<T, Y> result = this.getCachedLoader(modelClass, resourceClass);
        if (result != null) {
            if (NULL_MODEL_LOADER.equals(result)) {
                return null;
            }
            return result;
        }
        ModelLoaderFactory<T, Y> factory = this.getFactory(modelClass, resourceClass);
        if (factory != null) {
            result = factory.build(this.context, this);
            this.cacheModelLoader(modelClass, resourceClass, result);
        } else {
            this.cacheNullLoader(modelClass, resourceClass);
        }
        return result;
    }

    private <T, Y> void cacheNullLoader(Class<T> modelClass, Class<Y> resourceClass) {
        this.cacheModelLoader(modelClass, resourceClass, NULL_MODEL_LOADER);
    }

    private <T, Y> void cacheModelLoader(Class<T> modelClass, Class<Y> resourceClass, ModelLoader<T, Y> modelLoader) {
        Map<Class, ModelLoader> resourceToLoaders = this.cachedModelLoaders.get(modelClass);
        if (resourceToLoaders == null) {
            resourceToLoaders = new HashMap<Class, ModelLoader>();
            this.cachedModelLoaders.put(modelClass, resourceToLoaders);
        }
        resourceToLoaders.put(resourceClass, modelLoader);
    }

    private <T, Y> ModelLoader<T, Y> getCachedLoader(Class<T> modelClass, Class<Y> resourceClass) {
        Map<Class, ModelLoader> resourceToLoaders = this.cachedModelLoaders.get(modelClass);
        ModelLoader result = null;
        if (resourceToLoaders != null) {
            result = resourceToLoaders.get(resourceClass);
        }
        return result;
    }

    private <T, Y> ModelLoaderFactory<T, Y> getFactory(Class<T> modelClass, Class<Y> resourceClass) {
        ModelLoaderFactory result;
        block2: {
            Map<Class, ModelLoaderFactory> resourceToFactories = this.modelClassToResourceFactories.get(modelClass);
            result = null;
            if (resourceToFactories != null) {
                result = resourceToFactories.get(resourceClass);
            }
            if (result != null) break block2;
            for (Class registeredModelClass : this.modelClassToResourceFactories.keySet()) {
                Map<Class, ModelLoaderFactory> currentResourceToFactories;
                if (registeredModelClass.isAssignableFrom(modelClass) && (currentResourceToFactories = this.modelClassToResourceFactories.get(registeredModelClass)) != null && (result = currentResourceToFactories.get(resourceClass)) != null) break;
            }
        }
        return result;
    }
}

