package com.zoyi.channel.plugin.android.view.load_wrapper;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.*;
import android.util.AttributeSet;
import android.view.*;
import android.widget.FrameLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.common.error.*;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.util.*;
import com.zoyi.channel.plugin.android.view.external.cpv.CircularProgressView;

import java.util.List;

public class LoadWrapperLayout extends FrameLayout implements ErrorRefreshContentView, OnErrorRefreshClickListener {

  private List<Integer> componentIds = ListUtils.newArrayList(
          R.id.ch_rootLoadWrapper,
          R.id.ch_progressLoadWrapperDefault,
          R.id.ch_errorLoadWrapperDefault,
          R.id.ch_layoutLoadWrapperProgress,
          R.id.ch_layoutLoadWrapperError,
          R.id.ch_layoutLoadWrapperContent
  );

  @Nullable
  private LayoutInflater inflater;

  private CircularProgressView progressLoadWrapper;
  private ErrorRefreshView errorLoadWrapper;
  private FrameLayout layoutLoadWrapperProgress;
  private FrameLayout layoutLoadWrapperError;
  private FrameLayout layoutLoadWrapperContent;

  @Nullable
  private View progressView;

  @Nullable
  private View errorView;

  @Nullable
  private OnErrorRefreshClickListener listener;

  public LoadWrapperLayout(@NonNull Context context) {
    super(context);
    init(context, null);
  }

  public LoadWrapperLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context, attrs);
  }

  public LoadWrapperLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context, attrs);
  }

  @Initializer
  private void init(Context context, @Nullable AttributeSet attrs) {
    inflater = LayoutInflater.from(context);
    inflater.inflate(R.layout.ch_plugin_layout_load_wrapper, this);

    progressLoadWrapper = findViewById(R.id.ch_progressLoadWrapperDefault);
    errorLoadWrapper = findViewById(R.id.ch_errorLoadWrapperDefault);
    errorLoadWrapper.setOnErrorRefreshClickListener(this);

    layoutLoadWrapperProgress = findViewById(R.id.ch_layoutLoadWrapperProgress);
    layoutLoadWrapperError = findViewById(R.id.ch_layoutLoadWrapperError);
    layoutLoadWrapperContent = findViewById(R.id.ch_layoutLoadWrapperContent);

    if (attrs != null) {
      TypedArray typedArray = context.getTheme().obtainStyledAttributes(
              attrs,
              R.styleable.LoadWrapperLayout,
              0,
              0);

      try {
        setProgressView(typedArray.getResourceId(R.styleable.LoadWrapperLayout_ch_progressView, 0));
        setErrorView(typedArray.getResourceId(R.styleable.LoadWrapperLayout_ch_errorView, 0));
      } finally {
        typedArray.recycle();
      }
    }
  }

  public void setLoadState(FetchState fetchState) {
    setWrapperVisibility(fetchState == FetchState.LOADING, progressView, progressLoadWrapper, layoutLoadWrapperProgress);
    setWrapperVisibility(fetchState == FetchState.FAILED, errorView, errorLoadWrapper, layoutLoadWrapperError);
    Views.setVisibility(layoutLoadWrapperContent, fetchState == FetchState.COMPLETE);
  }

  private void setWrapperVisibility(boolean visible, @Nullable View conditionView, View defaultView, View wrapper) {
    if (conditionView == null) {
      Views.setVisibility(defaultView, visible);
    } else {
      Views.setVisibility(wrapper, visible);
    }
  }

  @Override
  public void setOnErrorRefreshClickListener(@Nullable OnErrorRefreshClickListener listener) {
    this.listener = listener;
  }

  @Override
  public void addView(View child, int index, ViewGroup.LayoutParams params) {
    if (child != null && componentIds.contains(child.getId())) {
      super.addView(child, index, params);
    } else if (layoutLoadWrapperContent != null && child != null) {
      layoutLoadWrapperContent.addView(child, index, params);
    }
  }

  private void setProgressView(@LayoutRes int id) {
    if (id != 0 && inflater != null) {
      this.progressView = inflater.inflate(id, null);

      layoutLoadWrapperProgress.removeAllViews();
      if (this.progressView != null) {
        layoutLoadWrapperProgress.addView(this.progressView);
      }
    }
  }

  private void setErrorView(@LayoutRes int id) {
    if (id != 0 && inflater != null) {
      View errorView = inflater.inflate(id, null);

      if (errorView instanceof ErrorRefreshContentView) {
        ((ErrorRefreshContentView) errorView).setOnErrorRefreshClickListener(this);
      }

      layoutLoadWrapperError.removeAllViews();
      if (errorView != null) {
        layoutLoadWrapperError.addView(errorView);
      }

      this.errorView = errorView;
    }
  }

  @Nullable
  public View getErrorView() {
    return errorView;
  }

  @Override
  public void onRefreshClick() {
    if (this.listener != null) {
      this.listener.onRefreshClick();
    }
  }
}
