package com.zoyi.channel.plugin.android.view.integrations.instagram;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.*;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.media.instagram.*;
import com.zoyi.channel.plugin.android.util.*;
import com.zoyi.channel.plugin.android.view.dock.DockLayout;
import com.zoyi.channel.plugin.android.view.layout.PhotoViewPager;
import com.zoyi.com.annimon.stream.Stream;

import java.text.NumberFormat;
import java.util.*;

public class InstagramView extends FrameLayout implements OnInstagramThumbnailClickListener {

  public InstagramView(@NonNull Context context) {
    super(context);

    init(context);
  }

  public InstagramView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context);
  }

  public InstagramView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init(context);
  }

  private HorizontalScrollView scrollInstagramDock;
  private DockLayout dockLayout;

  private PhotoViewPager viewPager;
  private InstagramMediaAdapter adapter;

  private TextView textUsername;

  private View viewPage;
  private TextView textPage;

  private View buttonVolume;
  private ImageView iconVolume;

  private AppCompatTextView textLike;
  private AppCompatTextView textComment;

  private boolean isVolumeOn = false;

  private List<String> dataTypes = Collections.emptyList();
  private int totalPages = 0;

  @Nullable
  private String permalink;

  @Initializer
  private void init(Context context) {
    LayoutInflater.from(context).inflate(R.layout.ch_view_integration_instagram, this);

    scrollInstagramDock = findViewById(R.id.ch_scrollInstagramDock);
    dockLayout = findViewById(R.id.ch_dockInstagram);

    adapter = new InstagramMediaAdapter(context);
    viewPager = findViewById(R.id.ch_viewPagerInstagram);
    viewPager.setAdapter(adapter);
    viewPager.addOnPageChangeListener(new ViewPager.SimpleOnPageChangeListener() {
      @Override
      public void onPageSelected(int position) {
        onPageChanged(position);
      }
    });

    textUsername = findViewById(R.id.ch_textInstagramUsername);

    viewPage = findViewById(R.id.ch_viewInstagramPage);
    textPage = findViewById(R.id.ch_textInstagramPage);

    iconVolume = findViewById(R.id.ch_iconInstagramVolume);

    buttonVolume = findViewById(R.id.ch_viewInstagramVolume);
    buttonVolume.setOnClickListener(v -> {
      this.isVolumeOn = !this.isVolumeOn;

      if (iconVolume != null) {
        iconVolume.setImageResource(isVolumeOn ? R.drawable.ch_volume_up_filled_16 : R.drawable.ch_volume_off_filled_16);
      }

      if (adapter != null) {
        adapter.changeVideoVolumeState(this.isVolumeOn);
      }
    });

    textLike = findViewById(R.id.ch_textInstagramLike);
    textComment = findViewById(R.id.ch_textInstagramComment);

    findViewById(R.id.ch_layoutInstagramUsername).setOnClickListener(v -> Executor.openExternalBrowser(getContext(), this.permalink));
    findViewById(R.id.ch_layoutInstagramAction).setOnClickListener(v -> Executor.openExternalBrowser(getContext(), this.permalink));
    findViewById(R.id.ch_buttonSeeMoreInstagram).setOnClickListener(v -> Executor.openExternalBrowser(getContext(), this.permalink));
  }

  public void setInstagram(Instagram instagram) {
    if (!instagram.getData().isEmpty()) {
      setData(instagram.getData().get(0));
    }

    // set preview items
    dockLayout.removeAllViews();

    if (instagram.getData().size() > 1) {
      scrollInstagramDock.setVisibility(View.VISIBLE);
      for (InstagramData data : instagram.getData()) {
        dockLayout.addView(new InstagramPreviewItemView(getContext(), data, this));
      }
    } else {
      scrollInstagramDock.setVisibility(View.GONE);
    }

    setBorder(0);
  }

  private void setData(InstagramData data) {
    this.dataTypes = Stream.ofNullable(data.getData()).map(InstagramMediaEntity::getMediaType).toList();
    this.totalPages = data.getData().size();
    this.permalink = data.getPermalink();

    adapter.setItems(data);

    textUsername.setText(data.getUsername());

    Views.setVisibility(viewPage, data.getData().size() > 1);

    textLike.setText(NumberFormat.getInstance(Locale.US).format(data.getLikeCount()));
    textComment.setText(NumberFormat.getInstance(Locale.US).format(data.getCommentsCount()));

    onPageChanged(0);

    // https://stackoverflow.com/questions/28968512/viewpager-set-current-page-programmatically
    viewPager.post(() -> {
      viewPager.setCurrentItem(0);
    });
  }

  @Override
  public void onDataClick(InstagramData data, int position) {
    setBorder(position);

    setData(data);
  }

  private void setBorder(int position) {
    if (this.dockLayout != null) {
      for (int i = 0; i < this.dockLayout.getChildCount(); i++) {
        View child = this.dockLayout.getChildAt(i);

        if (child instanceof InstagramPreviewItemView) {
          ((InstagramPreviewItemView)child).setBorder(i == position);
        }
      }
    }
  }

  private void onPageChanged(int currentPage) {
    textPage.setText(String.format(Locale.US, "%d/%d", currentPage + 1, this.totalPages));

    Views.setVisibility(
        buttonVolume,
        currentPage < this.dataTypes.size() && Const.APP_MEDIA_INSTAGRA_MEDIA_TYPE_VIDEO.equals(this.dataTypes.get(currentPage))
    );

    if (adapter != null) {
      adapter.onPageChanged(currentPage);
    }
  }

  public void onResume() {
    if (adapter != null) {
      adapter.onResume();
    }
  }

  public void onPause() {
    if (adapter != null) {
      adapter.onPause();
    }
  }

  public void clear() {
    if (adapter != null) {
      adapter.clear();
    }
  }
}
