package com.zoyi.channel.plugin.android.view.integrations.instagram;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatImageView;
import android.view.*;
import android.widget.FrameLayout;
import android.widget.ImageView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.media.instagram.InstagramData;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.com.bumptech.glide.Glide;

public class InstagramPreviewItemView extends FrameLayout {

  private AppCompatImageView borderView;

  public InstagramPreviewItemView(@NonNull Context context, InstagramData data, OnInstagramThumbnailClickListener listener) {
    super(context);

    init(context, data, listener);
  }

  @Initializer
  private void init(Context context, InstagramData data, OnInstagramThumbnailClickListener listener) {
    LayoutInflater.from(context).inflate(R.layout.ch_view_integration_instagram_preview_item, this);

    borderView = findViewById(R.id.ch_imageInstagramPreviewBorder);
    ImageView imageView = findViewById(R.id.ch_imageInstagramPreviewItem);
    ImageView iconAlbum = findViewById(R.id.ch_iconInstagramAlbum);
    ImageView iconVideo = findViewById(R.id.ch_iconInstagramVideo);

    switch (data.getMediaType()) {
      case Const.APP_MEDIA_INSTAGRA_MEDIA_TYPE_IMAGE:
        setImage(imageView, data.getMediaUrl());
        break;

      case Const.APP_MEDIA_INSTAGRA_MEDIA_TYPE_CAROUSEL_ALBUM:
        setImage(imageView, data.getMediaUrl());
        iconAlbum.setVisibility(View.VISIBLE);
        break;

      case Const.APP_MEDIA_INSTAGRA_MEDIA_TYPE_VIDEO:
        setImage(imageView, data.getThumbnailUrl());
        iconVideo.setVisibility(View.VISIBLE);
        break;
    }

    setOnClickListener(v -> listener.onDataClick(data, ((ViewGroup) v.getParent()).indexOfChild(v)));
  }

  public void setBorder(boolean visible) {
    if (borderView != null) {
      borderView.setVisibility(visible ? View.VISIBLE : View.GONE);
    }
  }

  private void setImage(ImageView imageView, @Nullable String imageUrl) {
    if (imageUrl != null) {
      Glide.with(getContext())
          .load(imageUrl)
          .centerCrop()
          .into(imageView);
    }
  }
}
