package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.BuildConfig;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by jerry on 2018. 9. 3..
 */

public class UriUtils {

  private static final String INTENT_URI_PREFIX = "intent:";
  public static final String TEL_URI_PREFIX = "tel:";
  public static final String MAILTO_URI_PREFIX = "mailto:";
  private static final String FALLBACK_URL_PREFIX = "browser_fallback_url";

  public static boolean isIntentUri(@Nullable String uri) {
    return uri != null && uri.toLowerCase().startsWith(INTENT_URI_PREFIX);
  }
  public static boolean isMailToUri(@Nullable String uri) {
    return uri != null && uri.startsWith(MAILTO_URI_PREFIX);
  }
  public static boolean isTelUri(@Nullable String uri) {
    return uri != null && uri.startsWith(TEL_URI_PREFIX);
  }

  public static boolean doFallBack(@Nullable Context context, @Nullable Intent parsedIntent) {
    if (context == null || parsedIntent == null) {
      return false;
    }

    String fallbackUrl = parsedIntent.getStringExtra(FALLBACK_URL_PREFIX);

    if (fallbackUrl != null) {
      try {
        context.startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(fallbackUrl)));
        return true;
      } catch (Exception exception) {
      }
    }

    return false;
  }

  public static String getCloudFrontUrl(@Nullable String bucket) {
    if (bucket == null) {
      return "http:///";
    }

    switch (bucket) {
      case "bin.exp.channel.io":
        return "https://cf.exp.channel.io";

      case "bin.channel.io":
        return "https://cf.channel.io";

      default:
        return String.format("http://%s", bucket);
    }
  }

  public static String getCloudFrontUrl() {
    if ("exp".equals(BuildConfig.FLAVOR)) {
      return "https://cf.exp.channel.io";
    }
    return "https://cf.channel.io";
  }

  @Nullable
  public static String getYouTubeVideoId(@Nullable String url) {
    try {
      if (url != null) {
        String videoId = Uri.parse(url).getQueryParameter("v");

        if (videoId != null) {
          return videoId;
        }

        Matcher matcher = Pattern.compile("(?<=watch\\?v=|/videos/|embed\\/|youtu.be\\/|\\/v\\/|\\/e\\/|watch\\?v%3D|watch\\?feature=player_embedded&v=|%2Fvideos%2F|embed%\u200C\u200B2F|youtu.be%2F|%2Fv%2F)[^#\\&\\?\\n]*", Pattern.CASE_INSENSITIVE)
            .matcher(url);
        if (matcher.find()) {
          return matcher.group();
        }
      }
    } catch (Exception ex) {
    }
    return null;
  }
}
