package com.zoyi.channel.plugin.android.model.rest.media.instagram;

import android.support.annotation.Nullable;

import com.zoyi.com.google.gson.annotations.SerializedName;

public class InstagramChildrenData implements InstagramMediaEntity {

  @SerializedName("id")
  private String id;

  @SerializedName("mediaType")
  @Nullable
  private String mediaType;

  @SerializedName("thumbnailUrl")
  @Nullable
  private String thumbnailUrl;

  @SerializedName("mediaUrl")
  @Nullable
  private String mediaUrl;

  @Override
  public String getId() {
    return id;
  }

  @Override
  public String getMediaType() {
    if (mediaType != null) {
      return mediaType;
    }
    return "";
  }

  @Nullable
  @Override
  public String getThumbnailUrl() {
    return thumbnailUrl;
  }

  @Nullable
  @Override
  public String getMediaUrl() {
    return mediaUrl;
  }
}
