package com.zoyi.channel.plugin.android.model.rest;

import android.support.annotation.Nullable;
import android.widget.ImageView;

import com.zoyi.channel.plugin.android.activity.lounge.view.app_messenger.OnIntegrationClickListener;
import com.zoyi.channel.plugin.android.model.entity.Contact;
import com.zoyi.channel.plugin.android.open.option.Language;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.util.UriUtils;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;

public class AppMessenger implements Contact {

  private String iconKey;
  private String name;
  private I18n pluginTextI18n;

  public String getIconKey() {
    return iconKey;
  }

  @Nullable
  private String title;

  @Nullable
  @Override
  public String getTitle() {
    return title;
  }

  public AppMessenger setTitle(Language language) {
    this.title = pluginTextI18n.get(language.toString());
    return this;
  }

  @Nullable
  @Override
  public String getDescription() {
    return null;
  }

  @Override
  public void setIcon(ImageView imageView) {
    Glide.with(imageView.getContext())
        .load(UriUtils.getCloudFrontUrl() + "/" + iconKey)
        .dontAnimate()
        .diskCacheStrategy(DiskCacheStrategy.RESULT)
        .into(imageView);
  }

  @Override
  public void doAction(@Nullable OnIntegrationClickListener listener) {
    if (listener != null) {
      listener.onMessengerClick(name);
    }
  }
}
