package com.zoyi.channel.plugin.android.model.repo;

import com.zoyi.channel.plugin.android.model.rest.SupportBotEntry;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.store.*;
import com.zoyi.com.annimon.stream.Stream;

import java.util.List;

public class LoungeRepo extends BaseRepo {

  private Channel channel;
  private Plugin plugin;
  private Bot bot;
  private List<Manager> operators;
  private SupportBotEntry supportBot;
  private List<AppMessenger> appMessengers;
  private List<String> loungeMediaTypes;

  public Channel getChannel() {
    return channel;
  }

  public Plugin getPlugin() {
    return plugin;
  }

  public Bot getBot() {
    return bot;
  }

  public List<String> getLoungeMediaTypes() {
    return loungeMediaTypes;
  }

  @Override
  public void set() {
    PluginStore.get().pluginState.set(plugin);
    ChannelStore.get().channelState.set(channel);
    AppMessengerStore.get().appMessengers.set(appMessengers);
    BotStore.get().bots.upsert(bot);
    if (bot != null) {
      BotStore.get().defaultBotId.set(bot.getId());
    } else {
      BotStore.get().defaultBotId.set(null);
    }
    SupportBotStore.get().supportBotState.set(supportBot);
    if (supportBot != null) {
      BotStore.get().bots.upsert(supportBot.getBot());
    }

    if (operators != null) {
      List<String> followingManagerIds = Stream.of(operators).filter(manager -> manager.getId() != null).map(Manager::getId).toList();

      ManagerStore.get().managers.add(operators);
      ManagerStore.get().followingManagerIds.set(followingManagerIds);
    }
  }
}
