package com.zoyi.channel.plugin.android.deserializer;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.LoungeMedia;
import com.zoyi.channel.plugin.android.model.rest.media.dummy.DummyMedia;
import com.zoyi.channel.plugin.android.model.rest.media.instagram.Instagram;
import com.zoyi.com.google.gson.*;

import java.lang.reflect.Type;

public class LoungeMediaDeserializer implements JsonDeserializer<LoungeMedia> {

  private Gson gson;

  public LoungeMediaDeserializer() {
    this.gson = new Gson();
  }

  @Override
  public LoungeMedia deserialize(
      JsonElement json,
      Type type,
      JsonDeserializationContext jsonDeserializationContext
  ) throws JsonParseException {
    JsonObject obj = json.getAsJsonObject();

    if (obj != null && obj.has("type")) {
      String loungeMediaType = obj.get("type").getAsString();

      if (loungeMediaType != null) {
        switch (loungeMediaType) {
          case Const.APP_MEDIA_INSTAGRAM:
            return gson.fromJson(json, Instagram.class);
        }
      }
    }
    return new DummyMedia();
  }
}
