package com.zoyi.channel.plugin.android.activity.lounge.view.lounge_media;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.common.error.ErrorRefreshContentView;
import com.zoyi.channel.plugin.android.activity.common.error.OnErrorRefreshClickListener;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.selector.SettingsSelector;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;

public class LoungeMediaErrorCardView extends FrameLayout implements ErrorRefreshContentView {

  private TextView textDesc;

  @Nullable
  private OnErrorRefreshClickListener listener;

  @Nullable
  private Binder binder;

  @Nullable
  private String type;

  public LoungeMediaErrorCardView(Context context) {
    super(context);
    init(context);
  }

  public LoungeMediaErrorCardView(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public LoungeMediaErrorCardView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  @Initializer
  private void init(Context context) {
    View root = LayoutInflater.from(context).inflate(R.layout.ch_view_lounge_media_error_card, this, true);

    root.findViewById(R.id.ch_imageLoungeMediaError).setOnClickListener(v -> {
      if (listener != null) {
        listener.onRefreshClick();
      }
    });

    root.findViewById(R.id.ch_textLoungeMediaErrorRefresh).setOnClickListener(v -> {
      if (listener != null) {
        listener.onRefreshClick();
      }
    });

    textDesc = root.findViewById(R.id.ch_textLoungeMediaErrorDescription);
    textDesc.setOnClickListener(v -> {
      if (listener != null) {
        listener.onRefreshClick();
      }
    });
  }

  @Override
  protected void onAttachedToWindow() {
    super.onAttachedToWindow();

    binder = SettingsSelector.bindLanguage(language -> {
      updateDescription();
    });
  }

  @Override
  protected void onDetachedFromWindow() {
    if (binder != null) {
      binder.unbind();
      binder = null;
    }

    super.onDetachedFromWindow();
  }

  @Override
  public void setOnErrorRefreshClickListener(@Nullable OnErrorRefreshClickListener listener) {
    this.listener = listener;
  }

  public void setLoungeMediaType(String type) {
    this.type = type;

    updateDescription();
  }

  private void updateDescription() {
    if (Const.APP_MEDIA_INSTAGRAM.equals(type)) {
      textDesc.setText(String.format(
          ResUtils.getString(getContext(), "ch.lounge.media.error"),
          ResUtils.getString(getContext(), "ch.lounge.media.error.instagram")
      ));
    }
  }
}
